breed [ players player ]
breed [ knights knight ]
breed [ pirates pirate ]
breed [ bases base]
breed [ ninjas ninja ]
players-own [name plans last-used last-error ready-to-pause]
knights-own [owner plan health speed target targeted-by last-defended]
pirates-own [owner plan health speed target targeted-by last-defended]
ninjas-own [owner plan health speed target targeted-by last-defended]
bases-own [owner plan health targeted-by]
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;Functions beginning with __ are so named because otherwise they would sound like functions that would be called by players.
;;For purposes of game design and balance, these functions should not be called by players.
to __make-knight  ;;Base procedure
  hatch-knights 1
  [
    set owner [owner] of myself
    set color [color] of owner
    set speed knight-speed
    set health knight-attack-strength
    set target nobody
    set last-defended nobody
    set targeted-by []
    set size 2
  ]
end
to __make-pirate ;;Base procedure
  hatch-pirates 1
  [
    set owner [owner] of myself
    set color [color] of owner
    set speed pirate-speed
    set health pirate-health
    set target nobody
    set last-defended nobody
    set targeted-by []
    set size 5
  ]
end
to __make-ninja ;;Base procedure
  hatch-ninjas 1
  [
    set owner [owner] of myself
    set color [color] of owner
    set speed ninja-speed
    set health ninja-health
    set target nobody
    set last-defended nobody
    set targeted-by []
    set size 2
  ]
end
to __target [targ] ;;Unit procedure
  if target != nobody [ask target [set targeted-by remove myself targeted-by]]
  set target targ
  ask target [set targeted-by lput myself targeted-by]
end
to __attack ;;Unit procedure
  __move-towards-target
  if target != nobody
  [
    ifelse breed = knights
    [
      if distance target < knight-attack-range
      [
        ask target
        [
          set health health - knight-attack-strength
          ask turtles with [breed != players and color = [color] of myself]
          [
            set health health + knight-heal-amount
          ]
        ]
      ]
    ]
    [
      ifelse breed = pirates
      [
        if distance target < pirate-attack-range [ask turtles with [breed != players and color != [color] of myself] [set health health - pirate-attack-strength]]
      ]
      [
        if breed = ninjas
        [
          if not member? target bases with [color != [color] of myself] [if distance target < ninja-attack-range [ask target [set health health - ninja-attack-strength]]]
        ]
      ]
    ]
  ]
end
to __move-towards-target ;;Unit procedure
  if target != nobody
  [
    ifelse distance target > [size] of target
    [
      set heading towards target + random (21) - 10
      fd min list speed distance target
    ]
    [
      setxy (xcor + (random-float .5) - .25) (ycor + (random-float .5) - .25)
      set heading towards target
    ]
  ]
end
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
to startup
  hubnet-set-client-interface "COMPUTER" []
end
to setup
  ca
  set-default-shape bases "house"
  set-default-shape knights "sword"
  set-default-shape pirates "crossbones"
  set-default-shape ninjas "ninja-star"
  create-bases base-count
  [ ;These are initially neutral bases
    set owner self
    setxy random 150 random 150
    set color white
    set size 2
    set health 10
    set targeted-by []
  ]
end
to-report load-file [filename]
  let ret ""
  file-open filename
  while [not file-at-end?]
  [
    set ret word ret file-read-line
    set ret word ret " \\n "
  ]
  file-close
  report ret
end
to listen-clients
  while [ hubnet-message-waiting? ]
  [
    hubnet-fetch-message
    ifelse hubnet-enter-message?
    [ create-new-student ]
    [
      ifelse hubnet-exit-message?
      [ remove-student ]
      [ execute-command hubnet-message-tag ]
    ]
  ]
end
to create-new-student
  create-players 1
  [
    set name hubnet-message-source
    set plans (list "move-random" )
    set plans lput "produce-knights" plans
    set plans lput "move-random" plans
    set plans lput "move-random" plans
    set color (count players - 1) * 10 + 5
    set ready-to-pause false
    hubnet-send name "your-color" color
    set last-error ""
    hatch-bases 1
    [
      set owner myself
      setxy random 150 random 150
      set color [color] of owner
      set size 2
      set health 10
      set targeted-by []
    ]
    ht
  ]
end
to remove-student
  let leaving-player lookup-player hubnet-message-source
  if leaving-player != nobody
  [
    ask leaving-player
    [
      ask turtles with [breed != players and owner = myself] [die]
      die
    ]
  ]
end
to-report lookup-player [player-name]
  let player nobody
  ask players
  [
    if name = player-name [set player self]
  ]
  report player
end
to-report atoi [brd]
  if brd = "knights" or brd = knights [report 0]
  if brd = "bases" or brd = bases [report 1]
  if brd = "pirates" or brd = pirates [report 2]
  if brd = "ninjas" or brd = ninjas [report 3]
end
to go
  listen-clients
  do-plans
  fix-turtles
  update-counts
  if not any? players with [not ready-to-pause]
  [
    while [any? players with [ready-to-pause]]
    [
      listen-clients
      wait 1
    ]
  ]
end
to fix-turtles
  ask turtles with [breed != players and breed != bases and health < 0]
  [
    if target != nobody 
    [
      ask target
      [  set targeted-by remove myself targeted-by ]
    ]
    foreach targeted-by [ask ? [set target nobody]]
    die
  ]
  ask bases with [health < 0]
  [
    let killer one-of targeted-by
    hatch-bases 1
    [
      set owner [owner] of killer
      set color [color] of owner
      set size 2
      set health base-health
      set targeted-by []
    ]
    foreach targeted-by [ask ? [set target nobody]]
    die
  ]
end
to execute-command [comm]
    ifelse hubnet-message-tag = "comm"
    [
      ask lookup-player hubnet-message-source [set plans replace-item atoi last-used plans hubnet-message]
    ]
    [
      ifelse hubnet-message-tag = "ready-to-pause"
      [
        ifelse hubnet-message
        [
          ask lookup-player hubnet-message-source [set ready-to-pause true]
        ]
        [
          ask lookup-player hubnet-message-source [set ready-to-pause false]
        ]
      ]
      [
        let msg ""
        ask lookup-player hubnet-message-source [set msg item atoi hubnet-message-tag plans set last-used hubnet-message-tag]
        hubnet-send hubnet-message-source "comm" msg
      ]
    ]
end
to do-plans
  ask players
  [
    carefully
    [
      ask turtles with [breed != players and owner = myself]
      [
        run item atoi breed [plans] of owner
      ]
    ]
    [
      hubnet-send name "error-message" error-message
    ]
  ]
end
to update-counts
  ask players
  [
    hubnet-send name "base-count" count bases with [owner = myself]
    hubnet-send name "knight-count" count knights with [owner = myself]
    hubnet-send name "pirate-count" count pirates with [owner = myself]
    hubnet-send name "ninja-count" count ninjas with [owner = myself]
  ]
end
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;These functions are provided for players.
to move-random
  rt random (30) - 15
  fd speed
end
to produce-knights
  if random knight-produce-chance = 0 [__make-knight ]
end
to produce-pirates
  if random pirate-produce-chance = 0 [ __make-pirate]
end
to produce-ninjas
  if random ninja-produce-chance = 0 [__make-ninja]
end
to attack [new-target]
  __target new-target
  __attack
end
to attack-any [target-type]
  if target = nobody or not member? target target-type ;If old target isn't a member of new target, change target
  [
    ifelse any? target-type with [ color != [color] of myself]
    [ __target min-one-of target-type with [ color != [color] of myself] [distance myself] ]
    [set target nobody]
  ]
  __attack
end
to defend [the-vic]
  ifelse length [targeted-by] of the-vic > 0
  [attack one-of [targeted-by] of the-vic]
  [set target nobody]
end
to defend-any [vic-type]
  let defense-targets vic-type with [color = [color] of myself]
  if any? defense-targets
  [
    attack-any turtles with [breed != players and breed != bases and color != [color] of myself and target != nobody and member? target defense-targets]
  ]
end
to ninja-hide
  if breed = ninjas [ht]
end
to ninja-show
  if breed = ninjas [st]
end
@#$#@#$#@
GRAPHICS-WINDOW
181
52
611
503
17
17
12.0
1
10
1
1
1
0
1
1
1
-17
17
-17
17
0
0
1
ticks
CC-WINDOW
5
748
620
843
Command Center
0
BUTTON
15
128
116
161
Start Game
go
T
1
T
OBSERVER
NIL
NIL
NIL
NIL
BUTTON
13
83
137
116
Setup Phase
listen-clients
T
1
T
OBSERVER
NIL
NIL
NIL
NIL
BUTTON
13
24
119
57
Start Server
setup\\nhubnet-reset
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL
SLIDER
388
10
560
43
base-health
base-health
1
500
201
1
1
NIL
HORIZONTAL
SLIDER
21
517
200
550
knight-health
knight-health
0.01
5
2.51
0.1
1
NIL
HORIZONTAL
SLIDER
21
552
200
585
knight-attack-strength
knight-attack-strength
0
2
0.4
0.05
1
NIL
HORIZONTAL
SLIDER
201
14
373
47
base-count
base-count
0
100
10
1
1
NIL
HORIZONTAL
SLIDER
21
587
200
620
knight-attack-range
knight-attack-range
0.25
5
2.5
0.25
1
NIL
HORIZONTAL
SLIDER
21
622
200
655
knight-speed
knight-speed
0.25
5
1
0.25
1
NIL
HORIZONTAL
SLIDER
215
517
399
550
pirate-health
pirate-health
0.25
10
10
0.25
1
NIL
HORIZONTAL
SLIDER
215
552
400
585
pirate-attack-strength
pirate-attack-strength
0.25
5
1
0.25
1
NIL
HORIZONTAL
SLIDER
215
587
400
620
pirate-attack-range
pirate-attack-range
0.25
5
2.5
0.25
1
NIL
HORIZONTAL
SLIDER
215
622
400
655
pirate-speed
pirate-speed
0
5
0.25
0.25
1
NIL
HORIZONTAL
SLIDER
413
517
591
550
ninja-health
ninja-health
0
0.25
0.25
0.25
1
NIL
HORIZONTAL
SLIDER
413
552
591
585
ninja-attack-strength
ninja-attack-strength
0
5
0.1
0.05
1
NIL
HORIZONTAL
SLIDER
413
588
592
621
ninja-attack-range
ninja-attack-range
0
5
5
0.25
1
NIL
HORIZONTAL
SLIDER
413
622
592
655
ninja-speed
ninja-speed
0.25
5
2
0.25
1
NIL
HORIZONTAL
SLIDER
21
701
201
734
knight-heal-amount
knight-heal-amount
0
5
0
0.25
1
NIL
HORIZONTAL
SLIDER
21
657
200
690
knight-produce-chance
knight-produce-chance
0
500
250
1
1
NIL
HORIZONTAL
SLIDER
215
657
400
690
pirate-produce-chance
pirate-produce-chance
0
1000
100
1
1
NIL
HORIZONTAL
SLIDER
413
657
592
690
ninja-produce-chance
ninja-produce-chance
0
1000
7
1
1
NIL
HORIZONTAL
@#$#@#$#@
VERSION
-------
$Id: PNK.nlogo 39722 2008-05-01 18:38:33Z everreau $

WHAT IS IT?
-----------
This model is a simple implementation of a "real-time strategy" type game.  It is designed to teach NetLogo and be fun (in that order.)  It is a strictly HubNet model.  The idea is that students represent competing armies in the playing field.  The goal is to capture all of the bases (by attacking them and thus winning them to your side.)  The player can command three different types of units: pirates, knights, and ninjas.  They have special attributes as follows:
Pirates are slow.  However, when they attack, they damage all enemy units in range, not just the specific unit they are attacking.
Knights are medium speed.  They are considered to be helpful knights, and thus automatically heal nearby friendly units.
Ninjas are very quick, but can't attack bases.  They have ninja magic, however, that allows them to disappear and reappear at will.  Other units can still attack invisible ninjas, but the user obviously doesn't know where they are.
More tradition RTS games are controlled by selecting a unit with the mouse and giving it commands.  PKN is instead controlled by issuing NetLogo commands to each type of unit.  Individual units are not selectable; strategies automatically apply to the entire unit type.  (There are ways to programmatically command half of the pirates attack bases, for example, while the other half defends your own bases.)  While a basic strategy requires no more NetLogo knowledge than using the provided attack-any and defend-any commands, more advanced strategies naturally require more advanced NetLogo mastery.

HOW IT WORKS
------------
At each timestep, all of the units perform the actions stored in their "plan".  While the simulation is running (or paused), the user can click one of the buttons to get a copy of that unit's current plan.  The user can then modify the plan, and hit the done button to submit it back to the server.  From then on, the user's units will perform the new plan.  This allows the user to adopt a general strategy (attack the opponents' bases), but also react to current developments (defend your especially endangered base.)  Once all of the units of a player are destroyed, that player is done.  When only one player remains, the game is over.

HOW TO USE IT
-------------
To use this model, click the Start Server button and initialize the server.  Now, click the Setup Phase button, and tell the users to join.  During this time, no code is actually executed, but the users can modify the plans for their units.  Once players are satisfied with their initial plans for attack, unclick the Setup Phase button, and click the Start Game button.  The model will then be running, with each players' units acting appropriately.  If there is an error in the code for a player, that breed of the player's doesn't move, and the error message is passed to the player.  The player can then correct the code and resubmit to the server.  If a player wishes to pause the game (to allow more measured strategizing and programming), the user can set their "ready-to-pause" switch to true.  If all players have this set to true, the game will pause.  It will remain paused until ALL players set their switch to off.
To capture a base (either a white neutral base or a colored enemy base), simply attack it like you would any other unit.  When a base is conquered, it becomes owner by a random one of the attack units.
Note: Ninjas can't attack bases.
The attack-any and defend-any commands make sure you don't accidentally attack your own team or heal an enemy team.  The attack and defend commands don't take care of this for you.
Similarly, the attack-any and defend-any attempt to target intentionally.  (They will target the nearest available appropriate enemy and will switch targets when necessary)  The attack and defend commands make no such promises.

THINGS TO TRY
-------------
Try to develop more complicated strategies.  You can be especially devious with the ninjas.

EXTENDING THE MODEL
-------------------
You can extend this model in a myriad number of ways.
For example, you could:
Add new units.
Add new base types.
Rewrite the production model.
Modify the attack-any, defend-any, etc. commands.
Add new attack styles.
Implement anti-cheating checks.
Remove the checks from attack-any and defend-any that take care of inappropriate targeting (attacking your own team, healing the other team.)
Show damage on units.

NETLOGO FEATURES
----------------
Because of a lack of structures in NetLogo, a "players" breed was used to act as a struct.  This breed is never shown or really interacted with; it's just used to store information relevant to each player.  This is definitely a hack.
A lot of the __make-* code is duplicated; some kind of OOP inheritance here would've been neat.
Sometimes the hubnet-exit-message was getting fired more than once for the same client, so I had to write a little extra code to deal with that.
The carefully command is used to execute each units' code; therefore, if there is an error, we can convey it to the user instead of crashing.
RELATED MODELS
--------------
This is related to an unpublished model that implemented a HubNet version of the Prisoner's Dilemma.  I believe it was written by Andrei Scheinkman.

CREDITS AND REFERENCES
----------------------
This model was designed by Nate Nichols for MAM, Fall '05.
@#$#@#$#@
default
true
0
Polygon -7500403 true true 150 5 40 250 150 205 260 250
airplane
true
0
Polygon -7500403 true true 150 0 135 15 120 60 120 105 15 165 15 195 120 180 135 240 105 270 120 285 150 270 180 285 210 270 165 240 180 180 285 195 285 165 180 105 180 60 165 15
arrow
true
0
Polygon -7500403 true true 150 0 0 150 105 150 105 293 195 293 195 150 300 150
bow
true
0
Polygon -7500403 true true 109 52 159 54 199 80 232 139 239 191 212 244 155 274 123 279 111 277 110 268 142 263 182 252 210 232 222 203 225 175 224 157 218 132 202 118 190 97 162 75 136 65 112 62 109 50
Polygon -7500403 true true 113 58 113 273 117 271 117 56
box
false
0
Polygon -7500403 true true 150 285 285 225 285 75 150 135
Polygon -7500403 true true 150 135 15 75 150 15 285 75
Polygon -7500403 true true 15 75 15 225 150 285 150 135
Line -16777216 false 150 285 150 135
Line -16777216 false 150 135 15 75
Line -16777216 false 150 135 285 75
bug
true
0
Circle -7500403 true true 96 182 108
Circle -7500403 true true 110 127 80
Circle -7500403 true true 110 75 80
Line -7500403 true 150 100 80 30
Line -7500403 true 150 100 220 30
butterfly
true
0
Polygon -7500403 true true 150 165 209 199 225 225 225 255 195 270 165 255 150 240
Polygon -7500403 true true 150 165 89 198 75 225 75 255 105 270 135 255 150 240
Polygon -7500403 true true 139 148 100 105 55 90 25 90 10 105 10 135 25 180 40 195 85 194 139 163
Polygon -7500403 true true 162 150 200 105 245 90 275 90 290 105 290 135 275 180 260 195 215 195 162 165
Polygon -16777216 true false 150 255 135 225 120 150 135 120 150 105 165 120 180 150 165 225
Circle -16777216 true false 135 90 30
Line -16777216 false 150 105 195 60
Line -16777216 false 150 105 105 60
car
false
0
Polygon -7500403 true true 300 180 279 164 261 144 240 135 226 132 213 106 203 84 185 63 159 50 135 50 75 60 0 150 0 165 0 225 300 225 300 180
Circle -16777216 true false 180 180 90
Circle -16777216 true false 30 180 90
Polygon -16777216 true false 162 80 132 78 134 135 209 135 194 105 189 96 180 89
Circle -7500403 true true 47 195 58
Circle -7500403 true true 195 195 58
circle
false
0
Circle -7500403 true true 0 0 300
circle 2
false
0
Circle -7500403 true true 0 0 300
Circle -16777216 true false 30 30 240
cow
false
0
Polygon -7500403 true true 200 193 197 249 179 249 177 196 166 187 140 189 93 191 78 179 72 211 49 209 48 181 37 149 25 120 25 89 45 72 103 84 179 75 198 76 252 64 272 81 293 103 285 121 255 121 242 118 224 167
Polygon -7500403 true true 73 210 86 251 62 249 48 208
Polygon -7500403 true true 25 114 16 195 9 204 23 213 25 200 39 123
crossbones
true
0
Polygon -7500403 true true 118 178 117 136 101 123 91 91 107 67 138 51 189 53 219 86 220 108 198 133 181 138 170 144 165 179
Polygon -16777216 true false 129 78 120 85 124 93 140 92 141 85 140 80 133 79
Polygon -16777216 true false 172 76 163 83 167 91 183 90 184 83 183 78 176 77
Polygon -16777216 true false 140 122 148 105 152 122
Polygon -7500403 true true 207 244 88 190 90 168 66 168 65 178 77 196 58 200 50 210 66 220 82 209 197 262 192 279 218 284 219 278 214 264 224 261 235 254 224 234
Polygon -7500403 true true 93 244 212 190 210 168 234 168 235 178 223 196 242 200 250 210 234 220 218 209 103 262 108 279 82 284 81 278 86 264 76 261 65 254 76 234
cylinder
false
0
Circle -7500403 true true 0 0 300
dot
false
0
Circle -7500403 true true 90 90 120
face happy
false
0
Circle -7500403 true true 8 8 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Polygon -16777216 true false 150 255 90 239 62 213 47 191 67 179 90 203 109 218 150 225 192 218 210 203 227 181 251 194 236 217 212 240
face neutral
false
0
Circle -7500403 true true 8 7 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Rectangle -16777216 true false 60 195 240 225
face sad
false
0
Circle -7500403 true true 8 8 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Polygon -16777216 true false 150 168 90 184 62 210 47 232 67 244 90 220 109 205 150 198 192 205 210 220 227 242 251 229 236 206 212 183
fish
false
0
Polygon -1 true false 44 131 21 87 15 86 0 120 15 150 0 180 13 214 20 212 45 166
Polygon -1 true false 135 195 119 235 95 218 76 210 46 204 60 165
Polygon -1 true false 75 45 83 77 71 103 86 114 166 78 135 60
Polygon -7500403 true true 30 136 151 77 226 81 280 119 292 146 292 160 287 170 270 195 195 210 151 212 30 166
Circle -16777216 true false 215 106 30
flag
false
0
Rectangle -7500403 true true 60 15 75 300
Polygon -7500403 true true 90 150 270 90 90 30
Line -7500403 true 75 135 90 135
Line -7500403 true 75 45 90 45
flower
false
0
Polygon -10899396 true false 135 120 165 165 180 210 180 240 150 300 165 300 195 240 195 195 165 135
Circle -7500403 true true 85 132 38
Circle -7500403 true true 130 147 38
Circle -7500403 true true 192 85 38
Circle -7500403 true true 85 40 38
Circle -7500403 true true 177 40 38
Circle -7500403 true true 177 132 38
Circle -7500403 true true 70 85 38
Circle -7500403 true true 130 25 38
Circle -7500403 true true 96 51 108
Circle -16777216 true false 113 68 74
Polygon -10899396 true false 189 233 219 188 249 173 279 188 234 218
Polygon -10899396 true false 180 255 150 210 105 210 75 240 135 240
house
false
0
Rectangle -7500403 true true 45 120 255 285
Rectangle -16777216 true false 120 210 180 285
Polygon -7500403 true true 15 120 150 15 285 120
Line -16777216 false 30 120 270 120
leaf
false
0
Polygon -7500403 true true 150 210 135 195 120 210 60 210 30 195 60 180 60 165 15 135 30 120 15 105 40 104 45 90 60 90 90 105 105 120 120 120 105 60 120 60 135 30 150 15 165 30 180 60 195 60 180 120 195 120 210 105 240 90 255 90 263 104 285 105 270 120 285 135 240 165 240 180 270 195 240 210 180 210 165 195
Polygon -7500403 true true 135 195 135 240 120 255 105 255 105 285 135 285 165 240 165 195
line
true
0
Line -7500403 true 150 0 150 300
line half
true
0
Line -7500403 true 150 0 150 150
ninja-star
true
0
Polygon -7500403 true true 89 150 134 135 148 86 165 135 211 150 89 150
Polygon -7500403 true true 92 149 137 164 151 213 168 164 214 149 92 149
pentagon
false
0
Polygon -7500403 true true 150 15 15 120 60 285 240 285 285 120
person
false
0
Circle -7500403 true true 110 5 80
Polygon -7500403 true true 105 90 120 195 90 285 105 300 135 300 150 225 165 300 195 300 210 285 180 195 195 90
Rectangle -7500403 true true 127 79 172 94
Polygon -7500403 true true 195 90 240 150 225 180 165 105
Polygon -7500403 true true 105 90 60 150 75 180 135 105
plant
false
0
Rectangle -7500403 true true 135 90 165 300
Polygon -7500403 true true 135 255 90 210 45 195 75 255 135 285
Polygon -7500403 true true 165 255 210 210 255 195 225 255 165 285
Polygon -7500403 true true 135 180 90 135 45 120 75 180 135 210
Polygon -7500403 true true 165 180 165 210 225 180 255 120 210 135
Polygon -7500403 true true 135 105 90 60 45 45 75 105 135 135
Polygon -7500403 true true 165 105 165 135 225 105 255 45 210 60
Polygon -7500403 true true 135 90 120 45 150 15 180 45 165 90
square
false
0
Rectangle -7500403 true true 30 30 270 270
square 2
false
0
Rectangle -7500403 true true 30 30 270 270
Rectangle -16777216 true false 60 60 240 240
star
false
0
Polygon -7500403 true true 151 1 185 108 298 108 207 175 242 282 151 216 59 282 94 175 3 108 116 108
sword
true
0
Polygon -7500403 true true 150 59 135 89 135 179 120 179 120 194 142 194 142 224 157 224 157 194 180 194 180 179 165 179 165 89 150 59 150 60
target
false
0
Circle -7500403 true true 0 0 300
Circle -16777216 true false 30 30 240
Circle -7500403 true true 60 60 180
Circle -16777216 true false 90 90 120
Circle -7500403 true true 120 120 60
tree
false
0
Circle -7500403 true true 118 3 94
Rectangle -6459832 true false 120 195 180 300
Circle -7500403 true true 65 21 108
Circle -7500403 true true 116 41 127
Circle -7500403 true true 45 90 120
Circle -7500403 true true 104 74 152
triangle
false
0
Polygon -7500403 true true 150 30 15 255 285 255
triangle 2
false
0
Polygon -7500403 true true 150 30 15 255 285 255
Polygon -16777216 true false 151 99 225 223 75 224
truck
false
0
Rectangle -7500403 true true 4 45 195 187
Polygon -7500403 true true 296 193 296 150 259 134 244 104 208 104 207 194
Rectangle -1 true false 195 60 195 105
Polygon -16777216 true false 238 112 252 141 219 141 218 112
Circle -16777216 true false 234 174 42
Rectangle -7500403 true true 181 185 214 194
Circle -16777216 true false 144 174 42
Circle -16777216 true false 24 174 42
Circle -7500403 false true 24 174 42
Circle -7500403 false true 144 174 42
Circle -7500403 false true 234 174 42
turtle
true
0
Polygon -10899396 true false 215 204 240 233 246 254 228 266 215 252 193 210
Polygon -10899396 true false 195 90 225 75 245 75 260 89 269 108 261 124 240 105 225 105 210 105
Polygon -10899396 true false 105 90 75 75 55 75 40 89 31 108 39 124 60 105 75 105 90 105
Polygon -10899396 true false 132 85 134 64 107 51 108 17 150 2 192 18 192 52 169 65 172 87
Polygon -10899396 true false 85 204 60 233 54 254 72 266 85 252 107 210
Polygon -7500403 true true 119 75 179 75 209 101 224 135 220 225 175 261 128 261 81 224 74 135 88 99
wheel
false
0
Circle -7500403 true true 3 3 294
Circle -16777216 true false 30 30 240
Line -7500403 true 150 285 150 15
Line -7500403 true 15 150 285 150
Circle -7500403 true true 120 120 60
Line -7500403 true 216 40 79 269
Line -7500403 true 40 84 269 221
Line -7500403 true 40 216 269 79
Line -7500403 true 84 40 221 269
x
false
0
Polygon -7500403 true true 270 75 225 30 30 225 75 270
Polygon -7500403 true true 30 75 75 30 270 225 225 270
@#$#@#$#@
NetLogo 4.1pre1
@#$#@#$#@
@#$#@#$#@
@#$#@#$#@
@#$#@#$#@
BUTTON
114
21
234
54
knights
NIL
NIL
1
T
OBSERVER
NIL
NIL
INPUTBOX
17
68
317
413
comm
null
1
1
String (commands)
MONITOR
449
432
520
481
your-color
NIL
0
1
MONITOR
14
426
410
475
error-message
NIL
3
1
BUTTON
33
20
99
53
bases
NIL
NIL
1
T
OBSERVER
NIL
NIL
BUTTON
253
25
323
58
pirates
NIL
NIL
1
T
OBSERVER
NIL
NIL
MONITOR
355
69
432
118
base-count
NIL
0
1
MONITOR
358
146
439
195
knight-count
NIL
0
1
MONITOR
358
213
438
262
pirate-count
NIL
0
1
MONITOR
360
276
434
325
ninja-count
NIL
0
1
BUTTON
339
25
403
58
ninjas
NIL
NIL
1
T
OBSERVER
NIL
NIL
SWITCH
353
354
495
387
ready-to-pause
ready-to-pause
1
1
-1000
TEXTBOX
488
38
638
278
Commands:\\n\\nAll soldiers:\\nattack-any (agentset)\\nattack (agent)\\ndefend-any (agentset)\\ndefend (agent)\\n\\nBases:\\nproduce-knights\\nproduce-pirates\\nproduce-ninjas\\n\\nNinjas:\\nninja-hide\\nninja-show
11
0.0
0
@#$#@#$#@
default
0.0
-0.2 0 1.0 0.0
0.0 1 1.0 0.0
0.2 0 1.0 0.0
link direction
true
0
Line -7500403 true 150 150 90 180
Line -7500403 true 150 150 210 180
@#$#@#$#@
