globals 
[
  ltotal
  rtotal
  nlsick
  nrsick
  nldead
  nrdead
  lrsick
  rrsick
  lrdead
  rrdead
]
breed [people person]
breed [stores store]
breed [parks park]
breed [dumps dump]
breed [ghosts ghost]
breed [fits fit]
breed [docs doc]

turtles-own
[
  sick?
  dead?
  left?
  right?
  lsick?
  rsick?
  ldead?
  rdead?
  health
]

to setup
  
  __clear-all-and-reset-ticks
  ask patches
  [set pcolor 3
    if pxcor =  0 [set pcolor red]
    if pycor = -20 and pxcor < 0 [set pcolor green]
    if pxcor = 2 and pycor < -10 [set pcolor black]
    if pycor =  pxcor - 13 and pxcor > 3 [set pcolor black]
    if pycor =  pxcor - 12 and pxcor > 3 [set pcolor black]
    if pycor + pxcor =  -6 and pxcor > 3 [set pcolor black]
    if pycor + pxcor =  -7 and pxcor > 3 [set pcolor black]
    if pycor = -10 and pxcor > -2 and pxcor < 4 [set pcolor black]
    if pxcor = -2 and pycor > -12 and pycor < -6 [set pcolor black]
    if pycor =  pxcor - 9 and pxcor < -2 [set pcolor black]
    if pycor =  pxcor - 8 and pxcor < -2 [set pcolor black]
    if pycor =  pxcor - 11 and pxcor > 1 [set pcolor green]
    if pycor =  pxcor - 10 and pxcor > 10 [set pcolor green]
    if pxcor = 15 and pycor = -10 [set pcolor green]
    if pxcor = 16 and pycor = -10 [set pcolor green]
    if pxcor = 15 and pycor = -9 [set pcolor green]
    if pxcor = 16 and pycor = -9 [set pcolor green]
    if pxcor = 17 and pycor = -10 [set pcolor green]
    if pxcor = -10 and pycor > 10 [set pcolor green]
    if pxcor = -11 and pycor > 10 [set pcolor green]
    if pxcor = -9 and pycor > 10 [set pcolor green]
    ]
  setup-world
end

to setup-world
  set-default-shape people "person"
  set-default-shape stores "building store"
    set-default-shape parks "tree"
  set-default-shape dumps "cow skull"
  set-default-shape fits "bike"
  set-default-shape docs "person doctor"
  create-stores 4 [setxy random 20 random-pycor set size 3 set color yellow]
  create-stores 4 [setxy random -20 random-pycor set size 3 set color yellow]
  create-stores 1 [setxy 0 random-pycor set size 3 set color yellow]
  create-dumps 2 [setxy random 20 random-pycor set size 1 set color white]
  create-dumps 2 [setxy random -20 random-pycor set size 1 set color white]
  create-dumps 1 [setxy 0 random-pycor set size 1 set color white]
  create-fits 4 [setxy random 20 random-pycor set size 2 set color 125]
  create-fits 4 [setxy random -20 random-pycor set size 2 set color 125]
  create-docs 28 [setxy random 20 random-pycor set size 1.5 set color white]
  create-docs 28 [setxy random -20 random-pycor set size 1.5 set color white]
  create-docs 1 [setxy 0 random-pycor set size 1.5 set color white]
  create-some-people
  
end

to create-some-people
  create-people npeople
  [
    setxy random-pxcor random-pycor
    set color 36
    set size 1.5
    set heading 90 * random 4
    set sick? false
    set dead? false
    set lsick? false
    set ldead? false
    set rsick? false
    set rdead? false
    set health 100
    if xcor < 0 [set left? true set right? false]
    if xcor > 0 [set right? true set left? false]
    if xcor = 0 [set left? false set right? false]
  ]
end

to go
  if not any? people [ stop ]
  if (nldead + nrdead) > 100 [stop]
  people-wander
  tick
  ;;do-plot
end

to people-wander
  ask people 
  [
  if health < 0
    [set shape "ghost" set size 1]
  if health > 0
    [rt 90 * random 4
    fd 1]
 if health < 100 and health > 0 and random-float 100 < precover 
    [set health 100] 
    
  if health > 0 and random-float 100 < preproduce
    [hatch 1 [set health 100]]
    
  if health > 0 and random-float 100 < psick 
    [set health (health - random-float 100)]
    
  let storecare one-of stores in-radius 5
  if storecare != nobody and health > 0 and health < 150
  [set health (health + health-from-market)]
  
  let fitcare one-of fits in-radius 5
  if fitcare != nobody  and health > 0 and health < 150
  [set health (health + health-from-fitness )]
  
  let doccare one-of docs in-radius 2
  if doccare != nobody and health > 0 and health < 150
  [set health (health + health-from-doctor)]  
  
  let dumpcare one-of dumps in-radius 2
  if dumpcare != nobody   and health > 0 and health < 150
  [set health (health + health-from-superfund)]  
  
  if pcolor = green and health > 0 and health < 150
  [set health (health + health-from-park)] 
  
  if pcolor = black and health > 0 and health < 150
  [set health (health + health-from-highway)] 
  
  check-sick
  
  ]
end

to check-sick
  if health >= 100
    [set sick? false
    set dead? false
    set lsick? false
    set rsick? false
    set ldead? false
    set rdead? false
    set color 36]
  if health > 0 and health < 100
    [set sick? true
    set dead? false
    set color lime]
  if health < 0
    [set dead? true
    set sick? false
    set lsick? false
    set rsick? false
    set color white]
  if xcor < 0 [set left? true set right? false]
  if xcor > 0 [set right? true set left? false]
  if xcor = 0 [set left? false set right? false]
  if left? and sick? [set lsick? true set ldead? false]
  if right? and sick? [set rsick? true set rdead? false]
  if left? and dead? [set ldead? true set lsick? false set rsick? false set left? false set right? false]
  if right? and dead? [set rdead? true set rsick? false set lsick? false set left? false set right? false]
  set ltotal count people with [left?]
  set nlsick count people with [lsick?] 
  set nldead count people with [ldead?]
  set rtotal count people with [right?]
  set nrsick count people with [rsick?] 
  set nrdead count people with [rdead?]
  set lrsick nlsick / ltotal * 100
  set rrsick nrsick / rtotal * 100
  set lrdead nldead / (nldead + ltotal) * 100
  set rrdead nrdead / (nrdead + rtotal) * 100
 
end
@#$#@#$#@
GRAPHICS-WINDOW
186
10
729
574
20
20
13.0
1
10
1
1
1
0
0
0
1
-20
20
-20
20
0
0
1
ticks
30.0

BUTTON
9
10
72
43
NIL
setup
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

BUTTON
86
10
149
43
NIL
go
T
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

SLIDER
8
47
180
80
npeople
npeople
0
200
100
1
1
NIL
HORIZONTAL

SLIDER
8
121
180
154
psick
psick
0
100
10
1
1
%
HORIZONTAL

SLIDER
8
158
180
191
precover
precover
0
100
50
1
1
%
HORIZONTAL

SLIDER
8
84
180
117
preproduce
preproduce
0
10
1
1
1
%
HORIZONTAL

SLIDER
735
12
928
45
health-from-market
health-from-market
-100
100
10
1
1
%
HORIZONTAL

SLIDER
737
194
933
227
health-from-doctor
health-from-doctor
-100
100
25
1
1
%
HORIZONTAL

SLIDER
735
48
929
81
health-from-fitness
health-from-fitness
-100
100
10
1
1
%
HORIZONTAL

SLIDER
735
84
931
117
health-from-park
health-from-park
-100
100
0
1
1
%
HORIZONTAL

SLIDER
736
158
933
191
health-from-highway
health-from-highway
-100
100
0
1
1
%
HORIZONTAL

SLIDER
736
121
932
154
health-from-superfund
health-from-superfund
-100
100
-10
1
1
%
HORIZONTAL

MONITOR
65
317
180
362
West People
ltotal
3
1
11

MONITOR
65
368
181
413
West Sick People 
nlsick
3
1
11

MONITOR
67
468
181
513
West Dead People
nldead
3
1
11

MONITOR
734
319
845
364
East People 
rtotal
3
1
11

MONITOR
734
473
845
518
East Dead People
nrdead
3
1
11

MONITOR
734
370
844
415
East Sick People
nrsick
3
1
11

MONITOR
66
418
181
463
West Sick Rate
lrsick
1
1
11

MONITOR
734
423
845
468
East Sick Rate 
rrsick
1
1
11

MONITOR
67
518
181
563
West Death Rate
lrdead
1
1
11

MONITOR
735
523
846
568
East Death Rate
rrdead
1
1
11

@#$#@#$#@
## WHAT IS IT?

Health Disparities Model #2: Equal Environments

This model builds upon Health Disparities Model #1: Effects of Environment.  Model #1 illustrates the potential effects of the environment on health & uses real data from the District of Columbia to compare the environments on the West side (NW & SW) and the East side (NE & SE). This model reallocates DC environmental resources so that the two sides are the same & serves as a control for Model #1.

## HOW IT WORKS

Environment: The red line divides the West & East sides of the map.  Major parks (green) & highways (black) are mapped.  US Census Bureau 2010 ZIP Code Business Patterns data are used to calculate the number of doctor offices (excluding mental health specialists), fitness centers, & supermarkets (grocery stores with 5+ employees) per 2,500 population on each side & plotted randomly as doctor, bike, & building icons.  Superfund sites are plotted randomly as cow skulls. In this model, we reallocate doctor offices, fitness centers, & supermarkets so there are equal numbers on the two sides.

People: Each turn, people move, reproduce, get sick, and recover (if sick) randomly. Moving on parks & highways, within 5 spaces of supermarkets & fitness centers, or within 2 spaces of doctor offices & superfund sites can affect health.  When people get sick, they turn green, and when health reaches 0, they turn into ghosts which do not move.

Counters: These count the total # of people, # of sick people, % of people who are sick, # of dead people, & % of people who have died on each side.  The model stops if all people become ghosts or > 100 ghosts accrue on the map.

## HOW TO USE IT

The starting # of people, rate of reproduction, rate of people getting sick, & rate of sick people recovering spontaneously can be set with the sliders on the left.  The health effects of supermarkets, fitness centers, parks, superfund sites, highways, & doctor offices can be set positively or negatively with sliders on the right. 

## THINGS TO NOTICE

The default model gives positive health effects to supermarkets, fitness centers, & doctor offices & negative effects to superfund site.  The default model gives parks & highways no effect to better equalize the two sides.  

Which side has the healthier environment?  How does this compare to Model #1?

How does this affect the # of sick people & # of ghosts?

Do sick people & ghosts cluster is certain places?  Why?

## THINGS TO TRY

Play with the sliders.

What happens if the reproduction rate is too low or the rate of getting sick too high?

What happens if the recovery rate is high?

## EXTENDING THE MODEL

Do you have 2 adjacent communities that you want to compare?  Install NetLogo & edit the code to suit.

Under setup, map parks & highways as green & black patches.

Under setup-world, the numbers on the create- lines indicate the number of a specific item to map.  ('Create-stores 3' means create 3 stores.)  Edit these numbers to reflect the relative resources in your 2 communities.  Also note that 'setxy random 20 random-pycor' places an item randomly on the East/Right side of the red line while 'setxy random -20 random-pycor' places an item randomly on the West/Left side.

## CREDITS AND REFERENCES

Census data from US Census Bureau Amerian FactFinder (http://factfinder2.census.gov/faces/nav/jsf/pages/index.xhtml).

Superfund site locations from US Environmental Protection Agency (http://www.epa.gov/superfund/sites/).

Model by emoyusa@verizon.net
@#$#@#$#@
default
true
0
Polygon -7500403 true true 150 5 40 250 150 205 260 250

airplane
true
0
Polygon -7500403 true true 150 0 135 15 120 60 120 105 15 165 15 195 120 180 135 240 105 270 120 285 150 270 180 285 210 270 165 240 180 180 285 195 285 165 180 105 180 60 165 15

ambulance
false
0
Rectangle -7500403 true true 30 90 210 195
Polygon -7500403 true true 296 190 296 150 259 134 244 104 210 105 210 190
Rectangle -1 true false 195 60 195 105
Polygon -16777216 true false 238 112 252 141 219 141 218 112
Circle -16777216 true false 234 174 42
Circle -16777216 true false 69 174 42
Rectangle -1 true false 288 158 297 173
Rectangle -1184463 true false 289 180 298 172
Rectangle -2674135 true false 29 151 298 158
Line -16777216 false 210 90 210 195
Rectangle -16777216 true false 83 116 128 133
Rectangle -16777216 true false 153 111 176 134
Line -7500403 true 165 105 165 135
Rectangle -7500403 true true 14 186 33 195
Line -13345367 false 45 135 75 120
Line -13345367 false 75 135 45 120
Line -13345367 false 60 112 60 142

arrow
true
0
Polygon -7500403 true true 150 0 0 150 105 150 105 293 195 293 195 150 300 150

bike
false
1
Line -7500403 false 163 183 228 184
Circle -7500403 false false 213 184 22
Circle -7500403 false false 156 187 16
Circle -16777216 false false 28 148 95
Circle -16777216 false false 24 144 102
Circle -16777216 false false 174 144 102
Circle -16777216 false false 177 148 95
Polygon -2674135 true true 75 195 90 90 98 92 97 107 192 122 207 83 215 85 202 123 211 133 225 195 165 195 164 188 214 188 202 133 94 116 82 195
Polygon -2674135 true true 208 83 164 193 171 196 217 85
Polygon -2674135 true true 165 188 91 120 90 131 164 196
Line -7500403 false 159 173 170 219
Line -7500403 false 155 172 166 172
Line -7500403 false 166 219 177 219
Polygon -16777216 true false 187 92 198 92 208 97 217 100 231 93 231 84 216 82 201 83 184 85
Polygon -7500403 true true 71 86 98 93 101 85 74 81
Rectangle -16777216 true false 75 75 75 90
Polygon -16777216 true false 70 87 70 72 78 71 78 89
Circle -7500403 false false 153 184 22
Line -7500403 false 159 206 228 205

box
false
0
Polygon -7500403 true true 150 285 285 225 285 75 150 135
Polygon -7500403 true true 150 135 15 75 150 15 285 75
Polygon -7500403 true true 15 75 15 225 150 285 150 135
Line -16777216 false 150 285 150 135
Line -16777216 false 150 135 15 75
Line -16777216 false 150 135 285 75

bug
true
0
Circle -7500403 true true 96 182 108
Circle -7500403 true true 110 127 80
Circle -7500403 true true 110 75 80
Line -7500403 true 150 100 80 30
Line -7500403 true 150 100 220 30

building institution
false
0
Rectangle -7500403 true true 0 60 300 270
Rectangle -16777216 true false 130 196 168 256
Rectangle -16777216 false false 0 255 300 270
Polygon -7500403 true true 0 60 150 15 300 60
Polygon -16777216 false false 0 60 150 15 300 60
Circle -1 true false 135 26 30
Circle -16777216 false false 135 25 30
Rectangle -16777216 false false 0 60 300 75
Rectangle -16777216 false false 218 75 255 90
Rectangle -16777216 false false 218 240 255 255
Rectangle -16777216 false false 224 90 249 240
Rectangle -16777216 false false 45 75 82 90
Rectangle -16777216 false false 45 240 82 255
Rectangle -16777216 false false 51 90 76 240
Rectangle -16777216 false false 90 240 127 255
Rectangle -16777216 false false 90 75 127 90
Rectangle -16777216 false false 96 90 121 240
Rectangle -16777216 false false 179 90 204 240
Rectangle -16777216 false false 173 75 210 90
Rectangle -16777216 false false 173 240 210 255
Rectangle -16777216 false false 269 90 294 240
Rectangle -16777216 false false 263 75 300 90
Rectangle -16777216 false false 263 240 300 255
Rectangle -16777216 false false 0 240 37 255
Rectangle -16777216 false false 6 90 31 240
Rectangle -16777216 false false 0 75 37 90
Line -16777216 false 112 260 184 260
Line -16777216 false 105 265 196 265

building store
false
0
Rectangle -7500403 true true 30 45 45 240
Rectangle -16777216 false false 30 45 45 165
Rectangle -7500403 true true 15 165 285 255
Rectangle -16777216 true false 120 195 180 255
Line -7500403 true 150 195 150 255
Rectangle -16777216 true false 30 180 105 240
Rectangle -16777216 true false 195 180 270 240
Line -16777216 false 0 165 300 165
Polygon -7500403 true true 0 165 45 135 60 90 240 90 255 135 300 165
Rectangle -7500403 true true 0 0 75 45
Rectangle -16777216 false false 0 0 75 45

butterfly
true
0
Polygon -7500403 true true 150 165 209 199 225 225 225 255 195 270 165 255 150 240
Polygon -7500403 true true 150 165 89 198 75 225 75 255 105 270 135 255 150 240
Polygon -7500403 true true 139 148 100 105 55 90 25 90 10 105 10 135 25 180 40 195 85 194 139 163
Polygon -7500403 true true 162 150 200 105 245 90 275 90 290 105 290 135 275 180 260 195 215 195 162 165
Polygon -16777216 true false 150 255 135 225 120 150 135 120 150 105 165 120 180 150 165 225
Circle -16777216 true false 135 90 30
Line -16777216 false 150 105 195 60
Line -16777216 false 150 105 105 60

car
false
0
Polygon -7500403 true true 300 180 279 164 261 144 240 135 226 132 213 106 203 84 185 63 159 50 135 50 75 60 0 150 0 165 0 225 300 225 300 180
Circle -16777216 true false 180 180 90
Circle -16777216 true false 30 180 90
Polygon -16777216 true false 162 80 132 78 134 135 209 135 194 105 189 96 180 89
Circle -7500403 true true 47 195 58
Circle -7500403 true true 195 195 58

circle
false
0
Circle -7500403 true true 0 0 300

circle 2
false
0
Circle -7500403 true true 0 0 300
Circle -16777216 true false 30 30 240

cow
false
0
Polygon -7500403 true true 200 193 197 249 179 249 177 196 166 187 140 189 93 191 78 179 72 211 49 209 48 181 37 149 25 120 25 89 45 72 103 84 179 75 198 76 252 64 272 81 293 103 285 121 255 121 242 118 224 167
Polygon -7500403 true true 73 210 86 251 62 249 48 208
Polygon -7500403 true true 25 114 16 195 9 204 23 213 25 200 39 123

cow skull
false
0
Polygon -7500403 true true 150 90 75 105 60 150 75 210 105 285 195 285 225 210 240 150 225 105
Polygon -16777216 true false 150 150 90 195 90 150
Polygon -16777216 true false 150 150 210 195 210 150
Polygon -16777216 true false 105 285 135 270 150 285 165 270 195 285
Polygon -7500403 true true 240 150 263 143 278 126 287 102 287 79 280 53 273 38 261 25 246 15 227 8 241 26 253 46 258 68 257 96 246 116 229 126
Polygon -7500403 true true 60 150 37 143 22 126 13 102 13 79 20 53 27 38 39 25 54 15 73 8 59 26 47 46 42 68 43 96 54 116 71 126

cylinder
false
0
Circle -7500403 true true 0 0 300

dot
false
0
Circle -7500403 true true 90 90 120

face happy
false
0
Circle -7500403 true true 8 8 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Polygon -16777216 true false 150 255 90 239 62 213 47 191 67 179 90 203 109 218 150 225 192 218 210 203 227 181 251 194 236 217 212 240

face neutral
false
0
Circle -7500403 true true 8 7 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Rectangle -16777216 true false 60 195 240 225

face sad
false
0
Circle -7500403 true true 8 8 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Polygon -16777216 true false 150 168 90 184 62 210 47 232 67 244 90 220 109 205 150 198 192 205 210 220 227 242 251 229 236 206 212 183

fish
false
0
Polygon -1 true false 44 131 21 87 15 86 0 120 15 150 0 180 13 214 20 212 45 166
Polygon -1 true false 135 195 119 235 95 218 76 210 46 204 60 165
Polygon -1 true false 75 45 83 77 71 103 86 114 166 78 135 60
Polygon -7500403 true true 30 136 151 77 226 81 280 119 292 146 292 160 287 170 270 195 195 210 151 212 30 166
Circle -16777216 true false 215 106 30

flag
false
0
Rectangle -7500403 true true 60 15 75 300
Polygon -7500403 true true 90 150 270 90 90 30
Line -7500403 true 75 135 90 135
Line -7500403 true 75 45 90 45

flower
false
0
Polygon -10899396 true false 135 120 165 165 180 210 180 240 150 300 165 300 195 240 195 195 165 135
Circle -7500403 true true 85 132 38
Circle -7500403 true true 130 147 38
Circle -7500403 true true 192 85 38
Circle -7500403 true true 85 40 38
Circle -7500403 true true 177 40 38
Circle -7500403 true true 177 132 38
Circle -7500403 true true 70 85 38
Circle -7500403 true true 130 25 38
Circle -7500403 true true 96 51 108
Circle -16777216 true false 113 68 74
Polygon -10899396 true false 189 233 219 188 249 173 279 188 234 218
Polygon -10899396 true false 180 255 150 210 105 210 75 240 135 240

food
false
0
Polygon -7500403 true true 30 105 45 255 105 255 120 105
Rectangle -7500403 true true 15 90 135 105
Polygon -7500403 true true 75 90 105 15 120 15 90 90
Polygon -7500403 true true 135 225 150 240 195 255 225 255 270 240 285 225 150 225
Polygon -7500403 true true 135 180 150 165 195 150 225 150 270 165 285 180 150 180
Rectangle -7500403 true true 135 195 285 210

garbage can
false
0
Polygon -16777216 false false 60 240 66 257 90 285 134 299 164 299 209 284 234 259 240 240
Rectangle -7500403 true true 60 75 240 240
Polygon -7500403 true true 60 238 66 256 90 283 135 298 165 298 210 283 235 256 240 238
Polygon -7500403 true true 60 75 66 57 90 30 135 15 165 15 210 30 235 57 240 75
Polygon -7500403 true true 60 75 66 93 90 120 135 135 165 135 210 120 235 93 240 75
Polygon -16777216 false false 59 75 66 57 89 30 134 15 164 15 209 30 234 56 239 75 235 91 209 120 164 135 134 135 89 120 64 90
Line -16777216 false 210 120 210 285
Line -16777216 false 90 120 90 285
Line -16777216 false 125 131 125 296
Line -16777216 false 65 93 65 258
Line -16777216 false 175 131 175 296
Line -16777216 false 235 93 235 258
Polygon -16777216 false false 112 52 112 66 127 51 162 64 170 87 185 85 192 71 180 54 155 39 127 36

ghost
false
0
Polygon -7500403 true true 30 165 13 164 -2 149 0 135 -2 119 0 105 15 75 30 75 58 104 43 119 43 134 58 134 73 134 88 104 73 44 78 14 103 -1 193 -1 223 29 208 89 208 119 238 134 253 119 240 105 238 89 240 75 255 60 270 60 283 74 300 90 298 104 298 119 300 135 285 135 285 150 268 164 238 179 208 164 208 194 238 209 253 224 268 239 268 269 238 299 178 299 148 284 103 269 58 284 43 299 58 269 103 254 148 254 193 254 163 239 118 209 88 179 73 179 58 164
Line -16777216 false 189 253 215 253
Circle -16777216 true false 102 30 30
Polygon -16777216 true false 165 105 135 105 120 120 105 105 135 75 165 75 195 105 180 120
Circle -16777216 true false 160 30 30

house
false
0
Rectangle -7500403 true true 45 120 255 285
Rectangle -16777216 true false 120 210 180 285
Polygon -7500403 true true 15 120 150 15 285 120
Line -16777216 false 30 120 270 120

leaf
false
0
Polygon -7500403 true true 150 210 135 195 120 210 60 210 30 195 60 180 60 165 15 135 30 120 15 105 40 104 45 90 60 90 90 105 105 120 120 120 105 60 120 60 135 30 150 15 165 30 180 60 195 60 180 120 195 120 210 105 240 90 255 90 263 104 285 105 270 120 285 135 240 165 240 180 270 195 240 210 180 210 165 195
Polygon -7500403 true true 135 195 135 240 120 255 105 255 105 285 135 285 165 240 165 195

line
true
0
Line -7500403 true 150 0 150 300

line half
true
0
Line -7500403 true 150 0 150 150

pentagon
false
0
Polygon -7500403 true true 150 15 15 120 60 285 240 285 285 120

person
false
0
Circle -7500403 true true 110 5 80
Polygon -7500403 true true 105 90 120 195 90 285 105 300 135 300 150 225 165 300 195 300 210 285 180 195 195 90
Rectangle -7500403 true true 127 79 172 94
Polygon -7500403 true true 195 90 240 150 225 180 165 105
Polygon -7500403 true true 105 90 60 150 75 180 135 105

person doctor
false
0
Polygon -7500403 true true 105 90 120 195 90 285 105 300 135 300 150 225 165 300 195 300 210 285 180 195 195 90
Polygon -13345367 true false 135 90 150 105 135 135 150 150 165 135 150 105 165 90
Polygon -7500403 true true 105 90 60 195 90 210 135 105
Polygon -7500403 true true 195 90 240 195 210 210 165 105
Circle -7500403 true true 110 5 80
Rectangle -7500403 true true 127 79 172 94
Polygon -1 true false 105 90 60 195 90 210 114 156 120 195 90 270 210 270 180 195 186 155 210 210 240 195 195 90 165 90 150 150 135 90
Line -16777216 false 150 148 150 270
Line -16777216 false 196 90 151 149
Line -16777216 false 104 90 149 149
Circle -1 true false 180 0 30
Line -16777216 false 180 15 120 15
Line -16777216 false 150 195 165 195
Line -16777216 false 150 240 165 240
Line -16777216 false 150 150 165 150

plant
false
0
Rectangle -7500403 true true 135 90 165 300
Polygon -7500403 true true 135 255 90 210 45 195 75 255 135 285
Polygon -7500403 true true 165 255 210 210 255 195 225 255 165 285
Polygon -7500403 true true 135 180 90 135 45 120 75 180 135 210
Polygon -7500403 true true 165 180 165 210 225 180 255 120 210 135
Polygon -7500403 true true 135 105 90 60 45 45 75 105 135 135
Polygon -7500403 true true 165 105 165 135 225 105 255 45 210 60
Polygon -7500403 true true 135 90 120 45 150 15 180 45 165 90

sheep
false
0
Rectangle -7500403 true true 151 225 180 285
Rectangle -7500403 true true 47 225 75 285
Rectangle -7500403 true true 15 75 210 225
Circle -7500403 true true 135 75 150
Circle -16777216 true false 165 76 116

square
false
0
Rectangle -7500403 true true 30 30 270 270

square 2
false
0
Rectangle -7500403 true true 30 30 270 270
Rectangle -16777216 true false 60 60 240 240

star
false
0
Polygon -7500403 true true 151 1 185 108 298 108 207 175 242 282 151 216 59 282 94 175 3 108 116 108

target
false
0
Circle -7500403 true true 0 0 300
Circle -16777216 true false 30 30 240
Circle -7500403 true true 60 60 180
Circle -16777216 true false 90 90 120
Circle -7500403 true true 120 120 60

tree
false
0
Circle -7500403 true true 118 3 94
Rectangle -6459832 true false 120 195 180 300
Circle -7500403 true true 65 21 108
Circle -7500403 true true 116 41 127
Circle -7500403 true true 45 90 120
Circle -7500403 true true 104 74 152

triangle
false
0
Polygon -7500403 true true 150 30 15 255 285 255

triangle 2
false
0
Polygon -7500403 true true 150 30 15 255 285 255
Polygon -16777216 true false 151 99 225 223 75 224

truck
false
0
Rectangle -7500403 true true 4 45 195 187
Polygon -7500403 true true 296 193 296 150 259 134 244 104 208 104 207 194
Rectangle -1 true false 195 60 195 105
Polygon -16777216 true false 238 112 252 141 219 141 218 112
Circle -16777216 true false 234 174 42
Rectangle -7500403 true true 181 185 214 194
Circle -16777216 true false 144 174 42
Circle -16777216 true false 24 174 42
Circle -7500403 false true 24 174 42
Circle -7500403 false true 144 174 42
Circle -7500403 false true 234 174 42

turtle
true
0
Polygon -10899396 true false 215 204 240 233 246 254 228 266 215 252 193 210
Polygon -10899396 true false 195 90 225 75 245 75 260 89 269 108 261 124 240 105 225 105 210 105
Polygon -10899396 true false 105 90 75 75 55 75 40 89 31 108 39 124 60 105 75 105 90 105
Polygon -10899396 true false 132 85 134 64 107 51 108 17 150 2 192 18 192 52 169 65 172 87
Polygon -10899396 true false 85 204 60 233 54 254 72 266 85 252 107 210
Polygon -7500403 true true 119 75 179 75 209 101 224 135 220 225 175 261 128 261 81 224 74 135 88 99

wheel
false
0
Circle -7500403 true true 3 3 294
Circle -16777216 true false 30 30 240
Line -7500403 true 150 285 150 15
Line -7500403 true 15 150 285 150
Circle -7500403 true true 120 120 60
Line -7500403 true 216 40 79 269
Line -7500403 true 40 84 269 221
Line -7500403 true 40 216 269 79
Line -7500403 true 84 40 221 269

x
false
0
Polygon -7500403 true true 270 75 225 30 30 225 75 270
Polygon -7500403 true true 30 75 75 30 270 225 225 270

@#$#@#$#@
NetLogo 5.0.3
@#$#@#$#@
@#$#@#$#@
@#$#@#$#@
@#$#@#$#@
@#$#@#$#@
default
0.0
-0.2 0 1.0 0.0
0.0 1 1.0 0.0
0.2 0 1.0 0.0
link direction
true
0
Line -7500403 true 150 150 90 180
Line -7500403 true 150 150 210 180

@#$#@#$#@
0
@#$#@#$#@
