turtles-own [

  ;; these variables reflect selection and reinforcement
  behavior1               ;; counts all moves to black patches from any patch
  behavior2               ;; tcounts all moves to white patches from any patch
  reinforcement1          ;; tracks all reinforcement for moves to black patches
  reinforcement2          ;; tracks all reinforcement for moves to white patches

  b1set                   ;; depicts sets of 10 trials/time units
  b2set                   ;; depicts sets of 10 trials/time units

  reinforcement-ratio     ;; this represents reinforcement1/(reinforcement1 + reinforcement2)
]

to setup
  clear-all
  setup-turtles
  reset-ticks
end

to setup-turtles

  create-turtles 1  ;; only 1 agent in the base model
  ask turtles [
    setxy random-xcor random-ycor   ;;each turtle starts on a random patch
    set shape "face neutral"
    set size 6
    set color yellow

;; set initial parameters
    set behavior1 0
    set reinforcement1 1
    set behavior2 0
    set reinforcement2 1
    set reinforcement-ratio (reinforcement1 / (reinforcement1 + reinforcement2))
]

end

to go

  ask turtles [
  set b1set  0
  set b2set  0
  ]

  repeat session-length [
  cd

  ask turtles [
   set shape "face neutral"

   ifelse extinction1? and extinction2?
       [if confound1? [
        behave1
        reinforce1]
        if confound2? and not confound1? [
          behave2
          reinforce2]
      ]

      [
        ifelse random-float 1 < reinforcement-ratio
      [
        behave1
        if behavior1 mod ratio1 = 0 [if not extinction1? or confound1? [reinforce1]]
        if confound1? and behavior1 mod ratio1 != 0 [reinforce1]
      ]

      [
        behave2
        if behavior2 mod ratio2 = 0 [if not extinction2? or confound2? [reinforce2]]
        if confound2? and behavior2 mod ratio2 != 0 [reinforce2]
      ]
    ]
  ]

  ask turtles [

    ;; if R1 + R2 do not equal 0, then
    ifelse reinforcement1 + reinforcement2 != 0

      ;; set reinforcement-ratio equal to R1/(R1+R2) adjusted for history
      [set reinforcement-ratio (reinforcement1) / (reinforcement1 + reinforcement2)]

      ;; otherwise set reinforcement-ratio to chance
      [set reinforcement-ratio 0.5]
    ]

    tick

  ]

  ;;reset reinforcement ratios at end of session to help "discriminate" new schedules
  ask turtles [
    set reinforcement1 1
    set reinforcement2 1
  ]

  if not ever-run? [stop]
  ;; stops simulation at intervals specified by session-length
   ;;if ever-run? = false and ticks mod session-length = 0 [stop]

end

to behave1
;; executes behavior1 and updates settings for behavior1 and b1set
  pu
  set color orange
  rt random 360
  fd random 20
  pd
  repeat 4 [
    fd 10
    rt 90
   ]
  set behavior1 behavior1 + 1
  set b1set b1set + 1

end

to behave2
;; executes behavior2 and updates settings for behavior2 and b2set
  pu
  set color violet
  rt random 360
  fd random 20
  pd
   repeat 9 [
      fd 12
      left 40
      ]
    set behavior2 behavior2 + 1
    set b2set b2set + 1

end

to reinforce1

  set reinforcement1 reinforcement1 + 1
  set shape "face happy"
  let n 10
  loop [
    set n n - 0.25
  repeat 4 [
    fd n
    rt 90
   ]
    if n = 0.25 [stop]
  ]

end

to reinforce2

  set reinforcement2 reinforcement2 + 1
  set shape "face happy"
  pd
  let n 12
  loop [
    set n n - 0.25
    repeat 9 [
    fd n
    left 40
   ]
    if n = 0.25 [stop]
  ]

end
@#$#@#$#@
GRAPHICS-WINDOW
275
390
773
585
-1
-1
3.8
1
10
1
1
1
0
1
1
1
-64
64
-24
24
1
1
1
ticks
5.0

BUTTON
60
340
115
373
NIL
setup
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

BUTTON
135
340
190
373
NIL
go
T
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

SLIDER
45
30
225
63
session-length
session-length
1
100
20.0
1
1
NIL
HORIZONTAL

SLIDER
20
105
135
138
ratio1
ratio1
1
10
1.0
1
1
NIL
HORIZONTAL

SLIDER
140
105
255
138
ratio2
ratio2
1
10
1.0
1
1
NIL
HORIZONTAL

TEXTBOX
55
80
230
100
Choose reinforcement parameters
11
0.0
1

TEXTBOX
65
10
225
36
Choose length of each session
11
0.0
1

PLOT
280
205
770
380
Frequency per Session (B1 and B2)
Sessions
Frequency
0.0
10.0
0.0
10.0
true
true
"" ""
PENS
"B1" 1.0 1 -955883 true "" "if ticks > 0 and ticks mod session-length = 0 [plot [b1set] of turtle 0]"
"B2" 1.0 1 -8630108 true "" "if ticks > 0 and ticks mod session-length = 0 [plot [b2set] of turtle 0]"

SWITCH
60
420
190
453
Ever-run?
Ever-run?
1
1
-1000

SWITCH
65
510
190
543
Sound?
Sound?
0
1
-1000

TEXTBOX
35
470
260
496
Turn on sound if you want to hear a sound each time reinforcement is delivered.
11
0.0
1

SWITCH
20
180
135
213
extinction1?
extinction1?
1
1
-1000

SWITCH
140
180
255
213
extinction2?
extinction2?
1
1
-1000

TEXTBOX
25
145
265
181
Turning an extinction? switch on means that no reinforcement is delivered for the specified behavior.
10
0.0
1

TEXTBOX
60
305
210
331
Setup clears the screen; go runs 1 session and stops.
11
0.0
1

TEXTBOX
50
385
220
410
Turn ever-run? on to keep going right into the next session.
11
0.0
1

PLOT
520
15
770
190
Proportion per Session (B2)
Time
Proportion
0.0
10.0
0.0
1.0
true
false
"" ""
PENS
"B2" 1.0 1 -8630108 true "" "if ticks > 0 and ticks mod session-length = 0 [plot [b2set / session-length] of turtle 0]"

PLOT
280
15
520
190
Proportion per Session (B1)
Sessions
Proportion
0.0
10.0
0.0
1.0
true
false
"" ""
PENS
"B1" 1.0 1 -955883 true "" "if ticks > 0 and ticks mod session-length = 0 [plot [b1set / session-length] of turtle 0]"

SWITCH
20
255
135
288
confound1?
confound1?
1
1
-1000

SWITCH
140
255
255
288
confound2?
confound2?
1
1
-1000

TEXTBOX
40
220
250
250
Turning on a confound? switch provides reinforcement for behavior
11
0.0
1

@#$#@#$#@
## WHAT IS IT?

_This model is an extension of the Withdrawal Design Interactive Model. In this extension, we have added two switches, CONFOUND1? and CONFOUND2? to represent confounds that might affect results.  The original description of the model is provided below and a more complete description of the confounds? switches is provided under the "How To Use It" section._

This model is designed to be used as a "hands on" instructional supplement for teaching students to analyze the effects of an independent variable using a withdrawal design. In the model, the agent engages in two behaviors according to separate schedules of reinforcement.  Behaviors are plotted session by session, allowing students to use visual inpsection to determine when to move to the next condition (set of reinforcement schedules).

For a comprehnsive set of instructions on how to use to use the model, see https://app.box.com/s/wmtp0hs41st2jb5sp4dohq0wdtn2x2jl

## REINFORCEMENT

This model includes only one type of reinforcement schedule - the fixed ratio schedule.
In fixed-ratio schedules, a reinforcer is delivered after a specific number of responses. For example, a vending machine that only accepts quarters and vends items for 1 dollar could be said to reinforce inserting quarters on a fixed-ratio 4 schedule.  In the simulation, setting _ratio1_ to 4 means that every fourth time the agent engages in behavior 1, reinforcement will be delivered.

In the simulation, behavior 1 is represented by drawing an orange square, and behavior 2 is represented by drawing a violet circle.  Reinforcement is represnted by the shape being filled in and (if the SOUND? switch is available and on) an audible tone (a note from a grand acoustic piano for behavior 1, and a note from a glockenspiel for behavior 2).

## HOW IT WORKS

An agent is randomly seeded on the screen and given the following properties:

  * behavior1 - a running tally of the number of times the agent draws a square

  * behavior2 - a running tally of the number of times the agent draws a circle

  * reinforcement1 - a running tally of the number of reinforcements that have followed behavior1

  * reinforcement2 - a running tally of the number of reinforcements that have followed behavior2

  * b1set - a tally of behavior1 that resets each new session

  * b2set - a tally of behavior2 that resets each new session


After the investigator adjusts the sliders to select the session-length, the ratio schedules, and the extinction settings, the investigator is ready to click the SETUP button and GO.

Each tick, the agent engages in behavior1 or behavior2. Which behavior the agent engages in is based upon the ratio of reinforcement for engaging in each of the behaviors (see NetLogo Features below).  If both extinction switches are switched on, neither behavior is engaged in.  

When an agent draws one of the shapes, it's behavior is reinforced based upon the selected schedule. Reinforcement is increased by 1 if the count of the behavior is divisable by the ratio. 

At the beginning of each new session, b1set and b2set are reset to 0, and reinforcement1 and reinforcement2 are both set to 1. 

## HOW TO USE IT

SESSION-LENGTH: Use this slider to set the session-length (how many ticks the session will last).

RATIO sliders: Set these sliders to determine the schedule of reinforcement for behavior1 and behavior2.  Remember, the lower the number of the ratio, the more often the behavior will be followed by reinforcement.  A ratio of 1 means every behavior will be reinforced.

EXTINCTION switches: Setting these to "ON" will prevent reinforcement from being delivered, regardless of the RATIO slider setting.

CONFOUND switches: Setting these to "ON" overrides the RATIO and EXTINCTION switches.  Setting CONFOUND1? to ON results in reinforcement being delivered for every occurrence of behavior1; setting CONFOUND2? to ON results in reinforcement being delivered for every occurrence of behavior2.

SETUP: resets the simulation.

GO: advances the simulation one session at a time.

EVER-RUN?: setting this switch to on keeps the simulation moving right along until the switch is turned off or "GO" is clicked again.

SOUND?: If available, this switch allows you to turn sound on or off.

## WHAT TO LOOK FOR AND TO TRY

There are two main ways to use the model.

**Point by point analysis.** To use the model this way, make sure the EVER-RUN? switch is set to off.  Clicking GO will advance the simulation one session.  The top plot shows the frequency of selections for behavior1 and behavior2 per session. The smaller plots show proportion of selections of each behavior, respectively, per session.  Decisons can be made as to whether to continue with the same schedules of reinforcement or not using visual inspection.

**Running multiple sessions at once.** To use the model this way, turn the EVER-RUN? switch on and let the simulation continue to run until you are ready to make a change.  Then click the EVER-RUN? switch off.

>To create an ABAB withdrawal design, try the following: 
>
>  1. Set RATIO1 and RATIO2 to 1.
>  2. Set EXTINCTION1 to OFF and EXTINCTION 2 to on. **This is Condition A.**
>  3. Set EVER-RUN to OFF.
>  4. Click SETUP
>  5. Click GO at least three times.
>  6. Determine if responding is stable enough to change schedules.  If not, continue clicking go until it is.
>  7. Once responding is stable, change the schedule by turning EXTINCTION1? ON and EXTINCTION2? OFF.  **This is Condition B.**
>  8. Click GO at least three times.  Analyze. Keep clicking GO unitl you are ready to move on.
>  9. Reset the schedule to Condition A (EXTINCTION1? OFF, EXTINCTION2? ON).
>  10. Click GO until responding is steady.
>  11. Reset the schedule to Condition B. (EXTINCTION1? ON, EXTINCTION2? OFF).
>  12. Click GO until stable.

Following the instructions above should result in an ABAB withdrawal design that is easy to see in the top plot.

Setting the RATIOs to 1 and adjusting the schedules by turning the EXTINCTION? switches on and off results in the most stable and differentiated levels of behavior.  If you wish to investigate more variable behavior, keep the EXTINCTION? switches off and try different ratio values.  Keep in mind that if you set the ratios very high there will be few opporunities for reinforcement and responding will be fairly random.  For this reason, the ratio sliders are set to range from 1 to 10.

## EXTENDING THE MODEL

Some suggestions for extending the model include the following:

  * adding in additional schedules of reinforcement

  * allowing more precise user-control over variability, level, and trend

  * simulating other types of single-subject designs

  * making the effect of the confounds adjustable

  * simulating different types of interventions in addition to reinforcement


## NETLOGO FEATURES

The logic for determining which behavior is engaged in is determined as follows:

...

ask turtles [

   ifelse extinction1? and extinction2?
      [set b1set b1set
       set b2set b2set]

      [
        ifelse random-float 1 < reinforcement-ratio
      [
        behave1
        if behavior1 mod ratio1 = 0 [if not extinction1? [reinforce1]]
      ]

      [
        behave2
        if behavior2 mod ratio2 = 0 [if not extinction2? [reinforce2]]
      ]
    ]
  ]

...

where the "reinforcement-ratio" is determined by dividing reinforcement1 by the sum of reinforcement1 and reinforcement2.

## RELATED MODELS

A version of this model without confounds can be found at https://app.box.com/s/y8z1yp9a6z9cbushw0un4z0hvlys4x02 and found on the NetLogo Commons at http://modelingcommons.org/browse/one_model/5954#model_tabs_browse_info.  Subsequent models for use in interactive exercises exploring single-subject experimental designs will be linked to here as they are developed.

## CREDITS AND REFERENCES

This model can be downloaded from the web at
https://app.box.com/s/74azchtqhr9n2n6k7gjfm594jiidrk45 

It is also available from the NetLogo Commons at 
http://modelingcommons.org/browse/one_model/5958#model_tabs_browse_info

## COPYRIGHT AND LICENSE

Copyright 2019 Allen Karsina

This work is licensed under the Creative Commons Attribution-NonCommercial-ShareAlike 3.0 License. To view a copy of the license, visit https://creativecommons.org/licenses/by-nc-sa/3.0.
@#$#@#$#@
default
true
0
Polygon -7500403 true true 150 5 40 250 150 205 260 250

airplane
true
0
Polygon -7500403 true true 150 0 135 15 120 60 120 105 15 165 15 195 120 180 135 240 105 270 120 285 150 270 180 285 210 270 165 240 180 180 285 195 285 165 180 105 180 60 165 15

arrow
true
0
Polygon -7500403 true true 150 0 0 150 105 150 105 293 195 293 195 150 300 150

box
false
0
Polygon -7500403 true true 150 285 285 225 285 75 150 135
Polygon -7500403 true true 150 135 15 75 150 15 285 75
Polygon -7500403 true true 15 75 15 225 150 285 150 135
Line -16777216 false 150 285 150 135
Line -16777216 false 150 135 15 75
Line -16777216 false 150 135 285 75

bug
true
0
Circle -7500403 true true 96 182 108
Circle -7500403 true true 110 127 80
Circle -7500403 true true 110 75 80
Line -7500403 true 150 100 80 30
Line -7500403 true 150 100 220 30

butterfly
true
0
Polygon -7500403 true true 150 165 209 199 225 225 225 255 195 270 165 255 150 240
Polygon -7500403 true true 150 165 89 198 75 225 75 255 105 270 135 255 150 240
Polygon -7500403 true true 139 148 100 105 55 90 25 90 10 105 10 135 25 180 40 195 85 194 139 163
Polygon -7500403 true true 162 150 200 105 245 90 275 90 290 105 290 135 275 180 260 195 215 195 162 165
Polygon -16777216 true false 150 255 135 225 120 150 135 120 150 105 165 120 180 150 165 225
Circle -16777216 true false 135 90 30
Line -16777216 false 150 105 195 60
Line -16777216 false 150 105 105 60

car
false
0
Polygon -7500403 true true 300 180 279 164 261 144 240 135 226 132 213 106 203 84 185 63 159 50 135 50 75 60 0 150 0 165 0 225 300 225 300 180
Circle -16777216 true false 180 180 90
Circle -16777216 true false 30 180 90
Polygon -16777216 true false 162 80 132 78 134 135 209 135 194 105 189 96 180 89
Circle -7500403 true true 47 195 58
Circle -7500403 true true 195 195 58

circle
false
0
Circle -7500403 true true 0 0 300

circle 2
false
0
Circle -7500403 true true 0 0 300
Circle -16777216 true false 30 30 240

cow
false
0
Polygon -7500403 true true 200 193 197 249 179 249 177 196 166 187 140 189 93 191 78 179 72 211 49 209 48 181 37 149 25 120 25 89 45 72 103 84 179 75 198 76 252 64 272 81 293 103 285 121 255 121 242 118 224 167
Polygon -7500403 true true 73 210 86 251 62 249 48 208
Polygon -7500403 true true 25 114 16 195 9 204 23 213 25 200 39 123

cylinder
false
0
Circle -7500403 true true 0 0 300

dot
false
0
Circle -7500403 true true 90 90 120

face happy
false
0
Circle -7500403 true true 8 8 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Polygon -16777216 true false 150 255 90 239 62 213 47 191 67 179 90 203 109 218 150 225 192 218 210 203 227 181 251 194 236 217 212 240

face neutral
false
0
Circle -7500403 true true 8 7 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Rectangle -16777216 true false 60 195 240 225

face sad
false
0
Circle -7500403 true true 8 8 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Polygon -16777216 true false 150 168 90 184 62 210 47 232 67 244 90 220 109 205 150 198 192 205 210 220 227 242 251 229 236 206 212 183

fish
false
0
Polygon -1 true false 44 131 21 87 15 86 0 120 15 150 0 180 13 214 20 212 45 166
Polygon -1 true false 135 195 119 235 95 218 76 210 46 204 60 165
Polygon -1 true false 75 45 83 77 71 103 86 114 166 78 135 60
Polygon -7500403 true true 30 136 151 77 226 81 280 119 292 146 292 160 287 170 270 195 195 210 151 212 30 166
Circle -16777216 true false 215 106 30

flag
false
0
Rectangle -7500403 true true 60 15 75 300
Polygon -7500403 true true 90 150 270 90 90 30
Line -7500403 true 75 135 90 135
Line -7500403 true 75 45 90 45

flower
false
0
Polygon -10899396 true false 135 120 165 165 180 210 180 240 150 300 165 300 195 240 195 195 165 135
Circle -7500403 true true 85 132 38
Circle -7500403 true true 130 147 38
Circle -7500403 true true 192 85 38
Circle -7500403 true true 85 40 38
Circle -7500403 true true 177 40 38
Circle -7500403 true true 177 132 38
Circle -7500403 true true 70 85 38
Circle -7500403 true true 130 25 38
Circle -7500403 true true 96 51 108
Circle -16777216 true false 113 68 74
Polygon -10899396 true false 189 233 219 188 249 173 279 188 234 218
Polygon -10899396 true false 180 255 150 210 105 210 75 240 135 240

house
false
0
Rectangle -7500403 true true 45 120 255 285
Rectangle -16777216 true false 120 210 180 285
Polygon -7500403 true true 15 120 150 15 285 120
Line -16777216 false 30 120 270 120

leaf
false
0
Polygon -7500403 true true 150 210 135 195 120 210 60 210 30 195 60 180 60 165 15 135 30 120 15 105 40 104 45 90 60 90 90 105 105 120 120 120 105 60 120 60 135 30 150 15 165 30 180 60 195 60 180 120 195 120 210 105 240 90 255 90 263 104 285 105 270 120 285 135 240 165 240 180 270 195 240 210 180 210 165 195
Polygon -7500403 true true 135 195 135 240 120 255 105 255 105 285 135 285 165 240 165 195

line
true
0
Line -7500403 true 150 0 150 300

line half
true
0
Line -7500403 true 150 0 150 150

pentagon
false
0
Polygon -7500403 true true 150 15 15 120 60 285 240 285 285 120

person
false
0
Circle -7500403 true true 110 5 80
Polygon -7500403 true true 105 90 120 195 90 285 105 300 135 300 150 225 165 300 195 300 210 285 180 195 195 90
Rectangle -7500403 true true 127 79 172 94
Polygon -7500403 true true 195 90 240 150 225 180 165 105
Polygon -7500403 true true 105 90 60 150 75 180 135 105

plant
false
0
Rectangle -7500403 true true 135 90 165 300
Polygon -7500403 true true 135 255 90 210 45 195 75 255 135 285
Polygon -7500403 true true 165 255 210 210 255 195 225 255 165 285
Polygon -7500403 true true 135 180 90 135 45 120 75 180 135 210
Polygon -7500403 true true 165 180 165 210 225 180 255 120 210 135
Polygon -7500403 true true 135 105 90 60 45 45 75 105 135 135
Polygon -7500403 true true 165 105 165 135 225 105 255 45 210 60
Polygon -7500403 true true 135 90 120 45 150 15 180 45 165 90

sheep
false
15
Circle -1 true true 203 65 88
Circle -1 true true 70 65 162
Circle -1 true true 150 105 120
Polygon -7500403 true false 218 120 240 165 255 165 278 120
Circle -7500403 true false 214 72 67
Rectangle -1 true true 164 223 179 298
Polygon -1 true true 45 285 30 285 30 240 15 195 45 210
Circle -1 true true 3 83 150
Rectangle -1 true true 65 221 80 296
Polygon -1 true true 195 285 210 285 210 240 240 210 195 210
Polygon -7500403 true false 276 85 285 105 302 99 294 83
Polygon -7500403 true false 219 85 210 105 193 99 201 83

square
false
0
Rectangle -7500403 true true 30 30 270 270

square 2
false
0
Rectangle -7500403 true true 30 30 270 270
Rectangle -16777216 true false 60 60 240 240

star
false
0
Polygon -7500403 true true 151 1 185 108 298 108 207 175 242 282 151 216 59 282 94 175 3 108 116 108

target
false
0
Circle -7500403 true true 0 0 300
Circle -16777216 true false 30 30 240
Circle -7500403 true true 60 60 180
Circle -16777216 true false 90 90 120
Circle -7500403 true true 120 120 60

tree
false
0
Circle -7500403 true true 118 3 94
Rectangle -6459832 true false 120 195 180 300
Circle -7500403 true true 65 21 108
Circle -7500403 true true 116 41 127
Circle -7500403 true true 45 90 120
Circle -7500403 true true 104 74 152

triangle
false
0
Polygon -7500403 true true 150 30 15 255 285 255

triangle 2
false
0
Polygon -7500403 true true 150 30 15 255 285 255
Polygon -16777216 true false 151 99 225 223 75 224

truck
false
0
Rectangle -7500403 true true 4 45 195 187
Polygon -7500403 true true 296 193 296 150 259 134 244 104 208 104 207 194
Rectangle -1 true false 195 60 195 105
Polygon -16777216 true false 238 112 252 141 219 141 218 112
Circle -16777216 true false 234 174 42
Rectangle -7500403 true true 181 185 214 194
Circle -16777216 true false 144 174 42
Circle -16777216 true false 24 174 42
Circle -7500403 false true 24 174 42
Circle -7500403 false true 144 174 42
Circle -7500403 false true 234 174 42

turtle
true
0
Polygon -10899396 true false 215 204 240 233 246 254 228 266 215 252 193 210
Polygon -10899396 true false 195 90 225 75 245 75 260 89 269 108 261 124 240 105 225 105 210 105
Polygon -10899396 true false 105 90 75 75 55 75 40 89 31 108 39 124 60 105 75 105 90 105
Polygon -10899396 true false 132 85 134 64 107 51 108 17 150 2 192 18 192 52 169 65 172 87
Polygon -10899396 true false 85 204 60 233 54 254 72 266 85 252 107 210
Polygon -7500403 true true 119 75 179 75 209 101 224 135 220 225 175 261 128 261 81 224 74 135 88 99

wheel
false
0
Circle -7500403 true true 3 3 294
Circle -16777216 true false 30 30 240
Line -7500403 true 150 285 150 15
Line -7500403 true 15 150 285 150
Circle -7500403 true true 120 120 60
Line -7500403 true 216 40 79 269
Line -7500403 true 40 84 269 221
Line -7500403 true 40 216 269 79
Line -7500403 true 84 40 221 269

wolf
false
0
Polygon -16777216 true false 253 133 245 131 245 133
Polygon -7500403 true true 2 194 13 197 30 191 38 193 38 205 20 226 20 257 27 265 38 266 40 260 31 253 31 230 60 206 68 198 75 209 66 228 65 243 82 261 84 268 100 267 103 261 77 239 79 231 100 207 98 196 119 201 143 202 160 195 166 210 172 213 173 238 167 251 160 248 154 265 169 264 178 247 186 240 198 260 200 271 217 271 219 262 207 258 195 230 192 198 210 184 227 164 242 144 259 145 284 151 277 141 293 140 299 134 297 127 273 119 270 105
Polygon -7500403 true true -1 195 14 180 36 166 40 153 53 140 82 131 134 133 159 126 188 115 227 108 236 102 238 98 268 86 269 92 281 87 269 103 269 113

x
false
0
Polygon -7500403 true true 270 75 225 30 30 225 75 270
Polygon -7500403 true true 30 75 75 30 270 225 225 270
@#$#@#$#@
NetLogo 6.0.4
@#$#@#$#@
@#$#@#$#@
@#$#@#$#@
@#$#@#$#@
@#$#@#$#@
default
0.0
-0.2 0 0.0 1.0
0.0 1 1.0 0.0
0.2 0 0.0 1.0
link direction
true
0
Line -7500403 true 150 150 90 180
Line -7500403 true 150 150 210 180
@#$#@#$#@
1
@#$#@#$#@
