;;
;; This model is developed by Dr. Lin Xiang at the University of Kentucky. Contact: lin.xiang@uky.edu
;;
;; If you see this page rather than a "download" button when downloading the model, click the "download" icon
;; in your browser to download this model file.
;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;


turtles-own [ days-after-exposure  days-of-sick labeled]
Patches-own [ ]
Globals [ watching  max-daily-cases daily-new-cases max-daily-new-cases]


to setup
  ca
  setup-turtles

   set watching false

  reset-ticks
end

to setup-turtles
  create-turtles population-size
  [set color 68
    set size 1.25
    set labeled 0
    set shape "person"
    setxy random-xcor random-ycor
  ]
end


to go

if ticks > incubation-period and count turtles with [color = red] = 0 [stop]

  set daily-new-cases 0
  move
  transmission
  incubation
  sickness
  find-max-daily-cases
  tick
end


to move
  ask turtles with [shape = "person"]
  [right random 360 forward mobility]
end


to add-a-carrier
  ask one-of turtles                     ;choose a random person
  [set color orange                      ;set the color as orange (carrier color)
  ]

end

to transmission
  ask turtles with [color = orange]                                              ;Hi, carriers
  [let susceptible-person one-of other turtles in-radius 1.5 with [color = 68]   ;Are there any susceptible people near you (within a radius of 1.5)?
    if susceptible-person != nobody                                              ;If there is at least one
    [ask susceptible-person                                                      ;ask the suscetiple person
      [ if random 100 < transmission-rate                                        ;at the defined transmission rate
        [set color orange]                                                       ;to become a carrier (orange color)
      ]
    ]
  ]
end

to incubation
  ask turtles with [color = orange]                    ;Hi carriers
   [ifelse days-after-exposure < incubation-period     ;If the number of days after you get infected is smaller than the defined incubation period
    [set days-after-exposure days-after-exposure + 1]  ;increase the number of days after exposure by 1
    [set color red set shape "house"                   ;otherwise, become infectious (red color)
           set daily-new-cases daily-new-cases + 1     ;count daily neew cases
           if daily-new-cases > max-daily-new-cases    ;find the max daily new cases
            [set max-daily-new-cases daily-new-cases]  ]
   ]
end


to sickness
  ask turtles with [color = red]          ;Hi sick people,
  [ifelse days-of-sick <= illness-period             ;if you have not been sick for 15 days
    [set days-of-sick days-of-sick + 1]   ;remain sick and increase the number of sick days by 1
    [ifelse random 100 < mortality        ;otherwise, at the define mortality rate
      [die]                               ;die
      [set color blue set shape "person"] ;or recover
    ]
   ]
end

to vaccination
  let num-of-susceptible (count turtles with [color = 68])              ;find the number of susceptible people
  let num-of-vaccinated  (num-of-susceptible * vaccination-rate * 0.01) ;calculate number of susceptubel people to be vaccinated
  ask n-of num-of-vaccinated turtles with [color = 68]                  ;find these many susceptible people
     [set color blue]                                                   ;set as immune (blue)
end

to find-max-daily-cases
  if count turtles with [color = red ] > max-daily-cases        ;Count the infectious.If it is greater than the current record of max daily cases
  [set max-daily-cases count turtles with [color = red ]]       ;update the max daily case
end


to watch-an-infected-person
  watch one-of turtles with [color = red]
end

to label-a-person

  if any? turtles = false [user-message "Nobody is here." stop]


  if mouse-inside? [
    if mouse-down? [
      let labeled-person min-one-of turtles [distancexy mouse-xcor mouse-ycor]
      if labeled-person != nobody [
        ask labeled-person [set label "me" set labeled 1]      ;label the 1st selected person as me
        watch labeled-person]
  ]]


 if count turtles with [labeled = 1] >= 1 [stop]   ;disable the button when one person is labelled.

end

to unselect

  ask turtles
  [set labeled 0
    set label ""]
  rp

end
@#$#@#$#@
GRAPHICS-WINDOW
194
10
598
415
-1
-1
12.0
1
10
1
1
1
0
1
1
1
-16
16
-16
16
0
0
1
Days
30.0

BUTTON
34
241
157
274
Start/Reset
setup
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

BUTTON
34
316
157
349
Run/Pause
go
T
1
T
OBSERVER
NIL
NIL
NIL
NIL
0

SLIDER
8
10
186
43
population-size
population-size
50
1000
750.0
1
1
NIL
HORIZONTAL

SLIDER
8
47
185
80
transmission-rate
transmission-rate
0
100
100.0
5
1
%
HORIZONTAL

MONITOR
603
10
693
55
Susceptible
count turtles with [color = 68]
17
1
11

MONITOR
694
10
773
55
Carriers
count turtles with [color = orange]
17
1
11

PLOT
603
108
934
433
Daily Cases vs. Daily New Cases
Time
Case Count
0.0
10.0
0.0
100.0
true
true
"" ""
PENS
"Daily cases" 1.0 0 -2674135 true "" "plotxy ticks count turtles with [color = red]"
"Daily new cases" 1.0 0 -5825686 true "" "Plotxy ticks daily-new-cases"

SLIDER
8
83
185
116
incubation-period
incubation-period
2
14
6.0
1
1
Days
HORIZONTAL

SLIDER
8
153
185
186
mortality
mortality
0
100
20.0
1
1
%
HORIZONTAL

MONITOR
856
10
934
55
Recovered
count turtles with [color = blue]
17
1
11

MONITOR
839
57
934
102
Total Deaths
population-size - count turtles
17
1
11

MONITOR
774
10
855
55
Infectious
count turtles with [color = red]
17
1
11

TEXTBOX
240
420
350
440
|Green: Susceptible
11
55.0
1

TEXTBOX
344
420
511
440
|Orange: Carriers
11
25.0
1

TEXTBOX
439
420
554
440
|Red: Infectious
11
15.0
1

TEXTBOX
295
437
463
455
|Blue: Recovered/Vaccinated
11
105.0
1

SLIDER
8
190
185
223
mobility
mobility
0
1
1.0
0.1
1
NIL
HORIZONTAL

SLIDER
7
429
184
462
vaccination-rate
vaccination-rate
0
100
50.0
1
1
%
HORIZONTAL

BUTTON
34
467
157
500
vaccination
vaccination
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL
0

BUTTON
34
354
157
387
Run a day
go
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL
0

MONITOR
731
57
838
102
Max daily cases
max-daily-cases
17
1
11

BUTTON
34
278
157
311
+1 Carrier
add-a-carrier
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL
0

BUTTON
236
463
398
496
Select to watch a person
label-a-person
T
1
T
OBSERVER
NIL
NIL
NIL
NIL
0

MONITOR
603
57
730
102
Max daily new cases
max-daily-new-cases
0
1
11

BUTTON
405
463
523
496
Stop watching
unselect
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL
0

TEXTBOX
237
502
531
539
Press this button and then use your mouse to select a person in the simulation window above
10
4.0
1

SLIDER
8
118
185
151
illness-period
illness-period
7
15
15.0
1
1
days
HORIZONTAL

@#$#@#$#@
## WHAT IS IT?

This model simulates the epidemic dynamics in a human population based on a revised SEIR model, i.e., in this model the infectious (I) are fully isolated at home or in hospitals so that they do not transmit the disease. This model reveals the differences between the daily cases and daily new cases. Besides, this model allows students to label an individual person in the population and examine the chance at which the person is infected and follow the person through the epidemic.

 
## HOW IT WORKS

The model starts with a human population consisting of susceptible (green color)people. Once a carrier (orange color) appears in the population, it will pass the disease to one of the susceptible people nearby (within a radius of 1.5) at the defined transmission rate. The carrier may become sick (infectious red color) after the defined incubation period. The sick people will be isolated, so they do not infect others. The sick people will remain ill for 14 days. By the 15th day of being sick, they die (disappear from the model) at the defined mortality or recover and become immune to the disease (blue color). 

Buttons, Sliders, and Switches:

* The **population size** slider is self-explanatory. So are the buttons of **Set up/Reset**, **Run/Pause**, and **Run a day**.

* The **Vaccination-rate** slider determines the vaccination coverage of the population. 

* The **Transmission-rate** slider determines how likely a susceptible person is infected when exposed to the disease.  

* The **Mortality** slider determines how likely the infected people die on the 15th day.

* The "Incubation-period" defines the number of days between a person is infected and becomes sick. 

* The "Illness-period" defines the number of days between a person becomes to show symptoms to recover.

* The **+1 Carrier** button adds a carrier into the population.

* The **Select to watch a person** button allows you to focus on an individual person. You may compare how often the person gets infected in different situations.

* The **Stop watching** button allows you to stop watching the person.

## HOW TO USE IT

1. First, choose the factors, such as population size,  transmission rate, etc.

2. Click on **Set up/Reset** then **Run/Pause**. The model is set to stop when there are no infectious people. 

3. Observe the infection changes in the population in the plot and monitor.

4. Use **Run one day** to run the model in a controlled way and collect day-by-day data.


## THINGS TO TRY

There are so many things you can try in this model. Here are only very a few quick ideas:

* How does the number of daily cases differ from the number of daily new cases?

* How does the change in the number of daily cases related to the change in the number of daily new cases?

* How can the daily cases and/or daily new cases be used to measure the severity of an epidemic? Why?



## RELATED MODELS

Find this model series at http://3dsciencemodeling.com

* Infectious Disease Outbreak-Basic Phenomenon
* Infectious Disease Outbreak-Transmission and mortality
* Infectious Disease Outbreak-Population Comparison
* Infectious Disease Outbreak-HealthCare, Isolation and Quarantine
* Infectious Disease Outbreak-Social distancing
* Infectious Disease Outbreak-Vaccination
* Infectious Disease Outbreak-SEIR model

## CREDITS AND REFERENCES

Dr. Lin Xiang (lin.xiang@uky.edu) created this model at the University of Kentucky in 2021. If you mention this model in a publication, we ask that you include the citations below.

Xiang, L. (2021). Infectious Disease Outbreak-Daily cases and daily new cases. Department of STEM Education, University of Kentucky, Lexington, KY.

![CC BY-NC-SA 4.0](http://ccl.northwestern.edu/images/creativecommons/byncsa.png)

This work is licensed under the Creative Commons Attribution-NonCommercial-ShareAlike 4.0 License.  To view a copy of this license, visit https://creativecommons.org/licenses/by-nc-sa/4.0/.
@#$#@#$#@
default
true
0
Polygon -7500403 true true 150 5 40 250 150 205 260 250

airplane
true
0
Polygon -7500403 true true 150 0 135 15 120 60 120 105 15 165 15 195 120 180 135 240 105 270 120 285 150 270 180 285 210 270 165 240 180 180 285 195 285 165 180 105 180 60 165 15

arrow
true
0
Polygon -7500403 true true 150 0 0 150 105 150 105 293 195 293 195 150 300 150

box
false
0
Polygon -7500403 true true 150 285 285 225 285 75 150 135
Polygon -7500403 true true 150 135 15 75 150 15 285 75
Polygon -7500403 true true 15 75 15 225 150 285 150 135
Line -16777216 false 150 285 150 135
Line -16777216 false 150 135 15 75
Line -16777216 false 150 135 285 75

bug
true
0
Circle -7500403 true true 96 182 108
Circle -7500403 true true 110 127 80
Circle -7500403 true true 110 75 80
Line -7500403 true 150 100 80 30
Line -7500403 true 150 100 220 30

butterfly
true
0
Polygon -7500403 true true 150 165 209 199 225 225 225 255 195 270 165 255 150 240
Polygon -7500403 true true 150 165 89 198 75 225 75 255 105 270 135 255 150 240
Polygon -7500403 true true 139 148 100 105 55 90 25 90 10 105 10 135 25 180 40 195 85 194 139 163
Polygon -7500403 true true 162 150 200 105 245 90 275 90 290 105 290 135 275 180 260 195 215 195 162 165
Polygon -16777216 true false 150 255 135 225 120 150 135 120 150 105 165 120 180 150 165 225
Circle -16777216 true false 135 90 30
Line -16777216 false 150 105 195 60
Line -16777216 false 150 105 105 60

car
false
0
Polygon -7500403 true true 300 180 279 164 261 144 240 135 226 132 213 106 203 84 185 63 159 50 135 50 75 60 0 150 0 165 0 225 300 225 300 180
Circle -16777216 true false 180 180 90
Circle -16777216 true false 30 180 90
Polygon -16777216 true false 162 80 132 78 134 135 209 135 194 105 189 96 180 89
Circle -7500403 true true 47 195 58
Circle -7500403 true true 195 195 58

circle
false
0
Circle -7500403 true true 0 0 300

circle 2
false
0
Circle -7500403 true true 0 0 300
Circle -16777216 true false 30 30 240

cow
false
0
Polygon -7500403 true true 200 193 197 249 179 249 177 196 166 187 140 189 93 191 78 179 72 211 49 209 48 181 37 149 25 120 25 89 45 72 103 84 179 75 198 76 252 64 272 81 293 103 285 121 255 121 242 118 224 167
Polygon -7500403 true true 73 210 86 251 62 249 48 208
Polygon -7500403 true true 25 114 16 195 9 204 23 213 25 200 39 123

cylinder
false
0
Circle -7500403 true true 0 0 300

dot
false
0
Circle -7500403 true true 90 90 120

face happy
false
0
Circle -7500403 true true 8 8 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Polygon -16777216 true false 150 255 90 239 62 213 47 191 67 179 90 203 109 218 150 225 192 218 210 203 227 181 251 194 236 217 212 240

face neutral
false
0
Circle -7500403 true true 8 7 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Rectangle -16777216 true false 60 195 240 225

face sad
false
0
Circle -7500403 true true 8 8 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Polygon -16777216 true false 150 168 90 184 62 210 47 232 67 244 90 220 109 205 150 198 192 205 210 220 227 242 251 229 236 206 212 183

fish
false
0
Polygon -1 true false 44 131 21 87 15 86 0 120 15 150 0 180 13 214 20 212 45 166
Polygon -1 true false 135 195 119 235 95 218 76 210 46 204 60 165
Polygon -1 true false 75 45 83 77 71 103 86 114 166 78 135 60
Polygon -7500403 true true 30 136 151 77 226 81 280 119 292 146 292 160 287 170 270 195 195 210 151 212 30 166
Circle -16777216 true false 215 106 30

flag
false
0
Rectangle -7500403 true true 60 15 75 300
Polygon -7500403 true true 90 150 270 90 90 30
Line -7500403 true 75 135 90 135
Line -7500403 true 75 45 90 45

flower
false
0
Polygon -10899396 true false 135 120 165 165 180 210 180 240 150 300 165 300 195 240 195 195 165 135
Circle -7500403 true true 85 132 38
Circle -7500403 true true 130 147 38
Circle -7500403 true true 192 85 38
Circle -7500403 true true 85 40 38
Circle -7500403 true true 177 40 38
Circle -7500403 true true 177 132 38
Circle -7500403 true true 70 85 38
Circle -7500403 true true 130 25 38
Circle -7500403 true true 96 51 108
Circle -16777216 true false 113 68 74
Polygon -10899396 true false 189 233 219 188 249 173 279 188 234 218
Polygon -10899396 true false 180 255 150 210 105 210 75 240 135 240

house
false
0
Rectangle -7500403 true true 45 120 255 285
Rectangle -16777216 true false 120 210 180 285
Polygon -7500403 true true 15 120 150 15 285 120
Line -16777216 false 30 120 270 120

leaf
false
0
Polygon -7500403 true true 150 210 135 195 120 210 60 210 30 195 60 180 60 165 15 135 30 120 15 105 40 104 45 90 60 90 90 105 105 120 120 120 105 60 120 60 135 30 150 15 165 30 180 60 195 60 180 120 195 120 210 105 240 90 255 90 263 104 285 105 270 120 285 135 240 165 240 180 270 195 240 210 180 210 165 195
Polygon -7500403 true true 135 195 135 240 120 255 105 255 105 285 135 285 165 240 165 195

line
true
0
Line -7500403 true 150 0 150 300

line half
true
0
Line -7500403 true 150 0 150 150

pentagon
false
0
Polygon -7500403 true true 150 15 15 120 60 285 240 285 285 120

person
false
0
Circle -7500403 true true 110 5 80
Polygon -7500403 true true 105 90 120 195 90 285 105 300 135 300 150 225 165 300 195 300 210 285 180 195 195 90
Rectangle -7500403 true true 127 79 172 94
Polygon -7500403 true true 195 90 240 150 225 180 165 105
Polygon -7500403 true true 105 90 60 150 75 180 135 105

plant
false
0
Rectangle -7500403 true true 135 90 165 300
Polygon -7500403 true true 135 255 90 210 45 195 75 255 135 285
Polygon -7500403 true true 165 255 210 210 255 195 225 255 165 285
Polygon -7500403 true true 135 180 90 135 45 120 75 180 135 210
Polygon -7500403 true true 165 180 165 210 225 180 255 120 210 135
Polygon -7500403 true true 135 105 90 60 45 45 75 105 135 135
Polygon -7500403 true true 165 105 165 135 225 105 255 45 210 60
Polygon -7500403 true true 135 90 120 45 150 15 180 45 165 90

sheep
false
15
Circle -1 true true 203 65 88
Circle -1 true true 70 65 162
Circle -1 true true 150 105 120
Polygon -7500403 true false 218 120 240 165 255 165 278 120
Circle -7500403 true false 214 72 67
Rectangle -1 true true 164 223 179 298
Polygon -1 true true 45 285 30 285 30 240 15 195 45 210
Circle -1 true true 3 83 150
Rectangle -1 true true 65 221 80 296
Polygon -1 true true 195 285 210 285 210 240 240 210 195 210
Polygon -7500403 true false 276 85 285 105 302 99 294 83
Polygon -7500403 true false 219 85 210 105 193 99 201 83

square
false
0
Rectangle -7500403 true true 30 30 270 270

square 2
false
0
Rectangle -7500403 true true 30 30 270 270
Rectangle -16777216 true false 60 60 240 240

star
false
0
Polygon -7500403 true true 151 1 185 108 298 108 207 175 242 282 151 216 59 282 94 175 3 108 116 108

target
false
0
Circle -7500403 true true 0 0 300
Circle -16777216 true false 30 30 240
Circle -7500403 true true 60 60 180
Circle -16777216 true false 90 90 120
Circle -7500403 true true 120 120 60

tree
false
0
Circle -7500403 true true 118 3 94
Rectangle -6459832 true false 120 195 180 300
Circle -7500403 true true 65 21 108
Circle -7500403 true true 116 41 127
Circle -7500403 true true 45 90 120
Circle -7500403 true true 104 74 152

triangle
false
0
Polygon -7500403 true true 150 30 15 255 285 255

triangle 2
false
0
Polygon -7500403 true true 150 30 15 255 285 255
Polygon -16777216 true false 151 99 225 223 75 224

truck
false
0
Rectangle -7500403 true true 4 45 195 187
Polygon -7500403 true true 296 193 296 150 259 134 244 104 208 104 207 194
Rectangle -1 true false 195 60 195 105
Polygon -16777216 true false 238 112 252 141 219 141 218 112
Circle -16777216 true false 234 174 42
Rectangle -7500403 true true 181 185 214 194
Circle -16777216 true false 144 174 42
Circle -16777216 true false 24 174 42
Circle -7500403 false true 24 174 42
Circle -7500403 false true 144 174 42
Circle -7500403 false true 234 174 42

turtle
true
0
Polygon -10899396 true false 215 204 240 233 246 254 228 266 215 252 193 210
Polygon -10899396 true false 195 90 225 75 245 75 260 89 269 108 261 124 240 105 225 105 210 105
Polygon -10899396 true false 105 90 75 75 55 75 40 89 31 108 39 124 60 105 75 105 90 105
Polygon -10899396 true false 132 85 134 64 107 51 108 17 150 2 192 18 192 52 169 65 172 87
Polygon -10899396 true false 85 204 60 233 54 254 72 266 85 252 107 210
Polygon -7500403 true true 119 75 179 75 209 101 224 135 220 225 175 261 128 261 81 224 74 135 88 99

wheel
false
0
Circle -7500403 true true 3 3 294
Circle -16777216 true false 30 30 240
Line -7500403 true 150 285 150 15
Line -7500403 true 15 150 285 150
Circle -7500403 true true 120 120 60
Line -7500403 true 216 40 79 269
Line -7500403 true 40 84 269 221
Line -7500403 true 40 216 269 79
Line -7500403 true 84 40 221 269

wolf
false
0
Polygon -16777216 true false 253 133 245 131 245 133
Polygon -7500403 true true 2 194 13 197 30 191 38 193 38 205 20 226 20 257 27 265 38 266 40 260 31 253 31 230 60 206 68 198 75 209 66 228 65 243 82 261 84 268 100 267 103 261 77 239 79 231 100 207 98 196 119 201 143 202 160 195 166 210 172 213 173 238 167 251 160 248 154 265 169 264 178 247 186 240 198 260 200 271 217 271 219 262 207 258 195 230 192 198 210 184 227 164 242 144 259 145 284 151 277 141 293 140 299 134 297 127 273 119 270 105
Polygon -7500403 true true -1 195 14 180 36 166 40 153 53 140 82 131 134 133 159 126 188 115 227 108 236 102 238 98 268 86 269 92 281 87 269 103 269 113

x
false
0
Polygon -7500403 true true 270 75 225 30 30 225 75 270
Polygon -7500403 true true 30 75 75 30 270 225 225 270
@#$#@#$#@
NetLogo 6.2.0
@#$#@#$#@
@#$#@#$#@
@#$#@#$#@
<experiments>
  <experiment name="experiment" repetitions="5" runMetricsEveryStep="true">
    <setup>setup
add-a-carrier</setup>
    <go>go</go>
    <metric>Count turtles with [color = red]</metric>
    <metric>population-size - count turtles</metric>
    <enumeratedValueSet variable="population-size">
      <value value="300"/>
    </enumeratedValueSet>
    <steppedValueSet variable="transmission-rate" first="10" step="10" last="100"/>
    <enumeratedValueSet variable="mortality">
      <value value="1"/>
      <value value="5"/>
      <value value="10"/>
      <value value="20"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="incubation-period">
      <value value="2"/>
      <value value="6"/>
    </enumeratedValueSet>
  </experiment>
  <experiment name="experiment" repetitions="5" runMetricsEveryStep="true">
    <setup>setup
add-a-carrier</setup>
    <go>go</go>
    <metric>Count turtles with [color = red]</metric>
    <metric>num-of-persons - count turtles</metric>
    <enumeratedValueSet variable="num-of-persons">
      <value value="300"/>
    </enumeratedValueSet>
    <steppedValueSet variable="transmission-rate" first="10" step="10" last="100"/>
    <enumeratedValueSet variable="mortality">
      <value value="1"/>
      <value value="5"/>
      <value value="10"/>
      <value value="20"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="incubation-period">
      <value value="2"/>
      <value value="6"/>
    </enumeratedValueSet>
  </experiment>
  <experiment name="experiment-mobiloty" repetitions="5" runMetricsEveryStep="true">
    <setup>setup
add-a-carrier</setup>
    <go>go</go>
    <metric>Count turtles with [color = red]</metric>
    <metric>population-size - count turtles</metric>
    <enumeratedValueSet variable="population-size">
      <value value="1200"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="transmission-rate">
      <value value="25"/>
      <value value="50"/>
      <value value="75"/>
      <value value="100"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="mortality">
      <value value="20"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="incubation-period">
      <value value="6"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="mobility">
      <value value="0.1"/>
      <value value="0.5"/>
      <value value="1"/>
      <value value="2"/>
    </enumeratedValueSet>
  </experiment>
  <experiment name="experiment-herd immu" repetitions="5" runMetricsEveryStep="true">
    <setup>setup
add-a-carrier
vaccination</setup>
    <go>go</go>
    <metric>count turtles with [color = red]</metric>
    <metric>population-size - count turtles</metric>
    <enumeratedValueSet variable="population-size">
      <value value="900"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="transmission-rate">
      <value value="25"/>
      <value value="50"/>
      <value value="75"/>
      <value value="100"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="mortality">
      <value value="20"/>
    </enumeratedValueSet>
    <steppedValueSet variable="vaccination-rate" first="0" step="10" last="100"/>
    <enumeratedValueSet variable="incubation-period">
      <value value="6"/>
    </enumeratedValueSet>
    <enumeratedValueSet variable="mobility">
      <value value="1"/>
    </enumeratedValueSet>
  </experiment>
</experiments>
@#$#@#$#@
@#$#@#$#@
default
0.0
-0.2 0 0.0 1.0
0.0 1 1.0 0.0
0.2 0 0.0 1.0
link direction
true
0
Line -7500403 true 150 150 90 180
Line -7500403 true 150 150 210 180
@#$#@#$#@
0
@#$#@#$#@
