globals [
  sex-ratio-list  ;; global-variable to track time-series data (for behavior space experiment)
  ]
breed [males male]
breed [females female]
;;
females-own [
  partner
  carrying?                 ;;  a boolean to track if a female is carrying a child after mating
  male-child-chance         ;; this is a probability of giving birth to a male child
  temp-male-child-chance    ;; a variable to store male-chind-chance for a particular father-mother pair
  child-male-child-chance   ;; it is the inherited male-child-chance by a child
  gestation                 ;; a veriable to track time of carrying a child till a female reaches gesatation-period
  age
  rearing?                  ;; a boolean to track if a female is rearing a child after giving birth, she can't mate if she is rearing
  child-rearing             ;; a veriable to track time of rearing a child till a female reaches child-rearing-period
]

males-own [
  partner
  male-child-chance
  child-male-child-chance
  age
  rearing?                   ;; a boolean to track if a female is rearing a child after giving birth, she can't mate if she is rearing
  child-rearing              ;; a veriable to track time of rearing a child till a female reaches child-rearing-period
]

;;set-up pupulation of males and females
to setup
  ca
  create-males round ( ( 1 - ini-sex-ratio ) * ini-number ) [
    setxy random-xcor random-ycor
    set shape "male"
    set color green
    set male-child-chance random-normal ini-average-male-child-chance 0.1     ;; males are assinged initial male-child-chance from a random-normal distribution
    set age 0
    set partner nobody
    set rearing? false
  ]
  create-females round ( ini-sex-ratio * ini-number ) [
    setxy random-xcor random-ycor
    set color blue
    set shape "female"
    set carrying? false
    set partner nobody
    set rearing? false
    set male-child-chance random-normal ini-average-male-child-chance 0.1    ;; females are assinged initial male-child-chance from a random-normal distribution
  ]
  set sex-ratio-list []
  reset-ticks
end

to go
  if ticks = 15000 [stop]
  if not any? turtles [stop]
  ask males [
    check-if-dead
    if not rearing? and age > reproductive-maturity-age [move]
    search-a-partner
    if role-reversal? [child-rear]
  ]
  ask females [
    check-if-dead
    if not carrying? and not rearing? and age > reproductive-maturity-age [move]
    reproduce
    if not role-reversal? [child-rear]
  ]
  update-sex-ratio-list
  tick
end

to move
    rt random 60
    lt random 60
    fd 1
end

to search-a-partner  ;; male procedure
  if age > reproductive-maturity-age [             ;; males find partners only after they are mature to reproduce
  ifelse role-reversal? [                          ;; in case of role-reversal males rear children
    if partner = nobody and count females in-radius 1 = 1 and count females in-radius 1 with [not carrying? and age > reproductive-maturity-age ] = 1 and count other males in-radius 1 = 0  [  ;; spatial restriction is used to incorporate density-dependant growth rate
      set partner one-of females in-radius 1 with [not carrying? and age > reproductive-maturity-age]
    ]
  ]
  [
    if partner = nobody and count females in-radius 1 = 1 and count females in-radius 1 with [not carrying? and not rearing? and age > reproductive-maturity-age] = 1 and count other males in-radius 1 = 0  [
      set partner one-of females in-radius 1 with [not carrying? and not rearing? and age > reproductive-maturity-age]
    ]
  ]
  if partner = nobody [stop]
    ifelse [partner] of partner != nobody [
      set partner nobody
      stop                        ;; just in case two males find the same partner
    ]
    [
      ifelse random-float 1 < mating-chance [
        ask partner [
          set partner myself
          set carrying? true
          set color orange    ;; color oragne indicates carrying female
          set child-male-child-chance ( ( 1 - inheritance-weight ) * male-child-chance ) +  ( inheritance-weight * ( [male-child-chance] of myself ) )         ;; this is inherited male-child-chance by a child (determined by father and mother according to inheritance-weight)
          set temp-male-child-chance ( ( 1 - sex-determination-weight ) * male-child-chance ) +  ( sex-determination-weight * ( [male-child-chance] of myself ) )   ;; sex of a child is determined by male-child-chance (determined by father and mother according to sex-determination-weight)
        ]
        ifelse role-reversal? [
          set rearing? true           ;; in case of role-reversal, males have rearing role from the time they find a partner to the rearing-period for the childern is over
        ]
        [
          set partner nobody
        ]
      ]
      [
        set partner nobody
      ]
    ]
  ]
end

to reproduce ;; female procedure
    if carrying? [
      ifelse gestation = gestation-period [   ;; genstation-period can be set. When it's over, a female gives birth to a a child, starts afrest and can have a new partner
        set gestation 0
        set carrying? false
        ifelse role-reversal? [
          set partner nobody
        ]
        [
          set rearing? true
        ]
        set color blue
        repeat random max-litter-size + 1 [
          ifelse random-float 1 < temp-male-child-chance [    ;; sex of a child is determined by male-child-chance
            hatch 1 [
              set breed males
              set shape "male"
              set color green
              set male-child-chance random-normal child-male-child-chance 0.1
              set age 0
              set rearing? false
              set partner nobody
              set heading random 360
              fd 1
            ]
          ][
          hatch 1 [
            set male-child-chance random-normal child-male-child-chance  0.1
            set age 0
            set rearing? false
            set partner nobody
            set heading random 360
            fd 1
          ]
          ]
        ]
      ][
      set gestation gestation + 1
      ]
    ]

end

to child-rear
  if rearing? [
    ifelse child-rearing = child-rearing-period [
      set child-rearing 0
      set rearing? false
      set partner nobody
    ]
    [
      set child-rearing child-rearing + 1
    ]
  ]
end

to check-if-dead
    ifelse random-float longevity < age [
      die
    ][
    set age age + 1
    ]
end

;; reporting procedures for plotting and for behaviorspace experiments

to-report female-percentage
  ifelse any? turtles [
    report ( count females / count turtles ) * 100
  ]
  [
    report 0
  ]
end

to-report average-male-child-chance
  ifelse any? males [
    report mean [male-child-chance] of males
  ]
  [
    report 0
  ]
end

to update-sex-ratio-list
  if ticks > 10000 [
    set sex-ratio-list lput female-percentage sex-ratio-list
  ]
end

to-report average-sex-ratio
    ifelse length sex-ratio-list > 0 [
    report precision mean sex-ratio-list 2]
    [report 0]
end

to-report sd-sex-ratio
    ifelse length sex-ratio-list > 0 [
    report precision standard-deviation sex-ratio-list 2]
    [report 0]
end
@#$#@#$#@
GRAPHICS-WINDOW
653
13
1140
521
16
16
14.455
1
10
1
1
1
0
1
1
1
-16
16
-16
16
1
1
1
ticks
30.0

BUTTON
6
10
72
43
NIL
setup
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

SLIDER
25
49
197
82
ini-number
ini-number
50
500
463
1
1
NIL
HORIZONTAL

SLIDER
24
86
196
119
ini-sex-ratio
ini-sex-ratio
0
1
0.25
0.01
1
NIL
HORIZONTAL

SLIDER
24
122
240
155
ini-average-male-child-chance
ini-average-male-child-chance
0
1
0.2
0.01
1
NIL
HORIZONTAL

BUTTON
78
10
141
43
NIL
go
T
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

PLOT
292
136
637
256
Population
NIL
NIL
0.0
10.0
0.0
10.0
true
false
"" ""
PENS
"default" 1.0 0 -16777216 true "" "plot count turtles"

PLOT
291
273
640
393
Sex-ratio
NIL
NIL
0.0
10.0
0.0
100.0
true
false
"" ""
PENS
"default" 1.0 0 -16777216 true "" "plot female-percentage"

PLOT
293
11
640
131
Average-male-child-chance
NIL
NIL
0.0
10.0
0.0
1.0
true
false
"" ""
PENS
"default" 1.0 0 -16777216 true "" "plot average-male-child-chance"

SLIDER
24
157
145
190
gestation-period
gestation-period
0
50
8
1
1
NIL
HORIZONTAL

SLIDER
150
158
260
191
max-litter-size
max-litter-size
1
10
5
1
1
NIL
HORIZONTAL

SLIDER
25
262
197
295
mating-chance
mating-chance
0
1
0.95
0.05
1
NIL
HORIZONTAL

PLOT
25
405
620
550
Gender Distribution
NIL
NIL
0.0
10.0
0.0
10.0
true
true
"" ""
PENS
"Males" 1.0 0 -13840069 true "" "plot count males"
"Carrying females" 1.0 0 -955883 true "" "plot count females with [carrying?]"
"Females not carrying" 1.0 0 -13345367 true "" "plot count females with [not carrying?]"
"All females" 1.0 0 -8630108 true "" "plot count females"

SLIDER
24
194
149
227
longevity
longevity
0
1200
1120
10
1
NIL
HORIZONTAL

SLIDER
25
370
244
403
sex-determination-weight
sex-determination-weight
0
1
0.5
0.01
1
NIL
HORIZONTAL

SLIDER
24
335
245
368
inheritance-weight
inheritance-weight
0
1
0.7
0.01
1
NIL
HORIZONTAL

SLIDER
25
298
207
331
child-rearing-period
child-rearing-period
0
40
10
1
1
NIL
HORIZONTAL

SWITCH
144
10
287
43
role-reversal?
role-reversal?
0
1
-1000

SLIDER
24
228
236
261
reproductive-maturity-age
reproductive-maturity-age
0
100
14
1
1
NIL
HORIZONTAL

MONITOR
365
358
527
403
Average-female-proportion
average-sex-ratio
17
1
11

MONITOR
525
358
640
403
Standard-deviation
sd-sex-ratio
17
1
11

@#$#@#$#@
## WHAT IS IT

This is the third extension in a series of NetLogo models about population dynamics, population genetics and evolutionary biology developed by Sugat Dabholkar for the Designing & Constructing Models With Multi-Agent Languages, a course offered by Prof. Uri Wilensky at the School of Education and Social Policy in the Northwestern University.

This is an extension of the model Sex Ratio Equilibrium, where the core phenomenon that is modeled is the sex-ratio equilibrium in sexually reproducing organisms. Most of the sexually reproducing organisms have sex-ratio 1:1. Fisher (1930) explained the rational based on natural selection, irrespective of particular mechanism of sex-determination, which is known as Fisher’s first principle (Hamilton, 1967).

This extension allows understanding impact of sex-role reversal on stability of populations with extraordinary sex-ratios (Liker et al., Nature, 2013).

## HOW IT WORKS

This is a population dynamics model, where indi                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         