extensions [gogo]

globals [
  
  ;;;;;;;;;;;;;;;;;;;;;  ;;;;;;;;;;;;;;;;;;;;;  ;;;;;;;;;;;;;;;;;;;;;  ;;;;;;;;;;;;;;;;;;;;;  ;;;;;;;;;;;;;;;;;;;;;  
  ;; @FIrat, all new global parameters for our go go board version
  ;;;;;;;;;;;;;;;;;;;;;  ;;;;;;;;;;;;;;;;;;;;;  ;;;;;;;;;;;;;;;;;;;;;  ;;;;;;;;;;;;;;;;;;;;;  ;;;;;;;;;;;;;;;;;;;;;  
  grass?
  grass-regrowth-time  
  penmovetimer ;; timer for moving pen
  plotting? ;; have we started plotting yet
  lastdsheeppos? ;; was the last change in sheep population positive?
  lastsheepcount
  grass  ;; keep track of how much grass there is
  serial-port   ;; different on different operating systems
  paperstarted? ;; boolean for whether paper has been started
  ] 

;; Sheep and wolves are both breeds of turtle.
breed [sheep a-sheep]  ;; sheep is its own plural, so we use "a-sheep" as the singular.
breed [wolves wolf]
turtles-own [energy]       ;; both wolves and sheep have energy
patches-own [countdown]

to setup
  clear-all
  ;;;;;;;;;;;;;;;;;;;;;  ;;;;;;;;;;;;;;;;;;;;;  ;;;;;;;;;;;;;;;;;;;;;  ;;;;;;;;;;;;;;;;;;;;;  ;;;;;;;;;;;;;;;;;;;;;
  ;;; @Firat, our new setup procedures
  ;;;;;;;;;;;;;;;;;;;;;  ;;;;;;;;;;;;;;;;;;;;;  ;;;;;;;;;;;;;;;;;;;;;  ;;;;;;;;;;;;;;;;;;;;;  ;;;;;;;;;;;;;;;;;;;;;    
  setup-gogo
  ;; set last dsheep to positive
  set lastdsheeppos? true
  ;; sets lastsheepcount to 155 because that is just about the mean sheep count with the currently setup parameters
  ;; and so that therefore works as the starting point for the pen
  set lastsheepcount 155
  
  set grass? true
  set grass-regrowth-time 30
  
  set paperstarted? false
  
  set plotting? false
  
  ;; set the penmovetimer to silly high number so it does not start at first
  set penmovetimer -1
  ;;;;;;;;;;;;;;;;;;;;;  ;;;;;;;;;;;;;;;;;;;;;  ;;;;;;;;;;;;;;;;;;;;;  ;;;;;;;;;;;;;;;;;;;;;  ;;;;;;;;;;;;;;;;;;;;;
  ;;; @Firat, this is the old code
  ;;;;;;;;;;;;;;;;;;;;;  ;;;;;;;;;;;;;;;;;;;;;  ;;;;;;;;;;;;;;;;;;;;;  ;;;;;;;;;;;;;;;;;;;;;  ;;;;;;;;;;;;;;;;;;;;;    
  


  
  ;; "old" predation model code
  ask patches [ set pcolor green ]
  ;; check GRASS? switch.
  ;; if it is true, then grass grows and the sheep eat it
  ;; if it false, then the sheep don't need to eat
  if grass? [
    ask patches [
      set countdown random grass-regrowth-time ;; initialize grass grow clocks randomly
      set pcolor one-of [green brown]
    ]
  ]
  set-default-shape sheep "sheep"
  create-sheep initial-number-sheep  ;; create the sheep, then initialize their variables
  [
    set color white
    set size 1.5  ;; easier to see
    set label-color blue - 2
    set energy random (2 * sheep-gain-from-food)
    setxy random-xcor random-ycor
  ]
  set-default-shape wolves "wolf"
  create-wolves initial-number-wolves  ;; create the wolves, then initialize their variables
  [
    set color black
    set size 1.5  ;; easier to see
    set energy random (2 * wolf-gain-from-food)
    setxy random-xcor random-ycor
  ]
  display-labels
  set grass count patches with [pcolor = green]
  reset-ticks
end

to go
  ;;;;;;;;;;;;;;;;;;;;;  ;;;;;;;;;;;;;;;;;;;;;  ;;;;;;;;;;;;;;;;;;;;;  ;;;;;;;;;;;;;;;;;;;;;  ;;;;;;;;;;;;;;;;;;;;;  ;;;;;;;;;;;;;;;;;;;;;
  ;; @Firat: These are our new procedures
  ;; we start plotting when there are exactly 155 sheep
  ;;;;;;;;;;;;;;;;;;;;;  ;;;;;;;;;;;;;;;;;;;;;  ;;;;;;;;;;;;;;;;;;;;;  ;;;;;;;;;;;;;;;;;;;;;  ;;;;;;;;;;;;;;;;;;;;;  

  if(plotting?)
  [
    pauseanddraw    
  ]

  if(count sheep = 155)
  [
    set plotting? true
    ask sheep [set color red]    
    if (not paperstarted?) [runpaper]
  ]


;  if(count sheep = 155)
;  [
;      runpaper
;      movepen
;      set plotting? true
;      ask sheep [set color red]
;      
;  ]
  
  ;; if we have started plotting, we check if the pen move timer is up
  ;; the pen move timer is a set amount of time from the last time we started the motors
  ;; and is calculated in move-pen-for-time
  ;; if we are plotting and the pen move timer is up, we move the pen again
;  if (plotting?)
;  [
;    if timer > penmovetimer
;    [
;      movepen
;    ]
;  ]
  ;;;;;;;;;;;;;;;;;;;;;  ;;;;;;;;;;;;;;;;;;;;;  ;;;;;;;;;;;;;;;;;;;;;  ;;;;;;;;;;;;;;;;;;;;;  ;;;;;;;;;;;;;;;;;;;;;
  ;;; @Firat OLD CODE  
  ;;;;;;;;;;;;;;;;;;;;;  ;;;;;;;;;;;;;;;;;;;;;  ;;;;;;;;;;;;;;;;;;;;;  ;;;;;;;;;;;;;;;;;;;;;  ;;;;;;;;;;;;;;;;;;;;;  
  if not any? turtles [ stop ]
  ask sheep [
    move
    if grass? [
      set energy energy - 1  ;; deduct energy for sheep only if grass? switch is on
      eat-grass
    ]
    death
    reproduce-sheep
  ]
  ask wolves [
    move
    set energy energy - 1  ;; wolves lose energy as they move
    catch-sheep
    death
    reproduce-wolves
  ]
  if grass? [ ask patches [ grow-grass ] ]
  set grass count patches with [pcolor = green]
  tick
  display-labels

if (stop?) [stoppaper]  
if (not stop?) [go]

end


to move  ;; turtle procedure
  rt random 50
  lt random 50
  fd 1
end

to eat-grass  ;; sheep procedure
  ;; sheep eat grass, turn the patch brown
  if pcolor = green [
    set pcolor brown
    set energy energy + sheep-gain-from-food  ;; sheep gain energy by eating
  ]
end

to reproduce-sheep  ;; sheep procedure
  if random-float 100 < sheep-reproduce [  ;; throw "dice" to see if you will reproduce
    set energy (energy / 2)                ;; divide energy between parent and offspring
    hatch 1 [ rt random-float 360 fd 1 ]   ;; hatch an offspring and move it forward 1 step
  ]
end

to reproduce-wolves  ;; wolf procedure
  if random-float 100 < wolf-reproduce [  ;; throw "dice" to see if you will reproduce
    set energy (energy / 2)               ;; divide energy between parent and offspring
    hatch 1 [ rt random-float 360 fd 1 ]  ;; hatch an offspring and move it forward 1 step
  ]
end

to catch-sheep  ;; wolf procedure
  let prey one-of sheep-here                    ;; grab a random sheep
  if prey != nobody                             ;; did we get one?  if so,
    [ ask prey [ die ]                          ;; kill it
      set energy energy + wolf-gain-from-food ] ;; get energy from eating
end

to death  ;; turtle procedure
  ;; when energy dips below zero, die
  if energy < 0 [ die ]
end

to grow-grass  ;; patch procedure
  ;; countdown on brown patches: if reach 0, grow some grass
  if pcolor = brown [
    ifelse countdown <= 0
      [ set pcolor green
        set countdown grass-regrowth-time ]
      [ set countdown countdown - 1 ]
  ]
end

to display-labels
  ask turtles [ set label "" ]
  if show-energy? [
    ask wolves [ set label round energy ]
    if grass? [ ask sheep [ set label round energy ] ]
  ]
end

  ;;;;;;;;;;;;;;;;;;;;;  ;;;;;;;;;;;;;;;;;;;;;  ;;;;;;;;;;;;;;;;;;;;;  ;;;;;;;;;;;;;;;;;;;;;  ;;;;;;;;;;;;;;;;;;;;;
  ;;; Go go specific code
  ;;;;;;;;;;;;;;;;;;;;;  ;;;;;;;;;;;;;;;;;;;;;  ;;;;;;;;;;;;;;;;;;;;;  ;;;;;;;;;;;;;;;;;;;;;  ;;;;;;;;;;;;;;;;;;;;;  
;; setup go go board
to setup-gogo
    set serial-port user-one-of "Select a port:" gogo:ports
  gogo:open serial-port
  repeat 5
  [ if not gogo:ping
    [ user-message "The GoGo Board is not responding." ] ]
  gogo:talk-to-output-ports [ "a" "b" "b" "d" ]
  
  
  ;; sets the speed of both pen and paper to 1
  gogo:talk-to-output-ports [ "a" ]
  gogo:set-output-port-power 1
  gogo:talk-to-output-ports [ "b" ]
  gogo:set-output-port-power 1
end


to movepen
 
  ;; find out the change in number of sheep
  ;; if there are more than 200 sheep or less than 110, the graph flatlines at min or max (which is why we
  ;; use a fake sheep count temp var)
  let fakesheepcount 0
  if count sheep > 200 [set fakesheepcount 200]
  if count sheep < 110 [set fakesheepcount 110]
  if fakesheepcount = 0 [set fakesheepcount count sheep]
  ;; find change in sheep
  let dsheep fakesheepcount - lastsheepcount
  
;  if abs dsheep < 30 [stop]
  ;; swap out lastsheepcount for current sheep count
  set lastsheepcount count sheep
  ;; reverse if last change was positive and it is now negative or vice versa
  if ((lastdsheeppos? and dsheep < 0) or (not lastdsheeppos? and dsheep > 0))
  [ show "reverse" ;; print debug
    show dsheep ;; print debug
    ;; "reverse" last change positive bool
    set lastdsheeppos? not lastdsheeppos?
    ;; reverse pen
    stoppen
    reversepen 
    ]
  ;; move the pen for 10 ms per sheep. Abs because otherwise we will set it to negative time and it will not work.
  move-pen-for-time abs dsheep * .5

end



  ;;;;;;;;;;;;;;;;;;;;;  ;;;;;;;;;;;;;;;;;;;;;  ;;;;;;;;;;;;;;;;;;;;;  ;;;;;;;;;;;;;;;;;;;;;  ;;;;;;;;;;;;;;;;;;;;;
  ;;; @Firat new code, our go go related stuff
  ;;;;;;;;;;;;;;;;;;;;;  ;;;;;;;;;;;;;;;;;;;;;  ;;;;;;;;;;;;;;;;;;;;;  ;;;;;;;;;;;;;;;;;;;;;  ;;;;;;;;;;;;;;;;;;;;;  

to gogo-ping
  carefully
  [ if not gogo:ping
    [ user-message "Unable to ping GoGo Board." ] ]
  [ user-message error-message ]
end

to move-pen-for-time [time]
  gogo:talk-to-output-ports [ "a" ]
gogo:output-port-on
  ;; set the timer 
  set penmovetimer time
  reset-timer


end

to runpen
  gogo:talk-to-output-ports [ "a" ]
gogo:output-port-on
end

to stoppen
gogo:talk-to-output-ports [ "a" ]
gogo:output-port-off
end

to runpaper
  gogo:talk-to-output-ports [ "b" ]
gogo:output-port-on
end

to stoppaper
gogo:talk-to-output-ports [ "b" ]
gogo:output-port-off
end



to reversepen
  gogo:talk-to-output-ports [ "a" ]
gogo:output-port-reverse
end


to reversepaper
  gogo:talk-to-output-ports [ "b" ]
gogo:output-port-reverse
end


to pauseanddraw
  ;; find out the change in number of sheep
  ;; if there are more than 200 sheep or less than 110, the graph flatlines at min or max 
  ;; so we either kill extra sheep or make some if there are too few
  let fakesheepcount 0
  if count sheep > 200 [ask n-of (count sheep - 200) sheep [die]]
  if count sheep < 110 [
      create-sheep (110 - count sheep)  ;; create the sheep, then initialize their variables
  [
    set color white
    set size 1.5  ;; easier to see
    set label-color blue - 2
    set energy random (2 * sheep-gain-from-food)
    setxy random-xcor random-ycor
  ]
  ]
    
    
    
  if fakesheepcount = 0 [set fakesheepcount count sheep]
  ;; find change in sheep
  let dsheep fakesheepcount - lastsheepcount  
  
  set lastsheepcount fakesheepcount

  ;; reverse if last change was positive and it is now negative or vice versa
  if ((lastdsheeppos? and dsheep < 0) or (not lastdsheeppos? and dsheep > 0))
  [ ;; wait a second so that go go board does not get confused
    wait 1
    
     show "reverse" ;; print debug

    ;; "reverse" last change positive bool
    set lastdsheeppos? not lastdsheeppos?
    ;; reverse pen
    reversepen 
    ]
    show dsheep ;; print debug  
;  runpaper
  if dsheep != 0
  [

    runpen
    wait abs (dsheep * .01)
  ]
;  stoppaper
  stoppen
  

  
  
  
end


; Copyright 1997 Uri Wilensky.
; See Info tab for full copyright and license.
@#$#@#$#@
GRAPHICS-WINDOW
350
10
819
500
25
25
9.0
1
14
1
1
1
0
1
1
1
-25
25
-25
25
1
1
1
ticks
30.0

SLIDER
3
150
177
183
initial-number-sheep
initial-number-sheep
0
250
100
1
1
NIL
HORIZONTAL

SLIDER
3
187
177
220
sheep-gain-from-food
sheep-gain-from-food
0.0
50.0
4
1.0
1
NIL
HORIZONTAL

SLIDER
3
222
177
255
sheep-reproduce
sheep-reproduce
1.0
20.0
4
1.0
1
%
HORIZONTAL

SLIDER
181
150
346
183
initial-number-wolves
initial-number-wolves
0
250
50
1
1
NIL
HORIZONTAL

SLIDER
181
186
346
219
wolf-gain-from-food
wolf-gain-from-food
0.0
100.0
20
1.0
1
NIL
HORIZONTAL

SLIDER
181
222
346
255
wolf-reproduce
wolf-reproduce
0.0
20.0
5
1.0
1
%
HORIZONTAL

BUTTON
8
28
77
61
setup
setup
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

BUTTON
90
28
157
61
go
go
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL
0

PLOT
12
312
328
509
populations
time
pop.
0.0
100.0
0.0
100.0
true
true
"" ""
PENS
"sheep" 1.0 0 -13345367 true "" "plot count sheep"
"wolves" 1.0 0 -2674135 true "" "plot count wolves"
"grass / 4" 1.0 0 -10899396 true "" "if grass? [ plot grass / 4 ]"

MONITOR
50
265
121
310
sheep
count sheep
3
1
11

MONITOR
125
265
207
310
wolves
count wolves
3
1
11

MONITOR
211
265
287
310
NIL
grass / 4
0
1
11

TEXTBOX
8
130
148
149
Sheep settings
11
0.0
0

TEXTBOX
186
130
299
148
Wolf settings
11
0.0
0

SWITCH
167
28
303
61
show-energy?
show-energy?
1
1
-1000

BUTTON
12
83
161
116
NIL
stoppen\\nstoppaper
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

BUTTON
841
21
918
54
NIL
runpen
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

BUTTON
920
19
1002
52
NIL
stoppen
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

BUTTON
878
68
979
101
NIL
reversepen
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

BUTTON
220
91
309
124
NIL
runpaper
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

SWITCH
875
185
978
218
stop?
stop?
0
1
-1000

@#$#@#$#@
## Reflections

Working on a system with both software and physical components poses unique design challenges. The two design efforts should inform each other and co-evolve so that the program and the robot, in our case, work harmoniously. In our case we made a division of labor in a way that one of us focused more on the software and the other on the robot while we brainstormed on the problems together. A system with such distinct components turned out to be ideal for a group project. 

While we worked closely together (spending almost two days in the same room), we decided to focus on different aspects of the project, with Firat focusing mostly on the construction of the robot, and with Arthur focusing mostly on the code.

## Firat
Since I mostly focused on building the robot I will focus more on the construction of the physical components of the seismograph in this reflection. 

Since I mostly focused on building the robot I will focus more on the construction of the physical components of the seismograph in this reflection. First of all, I never thought that playing with technic Legos as a child would one day help me as a postdoc. Yes, Legos help you develop an understanding of how in a system different components come together and how a change in one part affects the system. I am not talking about these in direct benefits. In a very tangible way as soon as I poured all the Lego parts on the table I was a child again and my knowledge of the tiny pieces of Legos was a live (except I didn't have a brother trying to break what I made). One challenge was not having all the necessary parts (particularly the flat gear), but I was able to come up with a relatively less effective but working solution. Once I built the first prototype Arthur was already done with the software prototype. We brought the software and the robot together and realized that we needed to change things both with the robot and the software. We dedicated nearly two full days to complete the project. After the first prototypes were done we were engaged in a constant cycle of fixing problems, bringing the parts together and testing and fixing problems again. We continuously brainstormed about how to change the robot and the software and sometimes had overly ambitious ideas that had to be scaled down due to practical concerns (lack of parts & time). As you can see in the power point file we listed some of these unrealized design ideas, that might come to life in our next project. Overall this was a very enjoyable project to work on.

# Arthur
I really enjoyed this project! Unlike Firat, I had no prior experience with building robots, and Firat immediately noticed problems about our initial robot sketches that I would have never been able to see. Particuarly things about structural integrity and how much (or little) resistance we could have given our small motors. Regardless, having something tangible to work with, and coding for something in the "real world" added perspectives to coding in NetLogo that I really enjoyed wrestling with.

The biggest challenge was that time matters very little in NetLogo, but plays a huge role when coding to manipulate physical objects. The Wolf Sheep predation model typically runs 30-50 ticks / second on my computer, but I had to slow down the model to a point where it runs only one tick every second or two. I first wanted our robot to do continuous plotting, in which the change in the sheep population would determine the speed of the pen (giving a more steep slope when the increase is larger). However, when we looked at the building materials available, we realized that this would require a broader piece of paper than we could accommodate for. Instead, I decided to have the pen-motor always at the same speed and simply reversing if the population started rising or falling.

Another challenge was with using the GoGo board. Sometimes it would die with no other feedback than an ominous beep. After some hours of trial and error and discussing what could cause this, we agreed that the problem was with the GoGo Board getting too many instructions in too little time. Because of this I slowed down the execution of the model even more, but when we then combined the code and the robot, the motor that moved the paper and the motor that moved the pen were out of sync. I fixed that by having the paper run continuously rather than discreetly, and only giving instructions to the pen-motor. I also really would have liked a 'portOn?' primitive. I couldn't find the GoGo board api or I would have just written that into the jar. Oh well.

All in all a super fun project. I am actually surprised at how much I enjoyed working with things that are not "just" code. Maybe this whole tangible/robotics/body stuff is worth spending more time on?



@#$#@#$#@
default
true
0
Polygon -7500403 true true 150 5 40 250 150 205 260 250

airplane
true
0
Polygon -7500403 true true 150 0 135 15 120 60 120 105 15 165 15 195 120 180 135 240 105 270 120 285 150 270 180 285 210 270 165 240 180 180 285 195 285 165 180 105 180 60 165 15

arrow
true
0
Polygon -7500403 true true 150 0 0 150 105 150 105 293 195 293 195 150 300 150

box
false
0
Polygon -7500403 true true 150 285 285 225 285 75 150 135
Polygon -7500403 true true 150 135 15 75 150 15 285 75
Polygon -7500403 true true 15 75 15 225 150 285 150 135
Line -16777216 false 150 285 150 135
Line -16777216 false 150 135 15 75
Line -16777216 false 150 135 285 75

bug
true
0
Circle -7500403 true true 96 182 108
Circle -7500403 true true 110 127 80
Circle -7500403 true true 110 75 80
Line -7500403 true 150 100 80 30
Line -7500403 true 150 100 220 30

butterfly
true
0
Polygon -7500403 true true 150 165 209 199 225 225 225 255 195 270 165 255 150 240
Polygon -7500403 true true 150 165 89 198 75 225 75 255 105 270 135 255 150 240
Polygon -7500403 true true 139 148 100 105 55 90 25 90 10 105 10 135 25 180 40 195 85 194 139 163
Polygon -7500403 true true 162 150 200 105 245 90 275 90 290 105 290 135 275 180 260 195 215 195 162 165
Polygon -16777216 true false 150 255 135 225 120 150 135 120 150 105 165 120 180 150 165 225
Circle -16777216 true false 135 90 30
Line -16777216 false 150 105 195 60
Line -16777216 false 150 105 105 60

car
false
0
Polygon -7500403 true true 300 180 279 164 261 144 240 135 226 132 213 106 203 84 185 63 159 50 135 50 75 60 0 150 0 165 0 225 300 225 300 180
Circle -16777216 true false 180 180 90
Circle -16777216 true false 30 180 90
Polygon -16777216 true false 162 80 132 78 134 135 209 135 194 105 189 96 180 89
Circle -7500403 true true 47 195 58
Circle -7500403 true true 195 195 58

circle
false
0
Circle -7500403 true true 0 0 300

circle 2
false
0
Circle -7500403 true true 0 0 300
Circle -16777216 true false 30 30 240

cow
false
0
Polygon -7500403 true true 200 193 197 249 179 249 177 196 166 187 140 189 93 191 78 179 72 211 49 209 48 181 37 149 25 120 25 89 45 72 103 84 179 75 198 76 252 64 272 81 293 103 285 121 255 121 242 118 224 167
Polygon -7500403 true true 73 210 86 251 62 249 48 208
Polygon -7500403 true true 25 114 16 195 9 204 23 213 25 200 39 123

cylinder
false
0
Circle -7500403 true true 0 0 300

dot
false
0
Circle -7500403 true true 90 90 120

face happy
false
0
Circle -7500403 true true 8 8 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Polygon -16777216 true false 150 255 90 239 62 213 47 191 67 179 90 203 109 218 150 225 192 218 210 203 227 181 251 194 236 217 212 240

face neutral
false
0
Circle -7500403 true true 8 7 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Rectangle -16777216 true false 60 195 240 225

face sad
false
0
Circle -7500403 true true 8 8 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Polygon -16777216 true false 150 168 90 184 62 210 47 232 67 244 90 220 109 205 150 198 192 205 210 220 227 242 251 229 236 206 212 183

fish
false
0
Polygon -1 true false 44 131 21 87 15 86 0 120 15 150 0 180 13 214 20 212 45 166
Polygon -1 true false 135 195 119 235 95 218 76 210 46 204 60 165
Polygon -1 true false 75 45 83 77 71 103 86 114 166 78 135 60
Polygon -7500403 true true 30 136 151 77 226 81 280 119 292 146 292 160 287 170 270 195 195 210 151 212 30 166
Circle -16777216 true false 215 106 30

flag
false
0
Rectangle -7500403 true true 60 15 75 300
Polygon -7500403 true true 90 150 270 90 90 30
Line -7500403 true 75 135 90 135
Line -7500403 true 75 45 90 45

flower
false
0
Polygon -10899396 true false 135 120 165 165 180 210 180 240 150 300 165 300 195 240 195 195 165 135
Circle -7500403 true true 85 132 38
Circle -7500403 true true 130 147 38
Circle -7500403 true true 192 85 38
Circle -7500403 true true 85 40 38
Circle -7500403 true true 177 40 38
Circle -7500403 true true 177 132 38
Circle -7500403 true true 70 85 38
Circle -7500403 true true 130 25 38
Circle -7500403 true true 96 51 108
Circle -16777216 true false 113 68 74
Polygon -10899396 true false 189 233 219 188 249 173 279 188 234 218
Polygon -10899396 true false 180 255 150 210 105 210 75 240 135 240

house
false
0
Rectangle -7500403 true true 45 120 255 285
Rectangle -16777216 true false 120 210 180 285
Polygon -7500403 true true 15 120 150 15 285 120
Line -16777216 false 30 120 270 120

leaf
false
0
Polygon -7500403 true true 150 210 135 195 120 210 60 210 30 195 60 180 60 165 15 135 30 120 15 105 40 104 45 90 60 90 90 105 105 120 120 120 105 60 120 60 135 30 150 15 165 30 180 60 195 60 180 120 195 120 210 105 240 90 255 90 263 104 285 105 270 120 285 135 240 165 240 180 270 195 240 210 180 210 165 195
Polygon -7500403 true true 135 195 135 240 120 255 105 255 105 285 135 285 165 240 165 195

line
true
0
Line -7500403 true 150 0 150 300

line half
true
0
Line -7500403 true 150 0 150 150

pentagon
false
0
Polygon -7500403 true true 150 15 15 120 60 285 240 285 285 120

person
false
0
Circle -7500403 true true 110 5 80
Polygon -7500403 true true 105 90 120 195 90 285 105 300 135 300 150 225 165 300 195 300 210 285 180 195 195 90
Rectangle -7500403 true true 127 79 172 94
Polygon -7500403 true true 195 90 240 150 225 180 165 105
Polygon -7500403 true true 105 90 60 150 75 180 135 105

plant
false
0
Rectangle -7500403 true true 135 90 165 300
Polygon -7500403 true true 135 255 90 210 45 195 75 255 135 285
Polygon -7500403 true true 165 255 210 210 255 195 225 255 165 285
Polygon -7500403 true true 135 180 90 135 45 120 75 180 135 210
Polygon -7500403 true true 165 180 165 210 225 180 255 120 210 135
Polygon -7500403 true true 135 105 90 60 45 45 75 105 135 135
Polygon -7500403 true true 165 105 165 135 225 105 255 45 210 60
Polygon -7500403 true true 135 90 120 45 150 15 180 45 165 90

sheep
false
15
Rectangle -1 true true 166 225 195 285
Rectangle -1 true true 62 225 90 285
Rectangle -1 true true 30 75 210 225
Circle -1 true true 135 75 150
Circle -7500403 true false 180 76 116

square
false
0
Rectangle -7500403 true true 30 30 270 270

square 2
false
0
Rectangle -7500403 true true 30 30 270 270
Rectangle -16777216 true false 60 60 240 240

star
false
0
Polygon -7500403 true true 151 1 185 108 298 108 207 175 242 282 151 216 59 282 94 175 3 108 116 108

target
false
0
Circle -7500403 true true 0 0 300
Circle -16777216 true false 30 30 240
Circle -7500403 true true 60 60 180
Circle -16777216 true false 90 90 120
Circle -7500403 true true 120 120 60

tree
false
0
Circle -7500403 true true 118 3 94
Rectangle -6459832 true false 120 195 180 300
Circle -7500403 true true 65 21 108
Circle -7500403 true true 116 41 127
Circle -7500403 true true 45 90 120
Circle -7500403 true true 104 74 152

triangle
false
0
Polygon -7500403 true true 150 30 15 255 285 255

triangle 2
false
0
Polygon -7500403 true true 150 30 15 255 285 255
Polygon -16777216 true false 151 99 225 223 75 224

truck
false
0
Rectangle -7500403 true true 4 45 195 187
Polygon -7500403 true true 296 193 296 150 259 134 244 104 208 104 207 194
Rectangle -1 true false 195 60 195 105
Polygon -16777216 true false 238 112 252 141 219 141 218 112
Circle -16777216 true false 234 174 42
Rectangle -7500403 true true 181 185 214 194
Circle -16777216 true false 144 174 42
Circle -16777216 true false 24 174 42
Circle -7500403 false true 24 174 42
Circle -7500403 false true 144 174 42
Circle -7500403 false true 234 174 42

turtle
true
0
Polygon -10899396 true false 215 204 240 233 246 254 228 266 215 252 193 210
Polygon -10899396 true false 195 90 225 75 245 75 260 89 269 108 261 124 240 105 225 105 210 105
Polygon -10899396 true false 105 90 75 75 55 75 40 89 31 108 39 124 60 105 75 105 90 105
Polygon -10899396 true false 132 85 134 64 107 51 108 17 150 2 192 18 192 52 169 65 172 87
Polygon -10899396 true false 85 204 60 233 54 254 72 266 85 252 107 210
Polygon -7500403 true true 119 75 179 75 209 101 224 135 220 225 175 261 128 261 81 224 74 135 88 99

wheel
false
0
Circle -7500403 true true 3 3 294
Circle -16777216 true false 30 30 240
Line -7500403 true 150 285 150 15
Line -7500403 true 15 150 285 150
Circle -7500403 true true 120 120 60
Line -7500403 true 216 40 79 269
Line -7500403 true 40 84 269 221
Line -7500403 true 40 216 269 79
Line -7500403 true 84 40 221 269

wolf
false
0
Rectangle -7500403 true true 195 106 285 150
Rectangle -7500403 true true 195 90 255 105
Polygon -7500403 true true 240 90 217 44 196 90
Polygon -16777216 true false 234 89 218 59 203 89
Rectangle -1 true false 240 93 252 105
Rectangle -16777216 true false 242 96 249 104
Rectangle -16777216 true false 241 125 285 139
Polygon -1 true false 285 125 277 138 269 125
Polygon -1 true false 269 140 262 125 256 140
Rectangle -7500403 true true 45 120 195 195
Rectangle -7500403 true true 45 114 185 120
Rectangle -7500403 true true 165 195 180 270
Rectangle -7500403 true true 60 195 75 270
Polygon -7500403 true true 45 105 15 30 15 75 45 150 60 120

x
false
0
Polygon -7500403 true true 270 75 225 30 30 225 75 270
Polygon -7500403 true true 30 75 75 30 270 225 225 270

@#$#@#$#@
NetLogo 5.0RC7
@#$#@#$#@
setup
set grass? true
repeat 75 [ go ]
@#$#@#$#@
@#$#@#$#@
@#$#@#$#@
@#$#@#$#@
default
0.0
-0.2 0 1.0 0.0
0.0 1 1.0 0.0
0.2 0 1.0 0.0
link direction
true
0
Line -7500403 true 150 150 90 180
Line -7500403 true 150 150 210 180

@#$#@#$#@
0
@#$#@#$#@
