globals [
  sex-ratio-list  ;; global-variable to track time-series data (for behavior space experiment)
  ]
breed [males male]
breed [females female]
;;
females-own [
  partner
  carrying?                   ;; boolean to track if a female is carrying a child after mating
  male-child-chance           ;; this is a probability of giving birth to a male child
  temp-male-child-chance      ;; a variable to store male-chind-chance for a particular father-mother pair
  child-male-child-chance     ;; it is the inherited male-child-chance by a child
  gestation                   ;; a veriable to track time of carrying a child till a female reachers gesatation-period
  age
]

males-own [
  partner
  male-child-chance
  child-male-child-chance
  age
]

;;set-up pupulation of males and females
to setup
  ca
  create-males round ( ( 1 - ini-sex-ratio ) * ini-number ) [
    setxy random-xcor random-ycor
    set shape "male"
    set color green
    set male-child-chance random-normal ini-average-male-child-chance 0.1        ;; males are assinged initial male-child-chance from a random-normal distribution
    set age 0
    set partner nobody
  ]
  create-females round ( ini-sex-ratio * ini-number ) [
    setxy random-xcor random-ycor
    set color blue
    set shape "female"
    set carrying? false
    set partner nobody
    set male-child-chance random-normal ini-average-male-child-chance 0.1        ;; females are assinged initial male-child-chance from a random-normal distribution
  ]
  set sex-ratio-list []
  reset-ticks
end

to go
  if not any? turtles [stop]
  ask males [
    check-if-dead
    move
    search-a-partner
  ]
  ask females [
    check-if-dead
    if not carrying? [move]
    reproduce
  ]
  update-sex-ratio-list
  tick
end

to move
    rt random 60
    lt random 60
    fd 1
end

to search-a-partner
  if count females in-radius 1 with [not carrying?] = 1 and count other males in-radius 1 = 0  [   ;; spatial restriction is used to incorporate density-dependant growth rate
    set partner one-of females in-radius 1 with [not carrying?]
    ]
    if partner = nobody [stop]
    ifelse [partner] of partner != nobody [
      set partner nobody
      stop                        ;; just in case two males find the same partner
    ]
    [
      ifelse random-float 1 < mating-chance [
        ask partner [
          set partner myself
          set carrying? true
          set color orange    ;; color oragne indicates carrying female
          set child-male-child-chance ( ( 1 - inheritance-weight ) * male-child-chance ) +  ( inheritance-weight * ( [male-child-chance] of myself ) )         ;; this is inherited male-child-chance by a child (determined by father and mother according to inheritance-weight)
          set temp-male-child-chance ( ( 1 - sex-determination-weight ) * male-child-chance ) +  ( sex-determination-weight * ( [male-child-chance] of myself ) )   ;; sex of a child is determined by male-child-chance (determined by father and mother according to sex-determination-weight)
        ]
        set partner nobody
      ]
      [
        set partner nobody
      ]
    ]
end

to reproduce
    if carrying? [
      ifelse gestation = gestation-period [   ;; genstation-period can be set. When it's over, a female gives birth to a a child, starts afrest and can have a new partner
        set gestation 0
        set carrying? false
        set color blue
        set partner nobody
        repeat random max-litter-size + 1 [
          ifelse random-float 1 < temp-male-child-chance [    ;; sex of a child is determined by male-child-chance
            hatch 1 [
              set breed males
              set shape "male"
              set color green
              set male-child-chance random-normal child-male-child-chance 0.1
              set age 0
            ]
          ][
          hatch 1 [
            set male-child-chance random-normal child-male-child-chance 0.1
            set age 0
          ]
          ]
        ]
      ][
      set gestation gestation + 1
      ]
    ]

end

to check-if-dead
    ifelse random-float longevity < age [
      die
    ][
    set age age + 1
    ]
end

;; reporting procedures for plotting and for behaviorspace experiments

to-report female-percentage
  ifelse any? turtles [
    report ( count females / count turtles ) * 100
  ]
  [
    report 0
  ]
end

to-report average-male-child-chance
  ifelse any? males [
    report mean [male-child-chance] of males
  ]
  [
    report 0
  ]
end

to update-sex-ratio-list
  if ticks > 10000 [
    set sex-ratio-list lput female-percentage sex-ratio-list
  ]
end

to-report average-sex-ratio
    ifelse length sex-ratio-list > 0 [
    report precision mean sex-ratio-list 2]
    [report 0]
end

to-report sd-sex-ratio
    ifelse length sex-ratio-list > 0 [
    report precision standard-deviation sex-ratio-list 2]
    [report 0]
end
@#$#@#$#@
GRAPHICS-WINDOW
653
13
1140
521
16
16
14.455
1
10
1
1
1
0
1
1
1
-16
16
-16
16
1
1
1
ticks
30.0

BUTTON
26
10
92
43
NIL
setup
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

SLIDER
25
57
197
90
ini-number
ini-number
50
300
250
1
1
NIL
HORIZONTAL

SLIDER
24
94
196
127
ini-sex-ratio
ini-sex-ratio
0
1
0.9
0.01
1
NIL
HORIZONTAL

SLIDER
24
130
240
163
ini-average-male-child-chance
ini-average-male-child-chance
0
1
0.1
0.01
1
NIL
HORIZONTAL

BUTTON
115
12
178
45
NIL
go
T
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

PLOT
275
135
620
255
Population
NIL
NIL
0.0
10.0
0.0
10.0
true
false
"" ""
PENS
"default" 1.0 0 -16777216 true "" "plot count turtles"

PLOT
273
262
622
382
Sex-ratio
NIL
NIL
0.0
10.0
0.0
100.0
true
false
"" ""
PENS
"default" 1.0 0 -16777216 true "" "plot female-percentage"

PLOT
276
10
623
130
Average-male-child-chance
NIL
NIL
0.0
10.0
0.0
1.0
true
false
"" ""
PENS
"default" 1.0 0 -16777216 true "" "plot average-male-child-chance"

SLIDER
24
165
196
198
gestation-period
gestation-period
0
50
8
1
1
NIL
HORIZONTAL

SLIDER
25
202
197
235
max-litter-size
max-litter-size
1
10
5
1
1
NIL
HORIZONTAL

SLIDER
25
279
197
312
mating-chance
mating-chance
0
1
0.9
0.05
1
NIL
HORIZONTAL

PLOT
25
405
620
550
Gender Distribution
NIL
NIL
0.0
10.0
0.0
10.0
true
true
"" ""
PENS
"Males" 1.0 0 -13840069 true "" "plot count males"
"Carrying females" 1.0 0 -955883 true "" "plot count females with [carrying?]"
"Females not carrying" 1.0 0 -13345367 true "" "plot count females with [not carrying?]"
"All females" 1.0 0 -8630108 true "" "plot count females"

SLIDER
25
240
197
273
longevity
longevity
0
1200
1120
10
1
NIL
HORIZONTAL

SLIDER
27
361
246
394
sex-determination-weight
sex-determination-weight
0
1
0.5
0.01
1
NIL
HORIZONTAL

SLIDER
26
325
198
358
inheritance-weight
inheritance-weight
0
1
0.7
0.01
1
NIL
HORIZONTAL

MONITOR
348
357
509
402
Average-female-proportion
average-sex-ratio
17
1
11

MONITOR
507
357
622
402
Standard-deviation
sd-sex-ratio
17
1
11

@#$#@#$#@
## WHAT IS IT

This is the second extension in a series of NetLogo models about population dynamics, population genetics and evolutionary biology developed by Sugat Dabholkar for the Designing & Constructing Models With Multi-Agent Languages, a course offered by Prof. Uri Wilensky at the School of Education and Social Policy in the Northwestern University.

This is an extension of the model Sex Ratio Equilibrium, where the core phenomenon that is modeled is the sex-ratio equilibrium in sexually reproducing organisms. Most of the sexually reproducing organisms have sex-ratio 1:1. Fisher (1930) explained the rational based on natural selection, irrespective of particular mechanism of sex-determination, which is known as Fisher’s first principle (Hamilton, 1967).

This extension allows independent violation of Fisher's assumptions of biparentism as well as Mendelian inheritance. It allows disentangling parental influence on sex-determination and inheritance of sex-determination mechanism.
It captures emergence of Non-Fisherian Sex Ratios or extraordinary sex-ratios (Hamilton, 1967) and allows exploration of effects of variation in differences in parental influence on sex-determination and inheritance of sex-determination mechanism.

## HOW IT WORKS

This is a population dynamics model, where individuals mate, give birth, die. The demographics changes in the population and sex ratio are captured in the model.

There are two types of individuals in the model:
Males   (Indicated by green color)
Females (Indicated by blue color if not carrying a child and indicated by orange color if 	carrying a child)

At every time-step the individuals:
Age and check if dead - probability of dying increases with age
Move
Search-a-partner – (Only males). This procedure involves mating, which is dependent on mating-chance. If agents mate, the female carries. (For simplicity, mating chance incorporate conception-chance as well.)
Reproduce – (Only for females)

Each male and female carries a trait called male-child-chance. This determines the probability of a child being male. In this extension, weighted influence of parents on the determination of the sex of child can be set using a slider.
A child inherits this trait, male-child-chance from its parents with a mutation. The mutation is implemented by choosing the value for the trait from a random-normal distribution with mean equal to weighted average of male-child-chance of the parents.
These two weights can be set separately.

## HOW TO USE IT

Click the SETUP button to set up the population.

You can use sliders to choose the following parameters when you SETUP.

INI-NUMBER                    : initial number of individuals in the population.
INI-SEX-RATIO                 : initial female-proportion in the population
INI-AVERAGE-MALE-CHILD-CHANCE : initial average male child chance of all the individuals in the population
GESTATION-PERIOD              : number of 'ticks' a female is going to carry a child
MAX-LITTER-SIZE               : maximum number of children a female would give birth to 					after she completes gestation
LONGEVITY        	      : maximum 'ticks' an individual lives
MATING-CHANCE     	      : probability that a female mates with a male when a male 					finds a female partner

SEX-DETERMINATION-WEIGHT: This slider determines the influence on sex determination of a child by its parents. 0 means the sex determination of a child is fully influenced by the mother and 1 means the sex determination of a child is fully influenced by the father.

INHERITANCE-WEIGHT: This slider determines influence on inheritance of the child sex-determination trait to the offspring.

Click the GO button to start the simulation.

## THINGS TO NOTICE

When you run the model, notice how changes in the SEX-DETERMINATION-WEIGHT and INHERITANCE-WEIGHT sliders result in evolution of different sex-ratios. Changes in INHERITANCE-WEIGHT has significant impact on the stable sex-ratios, whereas changes in SEX-DETERMINATION-WEIGHT has little impact on the stable sex-ratios.
Also notice that extreme values if the INHERITANCE-WEIGHT result in unstable population.

## THINGS TO TRY

Change the other parameters and see if you can get to a stable extraordinary sex ratio for extreme values of INHERITANCE-WEIGHT.

## EXTENDING THE MODEL

This model implements search of partner by a male, see if you can change it and make it a female action. You can add a variety of features related to evolutionary population genetics and sex ratio equilibrium studies, such as different mortality rates for males and females, sexual selection by females.

## RELATED MODELS

Red Queen, Fish Tank Genetic Drift, Plant Speciation

## CREDITS AND REFERENCES

Hamilton, W. D. (1967). Extraordinary sex ratios. Science, 156(3774), 477-488
Fisher, R. A. (1930). The genetical theory of natural selection: a complete variorum edition. Oxford University Press.

## COPYRIGHT AND LICENSE

Copyright 2006 Uri Wilensky.

![CC BY-NC-SA 3.0](http://ccl.northwestern.edu/images/creativecommons/byncsa.png)

This work is licensed under the Creative Commons Attribution-NonCommercial-ShareAlike 3.0 License.  To view a copy of this license, visit https://creativecommons.org/licenses/by-nc-sa/3.0/ or send a letter to Creative Commons, 559 Nathan Abbott Way, Stanford, California 94305, USA.

Commercial licenses are also available. To inquire about commercial licenses, please contact Uri Wilensky at uri@northwestern.edu.

<!-- 2006 -->
@#$#@#$#@
default
true
0
Polygon -7500403 true true 150 5 40 250 150 205 260 250

airplane
true
0
Polygon -7500403 true true 150 0 135 15 120 60 120 105 15 165 15 195 120 180 135 240 105 270 120 285 150 270 180 285 210 270 165 240 180 180 285 195 285 165 180 105 180 60 165 15

arrow
true
0
Polygon -7500403 true true 150 0 0 150 105 150 105 293 195 293 195 150 300 150

box
false
0
Polygon -7500403 true true 150 285 285 225 285 75 150 135
Polygon -7500403 true true 150 135 15 75 150 15 285 75
Polygon -7500403 true true 15 75 15 225 150 285 150 135
Line -16777216 false 150 285 150 135
Line -16777216 false 150 135 15 75
Line -16777216 false 150 135 285 75

bug
true
0
Circle -7500403 true true 96 182 108
Circle -7500403 true true 110 127 80
Circle -7500403 true true 110 75 80
Line -7500403 true 150 100 80 30
Line -7500403 true 150 100 220 30

butterfly
true
0
Polygon -7500403 true true 150 165 209 199 225 225 225 255 195 270 165 255 150 240
Polygon -7500403 true true 150 165 89 198 75 225 75 255 105 270 135 255 150 240
Polygon -7500403 true true 139 148 100 105 55 90 25 90 10 105 10 135 25 180 40 195 85 194 139 163
Polygon -7500403 true true 162 150 200 105 245 90 275 90 290 105 290 135 275 180 260 195 215 195 162 165
Polygon -16777216 true false 150 255 135 225 120 150 135 120 150 105 165 120 180 150 165 225
Circle -16777216 true false 135 90 30
Line -16777216 false 150 105 195 60
Line -16777216 false 150 105 105 60

car
false
0
Polygon -7500403 true true 300 180 279 164 261 144 240 135 226 132 213 106 203 84 185 63 159 50 135 50 75 60 0 150 0 165 0 225 300 225 300 180
Circle -16777216 true false 180 180 90
Circle -16777216 true false 30 180 90
Polygon -16777216 true false 162 80 132 78 134 135 209 135 194 105 189 96 180 89
Circle -7500403 true true 47 195 58
Circle -7500403 true true 195 195 58

circle
false
0
Circle -7500403 true true 0 0 300

circle 2
false
0
Circle -7500403 true true 0 0 300
Circle -16777216 true false 30 30 240

cow
false
0
Polygon -7500403 true true 200 193 197 249 179 249 177 196 166 187 140 189 93 191 78 179 72 211 49 209 48 181 37 149 25 120 25 89 45 72 103 84 179 75 198 76 252 64 272 81 293 103 285 121 255 121 242 118 224 167
Polygon -7500403 true true 73 210 86 251 62 249 48 208
Polygon -7500403 true true 25 114 16 195 9 204 23 213 25 200 39 123

cylinder
false
0
Circle -7500403 true true 0 0 300

dot
false
0
Circle -7500403 true true 135 135 30

face happy
false
0
Circle -7500403 true true 8 8 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Polygon -16777216 true false 150 255 90 239 62 213 47 191 67 179 90 203 109 218 150 225 192 218 210 203 227 181 251 194 236 217 212 240

face neutral
false
0
Circle -7500403 true true 8 7 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Rectangle -16777216 true false 60 195 240 225

face sad
false
0
Circle -7500403 true true 8 8 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Polygon -16777216 true false 150 168 90 184 62 210 47 232 67 244 90 220 109 205 150 198 192 205 210 220 227 242 251 229 236 206 212 183

female
true
0
Circle -7500403 false true 108 108 85
Line -7500403 true 150 195 150 240
Circle -7500403 true true 103 103 92
Line -7500403 true 135 210 165 210

fish
false
0
Polygon -1 true false 44 131 21 87 15 86 0 120 15 150 0 180 13 214 20 212 45 166
Polygon -1 true false 135 195 119 235 95 218 76 210 46 204 60 165
Polygon -1 true false 75 45 83 77 71 103 86 114 166 78 135 60
Polygon -7500403 true true 30 136 151 77 226 81 280 119 292 146 292 160 287 170 270 195 195 210 151 212 30 166
Circle -16777216 true false 215 106 30

flag
false
0
Rectangle -7500403 true true 60 15 75 300
Polygon -7500403 true true 90 150 270 90 90 30
Line -7500403 true 75 135 90 135
Line -7500403 true 75 45 90 45

flower
false
0
Polygon -10899396 true false 135 120 165 165 180 210 180 240 150 300 165 300 195 240 195 195 165 135
Circle -7500403 true true 85 132 38
Circle -7500403 true true 130 147 38
Circle -7500403 true true 192 85 38
Circle -7500403 true true 85 40 38
Circle -7500403 true true 177 40 38
Circle -7500403 true true 177 132 38
Circle -7500403 true true 70 85 38
Circle -7500403 true true 130 25 38
Circle -7500403 true true 96 51 108
Circle -16777216 true false 113 68 74
Polygon -10899396 true false 189 233 219 188 249 173 279 188 234 218
Polygon -10899396 true false 180 255 150 210 105 210 75 240 135 240

house
false
0
Rectangle -7500403 true true 45 120 255 285
Rectangle -16777216 true false 120 210 180 285
Polygon -7500403 true true 15 120 150 15 285 120
Line -16777216 false 30 120 270 120

leaf
false
0
Polygon -7500403 true true 150 210 135 195 120 210 60 210 30 195 60 180 60 165 15 135 30 120 15 105 40 104 45 90 60 90 90 105 105 120 120 120 105 60 120 60 135 30 150 15 165 30 180 60 195 60 180 120 195 120 210 105 240 90 255 90 263 104 285 105 270 120 285 135 240 165 240 180 270 195 240 210 180 210 165 195
Polygon -7500403 true true 135 195 135 240 120 255 105 255 105 285 135 285 165 240 165 195

line
true
0
Line -7500403 true 150 0 150 300

line half
true
0
Line -7500403 true 150 0 150 150

male
true
0
Circle -7500403 false true 108 108 85
Line -7500403 true 180 120 225 75
Line -7500403 true 195                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      