to setup

  ca
  system-dynamics-setup

end

to go

  system-dynamics-go
  system-dynamics-do-plot

  tick

end
@#$#@#$#@
GRAPHICS-WINDOW
900
10
964
75
-1
-1
1.7
1
10
1
1
1
0
1
1
1
-16
16
-16
16
0
0
1
ticks
30.0

SLIDER
44
328
216
361
F1-slider
F1-slider
0.1
1.2
1.0
0.1
1
NIL
HORIZONTAL

SLIDER
43
374
215
407
F2-slider
F2-slider
0.1
1.2
1.0
0.1
1
NIL
HORIZONTAL

SLIDER
44
419
216
452
Fbrain-slider
Fbrain-slider
0.05
0.5
0.15
0.01
1
NIL
HORIZONTAL

SLIDER
45
466
217
499
Fliver-slider
Fliver-slider
0.01
0.3
0.1
0.01
1
NIL
HORIZONTAL

SLIDER
250
328
422
361
Ftissue-slider
Ftissue-slider
0.01
1
0.75
0.01
1
NIL
HORIZONTAL

SLIDER
249
376
421
409
Fvreturn-slider
Fvreturn-slider
0.1
1.2
1.0
0.01
1
NIL
HORIZONTAL

SLIDER
251
420
423
453
G1-slider
G1-slider
0
10
4.0
1
1
NIL
HORIZONTAL

SLIDER
253
467
425
500
G2-slider
G2-slider
0
10
6.0
1
1
NIL
HORIZONTAL

SLIDER
462
326
634
359
PS1-slider
PS1-slider
0.1
10
5.8
0.1
1
NIL
HORIZONTAL

SLIDER
465
375
637
408
PS2-slider
PS2-slider
0.1
10
5.6
0.1
1
NIL
HORIZONTAL

SLIDER
466
421
638
454
PS3-slider
PS3-slider
0.1
10
8.7
0.1
1
NIL
HORIZONTAL

SLIDER
468
468
640
501
IR-slider
IR-slider
0
200
15.0
1
1
NIL
HORIZONTAL

BUTTON
39
13
102
46
NIL
setup
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

BUTTON
125
12
188
45
NIL
go
T
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

PLOT
31
87
568
311
plot 1
Time (ticks)
Concentration (mmol/L)
0.0
10.0
0.0
0.01
true
true
"" ""
PENS
"Cven" 1.0 0 -6459832 true "" ""
"Caorta" 1.0 0 -2674135 true "" ""
"Cbrain" 1.0 0 -13840069 true "" ""
"Cbrain1" 1.0 0 -13791810 true "" ""
"Clung1" 1.0 0 -7500403 true "" ""
"Decay1+2" 1.0 0 -10022847 true "" " plot ( Decay1 + Decay2)"

MONITOR
582
88
670
133
NIL
Cinf
4
1
11

MONITOR
582
142
668
187
NIL
Cven
4
1
11

MONITOR
583
196
668
241
NIL
Clung
4
1
11

MONITOR
585
253
669
298
NIL
Clung1
4
1
11

MONITOR
683
87
762
132
NIL
Caorta
4
1
11

MONITOR
684
142
761
187
NIL
Cliver
4
1
11

MONITOR
684
195
762
240
NIL
Cliver1
4
1
11

MONITOR
685
253
762
298
NIL
Ctissue2
4
1
11

MONITOR
773
87
850
132
NIL
Cbrain
4
1
11

MONITOR
774
142
850
187
NIL
Cbrain1
4
1
11

MONITOR
776
195
851
240
NIL
Decay1
4
1
11

MONITOR
776
253
851
298
NIL
Decay2
4
1
11

SLIDER
657
326
829
359
CO-slider
CO-slider
1
10
1.9
0.1
1
NIL
HORIZONTAL

MONITOR
862
171
962
216
Contin. infusion
Fl_9
4
1
11

MONITOR
861
115
961
160
Bolus infusion
Infusion
2
1
11

SLIDER
656
377
828
410
Bolus-slider
Bolus-slider
0.01
1000
300.01
10
1
NIL
HORIZONTAL

@#$#@#$#@
## WHAT IS IT?

This model is a system dynamic multicompartment model that describes some of the pharmacokinetic aspects of propofol used as a general anesthetic administered intravenously (bolus dose that may be followed by continuous infusion). After the injection, propofol is distributed in the body fluids, followed by its degradation/metabolism (in the liver, lungs, kidneys, etc.).

Althogh the model is taking care of quantitative aspects it is primarlily of qualitative nature.

To run the model, you need to download it.

## HOW IT WORKS

The model is built under the concept of Total Intravenous Anesthesia (TIVA). The target controlled infusion(TCI) approach tends to maintain a sufficient levels (for adequate anesthesia) of propofol in the brain. This cerebral concentration depends on many factors (e.g., cerebral blood flow, membrane permeability, propofol concentration in blood vessels, etc.), which, in turn, are determined by hemodynamic, metabolic parameters, etc. The relationship between the level/concentration of propofol and these factors are often far from linear. In the current model, most of these relationships are determined by ordinary differential equations.


## HOW TO USE IT

Sliders can be used to ajust model parameters. The prefix in a slider name or elsewhere means:
- F - flow rate
- G - decay rate
- PS - "between-compartments" exchange coefficients (e.g., influenced by membrane permeability)
- C - concentration

IR stands for infusion rate, CO denotes cardiac output, etc.

After pressing the "setup" button one needs to set the sliders values and press "go" button to run the model.

The dynamics of resulting concentrations in various volume compartments (e.g. viens, aorta, etc) and tissues (lung, brain, etc) can be obsrved in the plotting area and are dispayed by respective monitors.


## THINGS TO TRY

By adjusting the sliders (e.g. cardiac output) one can observe the effect of this on brain concentration of the drug. Of particular interest may be the time required to achieve the maximum concentration in a particular tissue. With these settings, you can simulate various clinical situations.


## EXTENDING THE MODEL

The model can be extended by adding additional parameters (in the form of additional sliders) that may be relevant for a particular clinical condition/scenario.

## CREDITS AND REFERENCES

Please email any questions or comments to viapascurta@yahoo.com

The model was created in NetLogo 6.2.0, Wilensky, U. (1999). NetLogo. http://ccl.northwestern.edu/netlogo/. Center for Connected Learning and Computer-Based Modeling, Northwestern University, Evanston, IL.
@#$#@#$#@
default
true
0
Polygon -7500403 true true 150 5 40 250 150 205 260 250

airplane
true
0
Polygon -7500403 true true 150 0 135 15 120 60 120 105 15 165 15 195 120 180 135 240 105 270 120 285 150 270 180 285 210 270 165 240 180 180 285 195 285 165 180 105 180 60 165 15

arrow
true
0
Polygon -7500403 true true 150 0 0 150 105 150 105 293 195 293 195 150 300 150

box
false
0
Polygon -7500403 true true 150 285 285 225 285 75 150 135
Polygon -7500403 true true 150 135 15 75 150 15 285 75
Polygon -7500403 true true 15 75 15 225 150 285 150 135
Line -16777216 false 150 285 150 135
Line -16777216 false 150 135 15 75
Line -16777216 false 150 135 285 75

bug
true
0
Circle -7500403 true true 96 182 108
Circle -7500403 true true 110 127 80
Circle -7500403 true true 110 75 80
Line -7500403 true 150 100 80 30
Line -7500403 true 150 100 220 30

butterfly
true
0
Polygon -7500403 true true 150 165 209 199 225 225 225 255 195 270 165 255 150 240
Polygon -7500403 true true 150 165 89 198 75 225 75 255 105 270 135 255 150 240
Polygon -7500403 true true 139 148 100 105 55 90 25 90 10 105 10 135 25 180 40 195 85 194 139 163
Polygon -7500403 true true 162 150 200 105 245 90 275 90 290 105 290 135 275 180 260 195 215 195 162 165
Polygon -16777216 true false 150 255 135 225 120 150 135 120 150 105 165 120 180 150 165 225
Circle -16777216 true false 135 90 30
Line -16777216 false 150 105 195 60
Line -16777216 false 150 105 105 60

car
false
0
Polygon -7500403 true true 300 180 279 164 261 144 240 135 226 132 213 106 203 84 185 63 159 50 135 50 75 60 0 150 0 165 0 225 300 225 300 180
Circle -16777216 true false 180 180 90
Circle -16777216 true false 30 180 90
Polygon -16777216 true false 162 80 132 78 134 135 209 135 194 105 189 96 180 89
Circle -7500403 true true 47 195 58
Circle -7500403 true true 195 195 58

circle
false
0
Circle -7500403 true true 0 0 300

circle 2
false
0
Circle -7500403 true true 0 0 300
Circle -16777216 true false 30 30 240

cow
false
0
Polygon -7500403 true true 200 193 197 249 179 249 177 196 166 187 140 189 93 191 78 179 72 211 49 209 48 181 37 149 25 120 25 89 45 72 103 84 179 75 198 76 252 64 272 81 293 103 285 121 255 121 242 118 224 167
Polygon -7500403 true true 73 210 86 251 62 249 48 208
Polygon -7500403 true true 25 114 16 195 9 204 23 213 25 200 39 123

cylinder
false
0
Circle -7500403 true true 0 0 300

dot
false
0
Circle -7500403 true true 90 90 120

face happy
false
0
Circle -7500403 true true 8 8 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Polygon -16777216 true false 150 255 90 239 62 213 47 191 67 179 90 203 109 218 150 225 192 218 210 203 227 181 251 194 236 217 212 240

face neutral
false
0
Circle -7500403 true true 8 7 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Rectangle -16777216 true false 60 195 240 225

face sad
false
0
Circle -7500403 true true 8 8 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Polygon -16777216 true false 150 168 90 184 62 210 47 232 67 244 90 220 109 205 150 198 192 205 210 220 227 242 251 229 236 206 212 183

fish
false
0
Polygon -1 true false 44 131 21 87 15 86 0 120 15 150 0 180 13 214 20 212 45 166
Polygon -1 true false 135 195 119 235 95 218 76 210 46 204 60 165
Polygon -1 true false 75 45 83 77 71 103 86 114 166 78 135 60
Polygon -7500403 true true 30 136 151 77 226 81 280 119 292 146 292 160 287 170 270 195 195 210 151 212 30 166
Circle -16777216 true false 215 106 30

flag
false
0
Rectangle -7500403 true true 60 15 75 300
Polygon -7500403 true true 90 150 270 90 90 30
Line -7500403 true 75 135 90 135
Line -7500403 true 75 45 90 45

flower
false
0
Polygon -10899396 true false 135 120 165 165 180 210 180 240 150 300 165 300 195 240 195 195 165 135
Circle -7500403 true true 85 132 38
Circle -7500403 true true 130 147 38
Circle -7500403 true true 192 85 38
Circle -7500403 true true 85 40 38
Circle -7500403 true true 177 40 38
Circle -7500403 true true 177 132 38
Circle -7500403 true true 70 85 38
Circle -7500403 true true 130 25 38
Circle -7500403 true true 96 51 108
Circle -16777216 true false 113 68 74
Polygon -10899396 true false 189 233 219 188 249 173 279 188 234 218
Polygon -10899396 true false 180 255 150 210 105 210 75 240 135 240

house
false
0
Rectangle -7500403 true true 45 120 255 285
Rectangle -16777216 true false 120 210 180 285
Polygon -7500403 true true 15 120 150 15 285 120
Line -16777216 false 30 120 270 120

leaf
false
0
Polygon -7500403 true true 150 210 135 195 120 210 60 210 30 195 60 180 60 165 15 135 30 120 15 105 40 104 45 90 60 90 90 105 105 120 120 120 105 60 120 60 135 30 150 15 165 30 180 60 195 60 180 120 195 120 210 105 240 90 255 90 263 104 285 105 270 120 285 135 240 165 240 180 270 195 240 210 180 210 165 195
Polygon -7500403 true true 135 195 135 240 120 255 105 255 105 285 135 285 165 240 165 195

line
true
0
Line -7500403 true 150 0 150 300

line half
true
0
Line -7500403 true 150 0 150 150

pentagon
false
0
Polygon -7500403 true true 150 15 15 120 60 285 240 285 285 120

person
false
0
Circle -7500403 true true 110 5 80
Polygon -7500403 true true 105 90 120 195 90 285 105 300 135 300 150 225 165 300 195 300 210 285 180 195 195 90
Rectangle -7500403 true true 127 79 172 94
Polygon -7500403 true true 195 90 240 150 225 180 165 105
Polygon -7500403 true true 105 90 60 150 75 180 135 105

plant
false
0
Rectangle -7500403 true true 135 90 165 300
Polygon -7500403 true true 135 255 90 210 45 195 75 255 135 285
Polygon -7500403 true true 165 255 210 210 255 195 225 255 165 285
Polygon -7500403 true true 135 180 90 135 45 120 75 180 135 210
Polygon -7500403 true true 165 180 165 210 225 180 255 120 210 135
Polygon -7500403 true true 135 105 90 60 45 45 75 105 135 135
Polygon -7500403 true true 165 105 165 135 225 105 255 45 210 60
Polygon -7500403 true true 135 90 120 45 150 15 180 45 165 90

sheep
false
15
Circle -1 true true 203 65 88
Circle -1 true true 70 65 162
Circle -1 true true 150 105 120
Polygon -7500403 true false 218 120 240 165 255 165 278 120
Circle -7500403 true false 214 72 67
Rectangle -1 true true 164 223 179 298
Polygon -1 true true 45 285 30 285 30 240 15 195 45 210
Circle -1 true true 3 83 150
Rectangle -1 true true 65 221 80 296
Polygon -1 true true 195 285 210 285 210 240 240 210 195 210
Polygon -7500403 true false 276 85 285 105 302 99 294 83
Polygon -7500403 true false 219 85 210 105 193 99 201 83

square
false
0
Rectangle -7500403 true true 30 30 270 270

square 2
false
0
Rectangle -7500403 true true 30 30 270 270
Rectangle -16777216 true false 60 60 240 240

star
false
0
Polygon -7500403 true true 151 1 185 108 298 108 207 175 242 282 151 216 59 282 94 175 3 108 116 108

target
false
0
Circle -7500403 true true 0 0 300
Circle -16777216 true false 30 30 240
Circle -7500403 true true 60 60 180
Circle -16777216 true false 90 90 120
Circle -7500403 true true 120 120 60

tree
false
0
Circle -7500403 true true 118 3 94
Rectangle -6459832 true false 120 195 180 300
Circle -7500403 true true 65 21 108
Circle -7500403 true true 116 41 127
Circle -7500403 true true 45 90 120
Circle -7500403 true true 104 74 152

triangle
false
0
Polygon -7500403 true true 150 30 15 255 285 255

triangle 2
false
0
Polygon -7500403 true true 150 30 15 255 285 255
Polygon -16777216 true false 151 99 225 223 75 224

truck
false
0
Rectangle -7500403 true true 4 45 195 187
Polygon -7500403 true true 296 193 296 150 259 134 244 104 208 104 207 194
Rectangle -1 true false 195 60 195 105
Polygon -16777216 true false 238 112 252 141 219 141 218 112
Circle -16777216 true false 234 174 42
Rectangle -7500403 true true 181 185 214 194
Circle -16777216 true false 144 174 42
Circle -16777216 true false 24 174 42
Circle -7500403 false true 24 174 42
Circle -7500403 false true 144 174 42
Circle -7500403 false true 234 174 42

turtle
true
0
Polygon -10899396 true false 215 204 240 233 246 254 228 266 215 252 193 210
Polygon -10899396 true false 195 90 225 75 245 75 260 89 269 108 261 124 240 105 225 105 210 105
Polygon -10899396 true false 105 90 75 75 55 75 40 89 31 108 39 124 60 105 75 105 90 105
Polygon -10899396 true false 132 85 134 64 107 51 108 17 150 2 192 18 192 52 169 65 172 87
Polygon -10899396 true false 85 204 60 233 54 254 72 266 85 252 107 210
Polygon -7500403 true true 119 75 179 75 209 101 224 135 220 225 175 261 128 261 81 224 74 135 88 99

wheel
false
0
Circle -7500403 true true 3 3 294
Circle -16777216 true false 30 30 240
Line -7500403 true 150 285 150 15
Line -7500403 true 15 150 285 150
Circle -7500403 true true 120 120 60
Line -7500403 true 216 40 79 269
Line -7500403 true 40 84 269 221
Line -7500403 true 40 216 269 79
Line -7500403 true 84 40 221 269

wolf
false
0
Polygon -16777216 true false 253 133 245 131 245 133
Polygon -7500403 true true 2 194 13 197 30 191 38 193 38 205 20 226 20 257 27 265 38 266 40 260 31 253 31 230 60 206 68 198 75 209 66 228 65 243 82 261 84 268 100 267 103 261 77 239 79 231 100 207 98 196 119 201 143 202 160 195 166 210 172 213 173 238 167 251 160 248 154 265 169 264 178 247 186 240 198 260 200 271 217 271 219 262 207 258 195 230 192 198 210 184 227 164 242 144 259 145 284 151 277 141 293 140 299 134 297 127 273 119 270 105
Polygon -7500403 true true -1 195 14 180 36 166 40 153 53 140 82 131 134 133 159 126 188 115 227 108 236 102 238 98 268 86 269 92 281 87 269 103 269 113

x
false
0
Polygon -7500403 true true 270 75 225 30 30 225 75 270
Polygon -7500403 true true 30 75 75 30 270 225 225 270
@#$#@#$#@
NetLogo 6.2.0
@#$#@#$#@
@#$#@#$#@
0.001
    org.nlogo.sdm.gui.AggregateDrawing 75
        org.nlogo.sdm.gui.StockFigure "attributes" "attributes" 1 "FillColor" "Color" 225 225 182 253 196 60 40
            org.nlogo.sdm.gui.WrappedStock "Cinf" "Bolus-slider" 1
        org.nlogo.sdm.gui.StockFigure "attributes" "attributes" 1 "FillColor" "Color" 225 225 182 346 389 60 40
            org.nlogo.sdm.gui.WrappedStock "Cven" "0" 1
        org.nlogo.sdm.gui.StockFigure "attributes" "attributes" 1 "FillColor" "Color" 225 225 182 591 193 60 40
            org.nlogo.sdm.gui.WrappedStock "Clung" "0" 1
        org.nlogo.sdm.gui.StockFigure "attributes" "attributes" 1 "FillColor" "Color" 225 225 182 744 192 60 40
            org.nlogo.sdm.gui.WrappedStock "Caorta" "0" 1
        org.nlogo.sdm.gui.RateConnection 3 298 248 329 312 360 377 NULL NULL 0 0 0
            org.jhotdraw.standard.ChopBoxConnector REF 1
            org.jhotdraw.standard.ChopBoxConnector REF 3
            org.nlogo.sdm.gui.WrappedRate "Cinf * Fvreturn" "Fl_9" REF 2 REF 4 0
        org.nlogo.sdm.gui.RateConnection 3 414 377 496 310 579 245 NULL NULL 0 0 0
            org.jhotdraw.standard.ChopBoxConnector REF 3
            org.jhotdraw.standard.ChopBoxConnector REF 5
            org.nlogo.sdm.gui.WrappedRate "Cven * F1" "Fl_1" REF 4 REF 6 0
        org.nlogo.sdm.gui.RateConnection 3 663 211 697 211 732 211 NULL NULL 0 0 0
            org.jhotdraw.standard.ChopBoxConnector REF 5
            org.jhotdraw.standard.ChopBoxConnector REF 7
            org.nlogo.sdm.gui.WrappedRate "Clung * F2" "Fl_2" REF 6 REF 8 0
        org.nlogo.sdm.gui.StockFigure "attributes" "attributes" 1 "FillColor" "Color" 225 225 182 856 539 60 40
            org.nlogo.sdm.gui.WrappedStock "Cbrain" "0" 1
        org.nlogo.sdm.gui.StockFigure "attributes" "attributes" 1 "FillColor" "Color" 225 225 182 749 393 60 40
            org.nlogo.sdm.gui.WrappedStock "Cliver" "0" 1
        org.nlogo.sdm.gui.StockFigure "attributes" "attributes" 1 "FillColor" "Color" 225 225 182 604 309 60 40
            org.nlogo.sdm.gui.WrappedStock "Ctissue2" "0" 1
        org.nlogo.sdm.gui.RateConnection 3 784 244 829 385 875 527 NULL NULL 0 0 0
            org.jhotdraw.standard.ChopBoxConnector REF 7
            org.jhotdraw.standard.ChopBoxConnector REF 21
            org.nlogo.sdm.gui.WrappedRate "Caorta * Fbrain" "Fl_5" REF 8 REF 22 0
        org.nlogo.sdm.gui.RateConnection 3 844 546 631 483 418 421 NULL NULL 0 0 0
            org.jhotdraw.standard.ChopBoxConnector REF 21
            org.jhotdraw.standard.ChopBoxConnector REF 3
            org.nlogo.sdm.gui.WrappedRate "Cbrain * Fbrain" "Fl_6" REF 22 REF 4 0
        org.nlogo.sdm.gui.RateConnection 3 774 244 775 312 777 381 NULL NULL 0 0 0
            org.jhotdraw.standard.ChopBoxConnector REF 7
            org.jhotdraw.standard.ChopBoxConnector REF 23
            org.nlogo.sdm.gui.WrappedRate "Caorta * Fliver" "Fl_4" REF 8 REF 24 0
        org.nlogo.sdm.gui.RateConnection 3 737 412 577 410 418 409 NULL NULL 0 0 0
            org.jhotdraw.standard.ChopBoxConnector REF 23
            org.jhotdraw.standard.ChopBoxConnector REF 3
            org.nlogo.sdm.gui.WrappedRate "Cliver * Fliver" "Fl_7" REF 24 REF 4 0
        org.nlogo.sdm.gui.RateConnection 3 734 244 702 270 670 297 NULL NULL 0 0 0
            org.jhotdraw.standard.ChopBoxConnector REF 7
            org.jhotdraw.standard.ChopBoxConnector REF 25
            org.nlogo.sdm.gui.WrappedRate "Caorta * Ftissue" "Fl_3" REF 8 REF 26 0
        org.nlogo.sdm.gui.RateConnection 3 592 342 505 369 418 395 NULL NULL 0 0 0
            org.jhotdraw.standard.ChopBoxConnector REF 25
            org.jhotdraw.standard.ChopBoxConnector REF 3
            org.nlogo.sdm.gui.WrappedRate "Ctissue2 * Ftissue" "Fl_8" REF 26 REF 4 0
        org.nlogo.sdm.gui.StockFigure "attributes" "attributes" 1 "FillColor" "Color" 225 225 182 575 26 60 40
            org.nlogo.sdm.gui.WrappedStock "Clung1" "0" 1
        org.nlogo.sdm.gui.RateConnection 3 617 181 612 129 607 78 NULL NULL 0 0 0
            org.jhotdraw.standard.ChopBoxConnector REF 5
            org.jhotdraw.standard.ChopBoxConnector REF 51
            org.nlogo.sdm.gui.WrappedRate "( PS1 * Clung ) - ( PS1 * Clung1)" "L-out" REF 6 REF 52 0
        org.nlogo.sdm.gui.RateConnection 3 608 78 614 129 618 181 NULL NULL 0 0 0
            org.jhotdraw.standard.ChopBoxConnector REF 51
            org.jhotdraw.standard.ChopBoxConnector REF 5
            org.nlogo.sdm.gui.WrappedRate "( PS1 * Clung1) - (PS1 - Clung)" "L-in" REF 52 REF 6 0
        org.nlogo.sdm.gui.StockFigure "attributes" "attributes" 1 "FillColor" "Color" 225 225 182 1029 532 60 40
            org.nlogo.sdm.gui.WrappedStock "Cbrain1" "0" 1
        org.nlogo.sdm.gui.RateConnection 3 928 554 972 550 1017 551 NULL NULL 0 0 0
            org.jhotdraw.standard.ChopBoxConnector REF 21
            org.jhotdraw.standard.ChopBoxConnector REF 61
            org.nlogo.sdm.gui.WrappedRate "( PS3 * Cbrain ) - ( PS3 * Cbrain1)" "Br-out" REF 22 REF 62 0
        org.nlogo.sdm.gui.RateConnection 3 1017 554 972 558 928 558 NULL NULL 0 0 0
            org.jhotdraw.standard.ChopBoxConnector REF 61
            org.jhotdraw.standard.ChopBoxConnector REF 21
            org.nlogo.sdm.gui.WrappedRate "( PS3 * Cbrain1 ) - ( PS3 * Cbrain )" "Br-in" REF 62 REF 22 0
        org.nlogo.sdm.gui.StockFigure "attributes" "attributes" 1 "FillColor" "Color" 225 225 182 956 350 60 40
            org.nlogo.sdm.gui.WrappedStock "Cliver1" "0" 1
        org.nlogo.sdm.gui.RateConnection 3 821 403 882 390 944 378 NULL NULL 0 0 0
            org.jhotdraw.standard.ChopBoxConnector REF 23
            org.jhotdraw.standard.ChopBoxConnector REF 71
            org.nlogo.sdm.gui.WrappedRate "( PS2 * Cliver ) - ( PS2 * Cliver1 )" "Liver-out" REF 24 REF 72 0
        org.nlogo.sdm.gui.RateConnection 3 944 379 882 393 821 404 NULL NULL 0 0 0
            org.jhotdraw.standard.ChopBoxConnector REF 71
            org.jhotdraw.standard.ChopBoxConnector REF 23
            org.nlogo.sdm.gui.WrappedRate "( PS2 * Cliver1 ) - ( PS2 * Cliver )" "Liver-in" REF 72 REF 24 0
        org.nlogo.sdm.gui.ReservoirFigure "attributes" "attributes" 1 "FillColor" "Color" 192 192 192 127 197 30 30
        org.nlogo.sdm.gui.RateConnection 3 157 213 199 214 241 215 NULL NULL 0 0 0
            org.jhotdraw.figures.ChopEllipseConnector REF 81
            org.jhotdraw.standard.ChopBoxConnector REF 1
            org.nlogo.sdm.gui.WrappedRate "ifelse-value ( Cinf >= 1000 )\n\n[ 0 ]\n[ IR * Cinf ]" "Infusion"
                org.nlogo.sdm.gui.WrappedReservoir  REF 2 0
        org.nlogo.sdm.gui.ConverterFigure "attributes" "attributes" 1 "FillColor" "Color" 130 188 183 454 113 50 50
            org.nlogo.sdm.gui.WrappedConverter "CO * F1-slider" "F1"
        org.nlogo.sdm.gui.BindingConnection 2 481 160 496 310 NULL NULL 0 0 0
            org.jhotdraw.contrib.ChopDiamondConnector REF 87
            org.nlogo.sdm.gui.ChopRateConnector REF 13
        org.nlogo.sdm.gui.ConverterFigure "attributes" "attributes" 1 "FillColor" "Color" 130 188 183 712 107 50 50
            org.nlogo.sdm.gui.WrappedConverter "CO * F2-slider" "F2"
        org.nlogo.sdm.gui.BindingConnection 2 728 148 697 211 NULL NULL 0 0 0
            org.jhotdraw.contrib.ChopDiamondConnector REF 92
            org.nlogo.sdm.gui.ChopRateConnector REF 17
        org.nlogo.sdm.gui.ConverterFigure "attributes" "attributes" 1 "FillColor" "Color" 130 188 183 913 271 50 50
            org.nlogo.sdm.gui.WrappedConverter "Fbrain-slider" "Fbrain"
        org.nlogo.sdm.gui.BindingConnection 2 924 307 829 385 NULL NULL 0 0 0
            org.jhotdraw.contrib.ChopDiamondConnector REF 97
            org.nlogo.sdm.gui.ChopRateConnector REF 27
        org.nlogo.sdm.gui.ConverterFigure "attributes" "attributes" 1 "FillColor" "Color" 130 188 183 1132 146 50 50
            org.nlogo.sdm.gui.WrappedConverter "Fliver-slider" "Fliver"
        org.nlogo.sdm.gui.BindingConnection 2 1138 177 775 312 NULL NULL 0 0 0
            org.jhotdraw.contrib.ChopDiamondConnector REF 102
            org.nlogo.sdm.gui.ChopRateConnector REF 35
        org.nlogo.sdm.gui.ConverterFigure "attributes" "attributes" 1 "FillColor" "Color" 130 188 183 923 130 50 50
            org.nlogo.sdm.gui.WrappedConverter "Ftissue-slider" "Ftissue"
        org.nlogo.sdm.gui.BindingConnection 2 930 162 702 270 NULL NULL 0 0 0
            org.jhotdraw.contrib.ChopDiamondConnector REF 107
            org.nlogo.sdm.gui.ChopRateConnector REF 43
        org.nlogo.sdm.gui.ConverterFigure "attributes" "attributes" 1 "FillColor" "Color" 130 188 183 377 200 50 50
            org.nlogo.sdm.gui.WrappedConverter "Fvreturn-slider" "Fvreturn"
        org.nlogo.sdm.gui.BindingConnection 2 390 238 329 312 NULL NULL 0 0 0
            org.jhotdraw.contrib.ChopDiamondConnector REF 112
            org.nlogo.sdm.gui.ChopRateConnector REF 9
        org.nlogo.sdm.gui.StockFigure "attributes" "attributes" 1 "FillColor" "Color" 225 225 182 1106 347 60 40
            org.nlogo.sdm.gui.WrappedStock "Decay2" "0" 1
        org.nlogo.sdm.gui.RateConnection 3 1028 367 1061 366 1094 366 NULL NULL 0 0 0
            org.jhotdraw.standard.ChopBoxConnector REF 71
            org.jhotdraw.standard.ChopBoxConnector REF 117
            org.nlogo.sdm.gui.WrappedRate "Cliver * G2" "L-metab" REF 72 REF 118 0
        org.nlogo.sdm.gui.RateConnection 3 1139 399 1143 432 1147 466 NULL NULL 0 0 0
            org.jhotdraw.standard.ChopBoxConnector REF 117
            org.jhotdraw.figures.ChopEllipseConnector
                org.nlogo.sdm.gui.ReservoirFigure "attributes" "attributes" 1 "FillColor" "Color" 192 192 192 1132 465 30 30
            org.nlogo.sdm.gui.WrappedRate "Decay2 * Fliver" "Liver_dec_wash" REF 118
                org.nlogo.sdm.gui.WrappedReservoir  0   REF 126
        org.nlogo.sdm.gui.StockFigure "attributes" "attributes" 1 "FillColor" "Color" 225 225 182 733 30 60 40
            org.nlogo.sdm.gui.WrappedStock "Decay1" "0" 1
        org.nlogo.sdm.gui.RateConnection 3 647 46 684 47 721 48 NULL NULL 0 0 0
            org.jhotdraw.standard.ChopBoxConnector REF 51
            org.jhotdraw.standard.ChopBoxConnector REF 129
            org.nlogo.sdm.gui.WrappedRate "Clung1 * G1" "Lung-metab" REF 52 REF 130 0
        org.nlogo.sdm.gui.RateConnection 3 805 54 844 59 884 64 NULL NULL 0 0 0
            org.jhotdraw.standard.ChopBoxConnector REF 129
            org.jhotdraw.figures.ChopEllipseConnector
                org.nlogo.sdm.gui.ReservoirFigure "attributes" "attributes" 1 "FillColor" "Color" 192 192 192 883 50 30 30
            org.nlogo.sdm.gui.WrappedRate "Decay1 * F2" "Lung_dec_wash" REF 130
                org.nlogo.sdm.gui.WrappedReservoir  0   REF 138
        org.nlogo.sdm.gui.ConverterFigure "attributes" "attributes" 1 "FillColor" "Color" 130 188 183 676 75 50 50
            org.nlogo.sdm.gui.WrappedConverter "G1-slider" "G1"
        org.nlogo.sdm.gui.BindingConnection 2 694 81 684 47 NULL NULL 0 0 0
            org.jhotdraw.contrib.ChopDiamondConnector REF 141
            org.nlogo.sdm.gui.ChopRateConnector REF 131
        org.nlogo.sdm.gui.ConverterFigure "attributes" "attributes" 1 "FillColor" "Color" 130 188 183 1074 267 50 50
            org.nlogo.sdm.gui.WrappedConverter "G2-slider" "G2"
        org.nlogo.sdm.gui.BindingConnection 2 1090 308 1061 366 NULL NULL 0 0 0
            org.jhotdraw.contrib.ChopDiamondConnector REF 146
            org.nlogo.sdm.gui.ChopRateConnector REF 119
        org.nlogo.sdm.gui.ConverterFigure "attributes" "attributes" 1 "FillColor" "Color" 130 188 183 476 51 50 50
            org.nlogo.sdm.gui.WrappedConverter "PS1-slider" "PS1"
        org.nlogo.sdm.gui.BindingConnection 2 517 84 612 129 NULL NULL 0 0 0
            org.jhotdraw.contrib.ChopDiamondConnector REF 151
            org.nlogo.sdm.gui.ChopRateConnector REF 53
        org.nlogo.sdm.gui.BindingConnection 2 517 84 614 129 NULL NULL 0 0 0
            org.jhotdraw.contrib.ChopDiamondConnector REF 151
            org.nlogo.sdm.gui.ChopRateConnector REF 57
        org.nlogo.sdm.gui.ConverterFigure "attributes" "attributes" 1 "FillColor" "Color" 130 188 183 979 257 50 50
            org.nlogo.sdm.gui.WrappedConverter "PS2-slider" "PS2"
        org.nlogo.sdm.gui.BindingConnection 2 990 293 882 390 NULL NULL 0 0 0
            org.jhotdraw.contrib.ChopDiamondConnector REF 159
            org.nlogo.sdm.gui.ChopRateConnector REF 73
        org.nlogo.sdm.gui.BindingConnection 2 990 293 882 393 NULL NULL 0 0 0
            org.jhotdraw.contrib.ChopDiamondConnector REF 159
            org.nlogo.sdm.gui.ChopRateConnector REF 77
        org.nlogo.sdm.gui.ConverterFigure "attributes" "attributes" 1 "FillColor" "Color" 130 188 183 1011 437 50 50
            org.nlogo.sdm.gui.WrappedConverter "PS3-slider" "PS3"
        org.nlogo.sdm.gui.BindingConnection 2 1025 476 972 550 NULL NULL 0 0 0
            org.jhotdraw.contrib.ChopDiamondConnector REF 167
            org.nlogo.sdm.gui.ChopRateConnector REF 63
        org.nlogo.sdm.gui.BindingConnection 2 1025 476 972 558 NULL NULL 0 0 0
            org.jhotdraw.contrib.ChopDiamondConnector REF 167
            org.nlogo.sdm.gui.ChopRateConnector REF 67
        org.nlogo.sdm.gui.ConverterFigure "attributes" "attributes" 1 "FillColor" "Color" 130 188 183 149 102 50 50
            org.nlogo.sdm.gui.WrappedConverter "IR-slider" "IR"
        org.nlogo.sdm.gui.BindingConnection 2 179 146 199 214 NULL NULL 0 0 0
            org.jhotdraw.contrib.ChopDiamondConnector REF 175
            org.nlogo.sdm.gui.ChopRateConnector REF 82
        org.nlogo.sdm.gui.BindingConnection 2 241 215 199 214 NULL NULL 0 0 0
            org.jhotdraw.standard.ChopBoxConnector REF 1
            org.nlogo.sdm.gui.ChopRateConnector REF 82
        org.nlogo.sdm.gui.ConverterFigure "attributes" "attributes" 1 "FillColor" "Color" 130 188 183 270 59 50 50
            org.nlogo.sdm.gui.WrappedConverter "CO-slider" "CO"
        org.nlogo.sdm.gui.BindingConnection 2 314 89 459 132 NULL NULL 0 0 0
            org.jhotdraw.contrib.ChopDiamondConnector REF 183
            org.jhotdraw.contrib.ChopDiamondConnector REF 87
        org.nlogo.sdm.gui.BindingConnection 2 317 86 714 129 NULL NULL 0 0 0
            org.jhotdraw.contrib.ChopDiamondConnector REF 183
            org.jhotdraw.contrib.ChopDiamondConnector REF 92
        org.nlogo.sdm.gui.BindingConnection 2 305 98 391 210 NULL NULL 0 0 0
            org.jhotdraw.contrib.ChopDiamondConnector REF 183
            org.jhotdraw.contrib.ChopDiamondConnector REF 112
        org.nlogo.sdm.gui.BindingConnection 2 317 86 925 152 NULL NULL 0 0 0
            org.jhotdraw.contrib.ChopDiamondConnector REF 183
            org.jhotdraw.contrib.ChopDiamondConnector REF 107
        org.nlogo.sdm.gui.BindingConnection 2 317 86 1134 168 NULL NULL 0 0 0
            org.jhotdraw.contrib.ChopDiamondConnector REF 183
            org.jhotdraw.contrib.ChopDiamondConnector REF 102
        org.nlogo.sdm.gui.BindingConnection 2 313 90 919 289 NULL NULL 0 0 0
            org.jhotdraw.contrib.ChopDiamondConnector REF 183
            org.jhotdraw.contrib.ChopDiamondConnector REF 97
        org.nlogo.sdm.gui.BindingConnection 2 505 369 702 270 NULL NULL 0 0 0
            org.nlogo.sdm.gui.ChopRateConnector REF 47
            org.nlogo.sdm.gui.ChopRateConnector REF 43
        org.nlogo.sdm.gui.BindingConnection 2 577 410 1139 178 NULL NULL 0 0 0
            org.nlogo.sdm.gui.ChopRateConnector REF 39
            org.jhotdraw.contrib.ChopDiamondConnector REF 102
        org.nlogo.sdm.gui.BindingConnection 2 751 121 844 59 NULL NULL 0 0 0
            org.jhotdraw.contrib.ChopDiamondConnector REF 92
            org.nlogo.sdm.gui.ChopRateConnector REF 135
        org.nlogo.sdm.gui.BindingConnection 2 1155 194 1143 432 NULL NULL 0 0 0
            org.jhotdraw.contrib.ChopDiamondConnector REF 102
            org.nlogo.sdm.gui.ChopRateConnector REF 123
        org.nlogo.sdm.gui.BindingConnection 2 631 483 922 305 NULL NULL 0 0 0
            org.nlogo.sdm.gui.ChopRateConnector REF 31
            org.jhotdraw.contrib.ChopDiamondConnector REF 97
@#$#@#$#@
@#$#@#$#@
@#$#@#$#@
default
0.0
-0.2 0 0.0 1.0
0.0 1 1.0 0.0
0.2 0 0.0 1.0
link direction
true
0
Line -7500403 true 150 150 90 180
Line -7500403 true 150 150 210 180
@#$#@#$#@
0
@#$#@#$#@
