extensions [nw]

breed [users user] ;
breed [pages page] ;
undirected-link-breed  [bonds bond] ;

users-own [agentname] ;
pages-own [pagename] ;
bonds-own [edits] ;


to startup
clear-all ;
    set-default-shape users "person" ;
  set-default-shape pages "box" ;
  end


;; 
to load_data
    ifelse ( file-exists? "user_page_u.txt" )
   [

    file-open "user_page_u.txt"
        while [ not file-at-end? ]     [ visual list file-read file-read ]
    file-close
    user-message "Готово!"
     ]
   
     [ user-message "user_page_u.txt нет такого файла!" ]
     
end


to use_list   
let wikihistory [
["Ученик_1" "Страница_1"]
["Ученик_1" "Страница_2"]
["Ученик_1" "Страница_3"]
["Ученик_1" "Страница_2"]
["Ученик_1" "Страница_3"]
["Ученик_2" "Страница_3"]
["Ученик_3" "Страница_3"]
["Ученик_4" "Страница_4"]
["Ученик_5" "Страница_5"]
["Ученик_6" "Страница_6"]
["Ученик_2" "Страница_6"]
["Ученик_2" "Страница_7"]
["Ученик_2" "Страница_1"]
["Ученик_1" "Страница_1"]
["Ученик_1" "Страница_1"]
["Ученик_4" "Страница_4"]
["Ученик_4" "Страница_4"]
["Ученик_7" "Страница_8"]
["Ученик_7" "Страница_9"]
["Ученик_7" "Страница_9"]
["Ученик_7" "Страница_8"]
["Ученик_8" "Страница_9"]
["Ученик_8" "Страница_8"]

  ]
  foreach wikihistory [visual ?] ;  
end

to generate_list 
let wikihistory generate "User" "Page"  ;
  foreach wikihistory [visual ?] ;
end

to-report generate [a b]
  let glist [] ;
  repeat g_agents + g_pages [
    set glist lput list word a (1 + random g_agents)  word b (1 + random g_pages ) glist ; 
  ]
report glist
end

to visual [flist]
 let agent_name first flist ;; это мы просто считали имена агентов и страниц
 let page_name last flist
;; если у нас нет страницы и нет юзера ;
ifelse (not any? users with [agentname = agent_name]) and  (not any? pages with [pagename = page_name])
  [ 
  create-ordered-users 1 [
    set size 1.4
    set color red 
    set agentname agent_name ;
 ;   set label agentname ;
    hatch-pages 1 [ set pagename page_name set color green   create-bond-with myself ;
      ask bond  [who] of myself [who] of self [set edits 1  ]
      ] ;        
                         ]
  ]
;; Не было юзера, а страница уже была - т.е. появляется автор и его действие - редактирование существующего
[ ifelse (not any? users with [agentname = agent_name]) and  (any? pages with [pagename = page_name])
  [
  let myfirstpage [who] of one-of pages with [pagename = page_name] ;
   ask page  myfirstpage [hatch-users 1 
     [ set color red set agentname agent_name   
       ; set label agentname 
       create-bond-with myself   ;
       ask bond [who] of self myfirstpage [set edits 1 ] 
     ]
      ]
    ]
;; у нас есть юзер, но нет страницы
[ ifelse (any? users with [agentname = agent_name]) and  (not any? pages with [pagename = page_name])
  [
  let author [who] of one-of users with [agentname = agent_name] ;
   ask user author [hatch-pages 1 
     [ set color green  set pagename page_name  
        ; set label pagename  
        create-bond-with myself      
       ask bond author [who] of self  [set edits 1] 
        ] 
       ;     
      ]
    ]
;; Ситуация, когда есть и пользователь и страница - и там варианты с тем, что есть связь или нет связи
[
    let author [who] of one-of users with [agentname = agent_name] ;
      let mypage [who] of one-of pages with [pagename = page_name] ;
      ifelse is-link? bond author mypage [ask bond author mypage [set edits edits + 1 ] ]
     [ask user author [create-bond-with page mypage] ask bond author mypage [set edits 1]  ]
  ]
]] 

layout
end

to analytics
nw:set-context turtles bonds
; show map sort nw:get-context
;; ask  turtles [set label round nw:betweenness-centrality ]
 ask  turtles [set label nw:eigenvector-centrality ] ;; - только для связанной сети
;; ask  turtles [set label nw:closeness-centrality ] 
;; ask  turtles [set label nw:clustering-coefficient ] 
ask  turtles [set label nw:bicomponent-clusters ] 
;;show global-clustering-coefficient
;; show nw:weak-component-clusters
;;show nw:maximal-cliques ;; - не работает
;; show nw:biggest-maximal-cliques
end


to layout
 repeat 3 [
 ;;   layout-spring turtles links 0.18 0.01 1.2
    layout-spring turtles links 0.2 0.01 1.4  
    display
  ]

end

to show_names
  ask users [ set label agentname]
  ask pages  [set label pagename]
  ask bonds [set label edits]
  ask turtles [set label-color orange]
end

to-report global-clustering-coefficient
  let closed-triplets sum [ nw:clustering-coefficient * count my-links * (count my-links - 1) ] of turtles
  let triplets sum [ count my-links * (count my-links - 1) ] of turtles
  report closed-triplets / triplets
end
@#$#@#$#@
GRAPHICS-WINDOW
305
15
848
579
20
20
13.0
1
10
1
1
1
0
1
1
1
-20
20
-20
20
0
0
1
ticks
30.0

BUTTON
52
144
125
177
NIL
use_list
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

BUTTON
56
69
130
102
NIL
load_data
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

BUTTON
41
193
145
226
NIL
generate_list
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

BUTTON
60
17
132
50
NIL
startup
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

SLIDER
18
278
190
311
g_agents
g_agents
5
50
13
1
1
NIL
HORIZONTAL

SLIDER
18
316
190
349
g_pages
g_pages
5
80
20
1
1
NIL
HORIZONTAL

TEXTBOX
148
243
298
273
Данные создаются автоматически
10
0.0
1

TEXTBOX
132
79
282
97
Данные из истории вики
10
0.0
1

TEXTBOX
127
152
277
170
Данные из готового списка 
10
0.0
1

BUTTON
57
374
130
407
go_ban
if (file-exists? \"go_ban3.gif\" ) [import-drawing \"go_ban3.gif\" ask turtles [set label-color black]]
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

BUTTON
145
374
248
407
NIL
show_names
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

BUTTON
897
457
977
490
NIL
analytics
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

BUTTON
83
423
189
456
NIL
clear-drawing
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

BUTTON
850
50
1004
83
eigenvector-centrality
 ask  turtles [set label nw:eigenvector-centrality ] 
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

BUTTON
849
92
1011
125
betweenness-centrality
 ask  turtles [set label round nw:betweenness-centrality ]
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

BUTTON
850
130
991
163
closeness-centrality
ask  turtles [set label nw:closeness-centrality ] 
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

BUTTON
851
172
998
205
clustering-coefficient
ask  turtles [set label nw:clustering-coefficient ] 
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

BUTTON
848
214
997
247
bicomponent-clusters
show first nw:bicomponent-clusters
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

BUTTON
846
258
1019
294
weak-component-clusters
show nw:weak-component-clusters
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

@#$#@#$#@
## WHAT IS IT?
Это средство для представления историй создания и редактирования вики страниц в форме действий, которые совершают агенты NetLogo. Для представления центральности узлов используется метод layout-spring 
(a general understanding of what the model is trying to show or explain)

## HOW IT WORKS
(what rules the agents use to create the overall behavior of the model)
В системе определены следующие породы: авторы, страницы, связи. Свойства авторов - Имя_автора. Свойство страницы - Имя_Страницы
На входе модель получает историю редактирований вики в форме строк: "Имя_Автора" "Имя_Страницы" и обрабатывает значение этой пары. Правила обработки просты. Проверятся существование автора с указанным именени и страницы с указанным именем. 1) Если автора (user) и страницы (page) с такими именами еще не существуют, то создается автор (со свойством "Имя_Автора") и этот автор создает страницу (со свойством "Имя_Страницы"), и автор создает направленную связь (bond) к странице. Значение edits для данной связи устанавливается 1. 2) Если автор с таким именем уже был, а страницы еще не было, то этот автор создает страницу (со свойством "Имя_Страницы"), и автор создает направленную связь (bond) к странице. Значение edits для данной связи устанавливается 1. 3) Автора еще не было, а страница уже была. В этом случе страница создает автора и направленную связь от автора к странице. Значение edits для данной связи устанавливается 1. 4) В системе есть и автор и страница с указанным именем. 4.1. Если связи между автором и страницей еще не было то связь создается. Значение edits для данной связи устанавливается 1. 4.2. Если связь уже существовала, то значение edits для данной связи увеличивается на единицу.
После каждой обработки строки делается новое визуальное представление отношений между узлами в системе.

## HOW TO USE IT
(how to use the model, including a description of each of the items in the Interface tab)
startup - сбрасывает все данные и очищает экран
load_data - загружает и данные из файла - в дальнейшем будет развиваться именно этот вариант.
use_list- в демоверсии можно использовать заранее подготовленный список авторов и страниц.
generate_list - список авторов и страниц генерируется программой - тут просто случайные значения присваиваются участникам и страницам, но можно выбирать значение авторов и страниц, которые будут действовать в системе.

## THINGS TO NOTICE
Это продолжение обсуждения темы центральности - чем больше связанность объекта, тем более центральное положение он занимает.

## THINGS TO TRY
Можно посмотреть зависимость связанности системы от числа авторов. Но, в целом система предназначена для представления данных из реально действующей вики.

## EXTENDING THE MODEL
Доработать предварительную обработку данных на входе в модель.
Дополнить модель новыми параметрами. Например, выделить автора страницы - не просто того, кто принял участие в редактировании, но был первым создателем этой страницы.

## NETLOGO FEATURES
В модели практически не используются списки и не хранятся данные. Каждый раз проверяется группа агентов, обладающих сходными свойствами.

## RELATED MODELS
http://modelingcommons.org/browse/one_model/3401

## CREDITS AND REFERENCES

(a reference to the model's URL on the web if it has one, as well as any other necessary credits, citations, and links)
@#$#@#$#@
default
true
0
Polygon -7500403 true true 150 5 40 250 150 205 260 250

airplane
true
0
Polygon -7500403 true true 150 0 135 15 120 60 120 105 15 165 15 195 120 180 135 240 105 270 120 285 150 270 180 285 210 270 165 240 180 180 285 195 285 165 180 105 180 60 165 15

arrow
true
0
Polygon -7500403 true true 150 0 0 150 105 150 105 293 195 293 195 150 300 150

book
false
0
Polygon -7500403 true true 30 195 150 255 270 135 150 75
Polygon -7500403 true true 30 135 150 195 270 75 150 15
Polygon -7500403 true true 30 135 30 195 90 150
Polygon -1 true false 39 139 39 184 151 239 156 199
Polygon -1 true false 151 239 254 135 254 90 151 197
Line -7500403 true 150 196 150 247
Line -7500403 true 43 159 138 207
Line -7500403 true 43 174 138 222
Line -7500403 true 153 206 248 113
Line -7500403 true 153 221 248 128
Polygon -1 true false 159 52 144 67 204 97 219 82

box
false
0
Polygon -7500403 true true 150 285 285 225 285 75 150 135
Polygon -7500403 true true 150 135 15 75 150 15 285 75
Polygon -7500403 true true 15 75 15 225 150 285 150 135
Line -16777216 false 150 285 150 135
Line -16777216 false 150 135 15 75
Line -16777216 false 150 135 285 75

bug
true
0
Circle -7500403 true true 96 182 108
Circle -7500403 true true 110 127 80
Circle -7500403 true true 110 75 80
Line -7500403 true 150 100 80 30
Line -7500403 true 150 100 220 30

butterfly
true
0
Polygon -7500403 true true 150 165 209 199 225 225 225 255 195 270 165 255 150 240
Polygon -7500403 true true 150 165 89 198 75 225 75 255 105 270 135 255 150 240
Polygon -7500403 true true 139 148 100 105 55 90 25 90 10 105 10 135 25 180 40 195 85 194 139 163
Polygon -7500403 true true 162 150 200 105 245 90 275 90 290 105 290 135 275 180 260 195 215 195 162 165
Polygon -16777216 true false 150 255 135 225 120 150 135 120 150 105 165 120 180 150 165 225
Circle -16777216 true false 135 90 30
Line -16777216 false 150 105 195 60
Line -16777216 false 150 105 105 60

car
false
0
Polygon -7500403 true true 300 180 279 164 261 144 240 135 226 132 213 106 203 84 185 63 159 50 135 50 75 60 0 150 0 165 0 225 300 225 300 180
Circle -16777216 true false 180 180 90
Circle -16777216 true false 30 180 90
Polygon -16777216 true false 162 80 132 78 134 135 209 135 194 105 189 96 180 89
Circle -7500403 true true 47 195 58
Circle -7500403 true true 195 195 58

circle
false
0
Circle -7500403 true true 0 0 300

circle 2
false
0
Circle -7500403 true true 0 0 300
Circle -16777216 true false 30 30 240

cow
false
0
Polygon -7500403 true true 200 193 197 249 179 249 177 196 166 187 140 189 93 191 78 179 72 211 49 209 48 181 37 149 25 120 25 89 45 72 103 84 179 75 198 76 252 64 272 81 293 103 285 121 255 121 242 118 224 167
Polygon -7500403 true true 73 210 86 251 62 249 48 208
Polygon -7500403 true true 25 114 16 195 9 204 23 213 25 200 39 123

cylinder
false
0
Circle -7500403 true true 0 0 300

dot
false
0
Circle -7500403 true true 90 90 120

face happy
false
0
Circle -7500403 true true 8 8 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Polygon -16777216 true false 150 255 90 239 62 213 47 191 67 179 90 203 109 218 150 225 192 218 210 203 227 181 251 194 236 217 212 240

face neutral
false
0
Circle -7500403 true true 8 7 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Rectangle -16777216 true false 60 195 240 225

face sad
false
0
Circle -7500403 true true 8 8 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Polygon -16777216 true false 150 168 90 184 62 210 47 232 67 244 90 220 109 205 150 198 192 205 210 220 227 242 251 229 236 206 212 183

fish
false
0
Polygon -1 true false 44 131 21 87 15 86 0 120 15 150 0 180 13 214 20 212 45 166
Polygon -1 true false 135 195 119 235 95 218 76 210 46 204 60 165
Polygon -1 true false 75 45 83 77 71 103 86 114 166 78 135 60
Polygon -7500403 true true 30 136 151 77 226 81 280 119 292 146 292 160 287 170 270 195 195 210 151 212 30 166
Circle -16777216 true false 215 106 30

flag
false
0
Rectangle -7500403 true true 60 15 75 300
Polygon -7500403 true true 90 150 270 90 90 30
Line -7500403 true 75 135 90 135
Line -7500403 true 75 45 90 45

flower
false
0
Polygon -10899396 true false 135 120 165 165 180 210 180 240 150 300 165 300 195 240 195 195 165 135
Circle -7500403 true true 85 132 38
Circle -7500403 true true 130 147 38
Circle -7500403 true true 192 85 38
Circle -7500403 true true 85 40 38
Circle -7500403 true true 177 40 38
Circle -7500403 true true 177 132 38
Circle -7500403 true true 70 85 38
Circle -7500403 true true 130 25 38
Circle -7500403 true true 96 51 108
Circle -16777216 true false 113 68 74
Polygon -10899396 true false 189 233 219 188 249 173 279 188 234 218
Polygon -10899396 true false 180 255 150 210 105 210 75 240 135 240

house
false
0
Rectangle -7500403 true true 45 120 255 285
Rectangle -16777216 true false 120 210 180 285
Polygon -7500403 true true 15 120 150 15 285 120
Line -16777216 false 30 120 270 120

leaf
false
0
Polygon -7500403 true true 150 210 135 195 120 210 60 210 30 195 60 180 60 165 15 135 30 120 15 105 40 104 45 90 60 90 90 105 105 120 120 120 105 60 120 60 135 30 150 15 165 30 180 60 195 60 180 120 195 120 210 105 240 90 255 90 263 104 285 105 270 120 285 135 240 165 240 180 270 195 240 210 180 210 165 195
Polygon -7500403 true true 135 195 135 240 120 255 105 255 105 285 135 285 165 240 165 195

line
true
0
Line -7500403 true 150 0 150 300

line half
true
0
Line -7500403 true 150 0 150 150

pentagon
false
0
Polygon -7500403 true true 150 15 15 120 60 285 240 285 285 120

person
false
0
Circle -7500403 true true 110 5 80
Polygon -7500403 true true 105 90 120 195 90 285 105 300 135 300 150 225 165 300 195 300 210 285 180 195 195 90
Rectangle -7500403 true true 127 79 172 94
Polygon -7500403 true true 195 90 240 150 225 180 165 105
Polygon -7500403 true true 105 90 60 150 75 180 135 105

plant
false
0
Rectangle -7500403 true true 135 90 165 300
Polygon -7500403 true true 135 255 90 210 45 195 75 255 135 285
Polygon -7500403 true true 165 255 210 210 255 195 225 255 165 285
Polygon -7500403 true true 135 180 90 135 45 120 75 180 135 210
Polygon -7500403 true true 165 180 165 210 225 180 255 120 210 135
Polygon -7500403 true true 135 105 90 60 45 45 75 105 135 135
Polygon -7500403 true true 165 105 165 135 225 105 255 45 210 60
Polygon -7500403 true true 135 90 120 45 150 15 180 45 165 90

sheep
false
15
Circle -1 true true 203 65 88
Circle -1 true true 70 65 162
Circle -1 true true 150 105 120
Polygon -7500403 true false 218 120 240 165 255 165 278 120
Circle -7500403 true false 214 72 67
Rectangle -1 true true 164 223 179 298
Polygon -1 true true 45 285 30 285 30 240 15 195 45 210
Circle -1 true true 3 83 150
Rectangle -1 true true 65 221 80 296
Polygon -1 true true 195 285 210 285 210 240 240 210 195 210
Polygon -7500403 true false 276 85 285 105 302 99 294 83
Polygon -7500403 true false 219                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          