
breed [pages page] ;
breed [users user] ;
;; _____ ____ _ __ _____, __ _____ ______ ________, _______ _________ _ _____ ______
directed-link-breed [pagelinks pagelink] ;
directed-link-breed [uplinks uplink]

users-own [impact readlist researching reading writing  editing  age retirement active? status knowledge co-editors] ;
;; impact - ________, _ _______ ________ 
;; researchching - ________ ___ ____ _ _____ __ _______
;; readlist - ________ _______, _______ __ ________
;;;
;; reading - ability te read the page
;; writing - ability to create new page 
;; researching - ability to research in Things_list
;; editing 
;; age 
;; retirement
;; active?  
;; status - can be user or moderator
;; co-editors - ______ ___, _ ___ ____________

pages-own [history text_size last_edit is_about] ;
;; History - list of agents which has edit or create this page
;; text_size - ______ ________ 
;; last_edit _____ __________ ______________
;; is_about - _________ _ _______ Things

uplinks-own [edits] ;; _____ ______________

globals [Things_list] ;;

to setup
  __clear-all-and-reset-ticks
  set-default-shape users "person" 
  set-default-shape pages "circle" ;
reset-timer ;
set Things_list n-values _______ [?]
;; - _ ____ ______ _ ___ ___ 1 ________! _ ___ ____ ________ ________, ___ _______ __ _____ _______ ________
   create-users _________
  [
    set age 0
    ;; set color party_colors
    ;; set color white
     set active? true
     set status "user"
    fd 1 + random max-pycor set heading random 360
    set impact [] ;   - ________, _______ __ ____________ = _______ ______________
    set readlist [] ; - ________ ____________
    set knowledge [] ; - ________ _________
    set co-editors lput [who] of self  [] ; ______ ____________
    set reading ______ ;
     set writing Writability ;
     set editing Editability ;
     set researching  Research ;
         ]
  layout-circle users (world-width / 2 - 3) 
 end 
  



to go
  ;; ____ ___ ____ _______, __ __________ ______
;  show se length remove-duplicates  agency-to-knol  pages length Things_list
if length remove-duplicates  pages-to-knol agency-to-list  pages  = length Things_list  [stop]
;; ____ ___ ________ __ ______ _____ ____________ _ ______ _______
;; and  ( (2 * count pagelinks ) >= ( (count pages) * (count pages - 1) ) )
 
 ask users with [active? = true] [gowrite] ;
 ;;  layout-spring pages links 0.4 1 1
;; _ ________ ______, _ _______ _____ _____ ____________ ______ _____ _ ________ ______ __ ___. ___ __ _____ ____ ______ ______ __ ____ - ______ __ ____ _______
 collab_diagram ;
 ; display
 
 tick
update-plot
end



to  gowrite
;; if age > retirement [set active? false ht stop]
;; if sort knowledge = sort Things_list [stop]
 run one-of shuffle (se n-values researching  ["researh_thing"] n-values reading  ["read_page"]  n-values writing  ["write_page"] n-values  editing   ["edit_page"]    )
set age age + 1
end

;;;  One of abilities

to researh_thing
;; _________ Things_list _ _________ ______ _ knowledge
let newknol filter [not member? ? knowledge] Things_list
if empty? newknol  [stop]
set knowledge lput one-of newknol knowledge 

end

to read_page
 ;; ___ _____ _____ _________ ________?! _ ____________ _____ ______ - __ ___ ___ ________ - is_about _______ ______, ___ ______, ___ __ ______ _____
 ;; ________ __________ _ knowledge - __ ___ __ __ ___________ ______, _ ___ ____ ____ __ ____
   ;;  let unread  filter [not member? ? readlist] agency-to-list pages  ;; !! ___ _____ - ________ __ ______, _ ____
     let unknown filter [not member? [is_about] of page ? knowledge ] agency-to-list pages   ;;
     ;;
  if not empty? unknown
  [
    let readknol probablyfirst pages-by-edit-time   unknown 
    ;; _____ __ ______ ______ ___ __, ___ ___ ___ __ _____ - ____ ____ knowledge, __ __ ______
    set readlist lput readknol readlist
    set knowledge lput [is_about] of page readknol knowledge ;
    ]
  ;; !!! _ ______ ___________ ___________ _____ _ ___________ __ _____ ______-__-___
  end

 to write_page
   let my_own_preference_list (se pages-by-size agency-to-list pages with [(first history) = [who] of myself ]  reverse impact pages-by-in-links readlist )  
 ;; _________ _____ _____ ______ ____ ____ ____ ___ ___ ________! _._. _ ____ ______ ____ ______ - knowledge b 
 ;; _ ___ ______ __ ___ __ ________ _ _________
 ;; _._. ___ ______ ___________ _______ _ _______. ______ _ ___ _____, ___ _______ ___ __ _____ _______
 ;; !!!!!! --- ________ _ _____ _________ ___ _ ______ ____________
 
 let unwrited filter [not member? ? pages-to-knol readlist] knowledge ;
 if not (empty? unwrited )  
 
 [
   hatch 1 
  [  
    set breed pages 
       setxy 0 0
    ;; _ ___ ___ ________ - __ ________ __ ______ Things_list
     set is_about one-of unwrited
      set last_edit timer
      set text_size 1
      set size text_size
     ;; set label is_about
      create-uplink-from myself ;;
      ask uplink [who] of myself [who] of self [set edits 1 set label edits]
      set history lput [who] of myself [] 
      ask myself [
             set impact lput [who] of myself impact ;; _____ impact - _____ ________ _ ________ _______, _______ ____ ____________
              set readlist lput [who] of myself readlist ;
        
                 ]  

  ]
 ]
 end
 
 to edit_page 
   let my_own_preference_list []
    ;; _ 1 ________. _______ ____________ (__ _____ ________) + ___________ (__ _____ ________) 
   if PrefList = "_________________" 
[  set my_own_preference_list   (se   pages-by-size agency-to-list pages with [(first history) = [who] of myself ] impact   pages-by-size readlist )]
  ;; _ 2   _ ___ _____ ______ _______ + __, ___ ________
if PrefList = "________________" [ set my_own_preference_list   (se   pages-by-size impact   pages-by-size readlist ) ]
  ;; _3 _ ___ ______ _______ ___ _ ________ - _._. co-editors
if PrefList = "__________________" [set my_own_preference_list   (se  pages-by-edit-time  readlist  pages-by-edit-time  agency-to-list pages with [ member? (first history) [co-editors] of myself] impact   ) ]
  if not (empty? my_own_preference_list)     
   [
     let temp_page probablyfirst  my_own_preference_list 
    ask page temp_page 
            [  
           ifelse is-link? uplink [who] of myself [who] of self  [ ask uplink [who] of myself [who] of self [set edits edits + 1 set label edits]]
             [ create-uplink-from myself ask uplink [who] of myself [who] of self [set edits 1 ] ]
                                  
             set text_size text_size + 0.04
                           set size text_size    
                            set last_edit timer         
           ;;   set color [color] of myself
              set history lput [who] of myself history 
              ask myself [
                set impact lput [who] of myself impact 
                                        set co-editors  remove-duplicates se [history] of myself co-editors
                              ;;
                
                ] 
                          ]
    ]
 end
 
to collab_diagram
 ;; ask users [
 ;;  foreach impact [
 ;;   ifelse is-link? uplink who ? 
  ;;     [ask uplink who ? [set thickness  thickness  + 0.0001  ]]
  ;   [create-uplink-to page ?        ]
 ;;  ]
 ;; ]
 repeat 5 [layout-spring (turtle-set  pages users ) uplinks 1 1 0.7 ]
 
end
 
 
 
  
 ;;;; 
 ;;; REPORTERS
 ;;;;
;; Agentset converted to the list
to-report agency-to-list [agency]
 report [who] of agency
  end

;; list converted to the agentset of pages
to-report list-to-pages [list1]
  report pages with [ member? [who] of self list1]
end
;;; __ _____ __________ _________ _ ______

;;; _________ ______ _______ _ ______ ________ - is_about
to-report pages-to-knol [list1]
  report [is_about] of list-to-pages list1;
end

to-report agency-to-knol [agency]
  report [is_about] of agency
end

;;;  ____________ _______ ;;;
;; __ _______ ______ ________, __ __________ ______, __ __________ backlinks

to-report pages-by-edit-time [list1]
  report sort-by  [ [last_edit] of page ?1 > [last_edit] of page ?2] list1
end

to-report pages-by-size [list1]
  report sort-by  [ [text_size] of page ?1 > [text_size] of page ?2] list1
end

to-report pages-by-in-links [list1]
  report sort-by  [ [count my-in-links] of page ?1 > [count my-in-links] of page ?2] list1
end

to-report pages-by-out-links [list1]
  report sort-by  [ [count my-out-links] of page ?1 > [count my-in-links] of page ?2] list1
end



to-report party_colors
  report one-of [15 25 45  55 65 75 85 95 105 125 ] 
  ;; 
end

;;; ;;;;

to-report probablyfirst [list1]
if empty? bf list1 [ report first list1 ]
if random 2 > 0 [report first list1]
set list1 but-first list1
report probablyfirst list1
end
 

to-report DeadendPages
  ;; The following pages do not link to other pages
  report pages with [count my-out-links = 0] 
end

to-report LonelyPages
 ;; The following pages are not linked from or transcluded into other pages
  report pages with [count my-in-links = 0] 
end

to-report StrangePages
  ;; The following pages are not linked from or do not link to other pages
  report (turtle-set DeadendPages LonelyPages)
end
;;;;;;;
to-report SameThingPage
  ; ________, _______ __ _____ _ ___ __ ____
  report pages with [count other pages with [is_about = [is_about] of myself ] > 0] ;
end

to-report UnicalPage
  ; ________, _______ ______ __ _____ ____
  report pages with [count other pages with [is_about = [is_about] of myself ] = 0] ;
end

to-report Co-editingPage
  ;; ________, _______ _____________ _________ __________
end

;; ____, ___ _______ ___ ______ __ ________



;;;;;;;;;;;;;;;;;;;;;;;
;;;     Plotting    ;;;
;;;;;;;;;;;;;;;;;;;;;;;



to update-plot
set-current-plot "______ 1"
 ;; set-plot-y-range 0 count pages
  
 set-current-plot-pen "pages"
 plot count pages
 
 set-current-plot-pen "dublicate"
 plot  count SameThingPage

set-current-plot-pen "unic"
 plot  count UnicalPage
 
 set-current-plot-pen "_______"
 plot  length Things_list - length remove-duplicates  pages-to-knol agency-to-list  pages 
end
@#$#@#$#@
GRAPHICS-WINDOW
362
15
905
579
20
20
13.0
1
10
1
1
1
0
1
1
1
-20
20
-20
20
0
0
1
ticks
30.0

BUTTON
13
15
76
48
NIL
setup
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

BUTTON
9
51
72
84
NIL
go
T
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

SLIDER
159
190
331
223
Writability
Writability
0
10
2
1
1
NIL
HORIZONTAL

SLIDER
160
230
332
263
Editability
Editability
0
10
2
1
1
NIL
HORIZONTAL

TEXTBOX
178
106
328
124
___________
11
13.0
1

PLOT
919
19
1225
243
______ 1
NIL
NIL
0.0
10.0
0.0
10.0
true
true
"" ""
PENS
"pages" 1.0 0 -10899396 true "" ""
"dublicate" 1.0 0 -16777216 true "" ""
"unic" 1.0 0 -5298144 true "" ""
"_______" 1.0 0 -14070903 true "" ""

SLIDER
157
158
329
191
______
______
0
10
10
1
1
NIL
HORIZONTAL

SLIDER
164
18
336
51
_______
_______
5
100
50
1
1
NIL
HORIZONTAL

SLIDER
166
55
338
88
_________
_________
1
50
3
1
1
NIL
HORIZONTAL

SLIDER
157
121
329
154
Research
Research
0
10
2
1
1
NIL
HORIZONTAL

CHOOSER
143
444
332
489
PrefList
PrefList
"_________________" "________________" "__________________"
2

CHOOSER
147
375
285
420
TypeOfChoice
TypeOfChoice
"PageSize" "LastEdit"
0

@#$#@#$#@
## WHAT IS IT?

_ ____ _______ ______ _____ ________ ______ _ ____, ___ __ ________ _ __ _______ ________ _ _________. 
___ ______ __________ _______ ____________, _____ _________ _______ _____ _________ _ _____ _________ _____________ _______. _____ _______ _ _________ ________ - ____. ____ ________ _________ _ _____ _____________ _____ ___ ___________ ___________. _ ______ ______ ______ __ _____ _________, ___ __________ ____ _______ ___ _____________ _________ _________ ________. ________, _____ ___________ _______ _____ ____ __________ ______ _______ _________ __________ ____, ___ _________ _______ - _._. ________ ______ ________ _______. ________ _____ _______, _____ ________ __________ ______, ____________ _____ ________ _________.
__ _________ ___________ _ ______ ______, _______ ____ _ ____. ______ ________ ______ ______ _ ___, ___ __ ____________ _ _ _____ __________________. ___ _______ _________ ________, _ _____ ________ __ ______ _____ - ______ ___ ____________.




## HOW IT WORKS
_ ____ _______ ___________ _______, _______ _______ ______ _ __ _______ ________ _____ _________ ____ _______.

__ ______ ____ _________ ______ _____ _________ ____ __ ________:
- ___________ (_._. _______ _ ______ ____ _____	 _ _______ ______ ___ __________ ______. __________ ___ ______, ___ _____ ___ ___ __ ________ _ ___ ____ ___ __ ________ ________)
- _______ ________ - _._. ____ _____ __________ ____ ________ _ _ ______ ____ ______ ___ ______ ___ _________ ________, __ __ _____ _______ ________
- ______ - _______ ________, _________ _______ ________ _ _________, ___ ___ ___ ___ _____. __, ___ _________, __ ____ _________ __ _____ _ _________
- _____________ - _____ _______________ _ ____________ _________ _ ______ __ ________.

____ ____________ _ ________ _______ ____ _____ __ __________, __ ___ ______ _ ______________ _____ __________ _______ ______. __ ___ _____ _________ _____ _______: __ ____ ______________ _______, __ _______ _______, __ ___ ___? _ _____ ______ _____ __ _______


## HOW TO USE IT
_ ____ _______ _______ ___ ____________ _______, _______ ________ ____ ______ _ ________ _ ____ __________.
 
Setup - _______ _ __________ ___ ________
_______ - _____ ________, _______ ____________ _ ____
_________ - _____ __________, _______ _____ _________ _ _____________ ________
_______: ______, ___________, ______, _____________ - ___________ ____, ___ _____ _____ _________ ______ ___ ________. ______ ___ - ______ ______, _____ ____ ______.
______ ______ - _________ ______ ___ _________ ______ - ___ __ _____ _________________, _____ ________ ________ ___ ______________? ________, _ ______ _______ _____________ ______ ________

Button "Users" - the number of users who will be invited to the wiki after clicking "Invite users".  
Button "Expel users" - all exiting users are expelled from the wiki (virtually we ask them to die)  
"Go" button - ask users to go and use they capacities to write, edit, link, erase and mark. Some other actions will be added to the list capacities    
"NiceNetwork" button - layout-spring pages for better viewing

User abilities - list of probabilities sliders:  
- Writability - probability for user to write new page   
- Editabilty - probability to edit page  
- Eraseability - probability to erase page  
- Protectability - probability to protect page. User with protectability (administrator) can protect pages with some features. For example - if page has more than 3 in-links then protect this page because it is important

PageLimit  - how many pages users can create in the wiki - really it is not right parameter - it is impossible ask users to check how many pages are created and if it is too many please do not add another one.

All these abilities take place only when user read page or pages -  (if count pages-here > 0 ) 

## THINGS TO NOTICE
__ _____ ____ _____ ________ ________:
___ ______ _____________ ___ _______ _______ ______ - ___ ___ ________ __________ __________ ____________. ___ ________ _____ ______ _____. ____ __ _____ ______, ___ _____ __________ ______________ _ _______________ ________ ____. ______ _____ ____ ___________ _______ _____ ____.
_____ _______ _ ______ _______ ______ ______

## THINGS TO TRY

This section could give some ideas of things for the user to try to do (move sliders, switches, etc.) with the model.

## EXTENDING THE MODEL

This section could give some ideas of things to add or change in the procedures tab to make the model more complicated, detailed, accurate, etc.

## NETLOGO FEATURES

This section could point out any especially interesting or unusual features of NetLogo that the model makes use of, particularly in the Procedures tab.  It might also point out places where workarounds were needed because of missing features.

## RELATED MODELS

This section could give the names of models in the NetLogo Models Library or elsewhere which are of related interest.

## CREDITS AND REFERENCES

This section could contain a reference to the model's URL on the web if it has one, as well as any other necessary credits or references.
@#$#@#$#@
default
true
0
Polygon -7500403 true true 150 5 40 250 150 205 260 250

airplane
true
0
Polygon -7500403 true true 150 0 135 15 120 60 120 105 15 165 15 195 120 180 135 240 105 270 120 285 150 270 180 285 210 270 165 240 180 180 285 195 285 165 180 105 180 60 165 15

arrow
true
0
Polygon -7500403 true true 150 0 0 150 105 150 105 293 195 293 195 150 300 150

box
false
0
Polygon -7500403 true true 150 285 285 225 285 75 150 135
Polygon -7500403 true true 150 135 15 75 150 15 285 75
Polygon -7500403 true true 15 75 15 225 150 285 150 135
Line -16777216 false 150 285 150 135
Line -16777216 false 150 135 15 75
Line -16777216 false 150 135 285 75

bug
true
0
Circle -7500403 true true 96 182 108
Circle -7500403 true true 110 127 80
Circle -7500403 true true 110 75 80
Line -7500403 true 150 100 80 30
Line -7500403 true 150 100 220 30

butterfly
true
0
Polygon -7500403 true true 150 165 209 199 225 225 225 255 195 270 165 255 150 240
Polygon -7500403 true true 150 165 89 198 75 225 75 255 105 270 135 255 150 240
Polygon -7500403 true true 139 148 100 105 55 90 25 90 10 105 10 135 25 180 40 195 85 194 139 163
Polygon -7500403 true true 162 150 200 105 245 90 275 90 290 105 290 135 275 180 260 195 215 195 162 165
Polygon -16777216 true false 150 255 135 225 120 150 135 120 150 105 165 120 180 150 165 225
Circle -16777216 true false 135 90 30
Line -16777216 false 150 105 195 60
Line -16777216 false 150 105 105 60

car
false
0
Polygon -7500403 true true 300 180 279 164 261 144 240 135 226 132 213 106 203 84 185 63 159 50 135 50 75 60 0 150 0 165 0 225 300 225 300 180
Circle -16777216 true false 180 180 90
Circle -16777216 true false 30 180 90
Polygon -16777216 true false 162 80 132 78 134 135 209 135 194 105 189 96 180 89
Circle -7500403 true true 47 195 58
Circle -7500403 true true 195 195 58

circle
false
0
Circle -7500403 true true 0 0 300

circle 2
false
0
Circle -7500403 true true 0 0 300
Circle -16777216 true false 30 30 240

cow
false
0
Polygon -7500403 true true 200 193 197 249 179 249 177 196 166 187 140 189 93 191 78 179 72 211 49 209 48 181 37 149 25 120 25 89 45 72 103 84 179 75 198 76 252 64 272 81 293 103 285 121 255 121 242 118 224 167
Polygon -7500403 true true 73 210 86 251 62 249 48 208
Polygon -7500403 true true 25 114 16 195 9 204 23 213 25 200 39 123

cylinder
false
0
Circle -7500403 true true 0 0 300

dot
false
0
Circle -7500403 true true 90 90 120

face happy
false
0
Circle -7500403 true true 8 8 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Polygon -16777216 true false 150 255 90 239 62 213 47 191 67 179 90 203 109 218 150 225 192 218 210 203 227 181 251 194 236 217 212 240

face neutral
false
0
Circle -7500403 true true 8 7 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Rectangle -16777216 true false 60 195 240 225

face sad
false
0
Circle -7500403 true true 8 8 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Polygon -16777216 true false 150 168 90 184 62 210 47 232 67 244 90 220 109 205 150 198 192 205 210 220 227 242 251 229 236 206 212 183

fish
false
0
Polygon -1 true false 44 131 21 87 15 86 0 120 15 150 0 180 13 214 20 212 45 166
Polygon -1 true false 135 195 119 235 95 218 76 210 46 204 60 165
Polygon -1 true false 75 45 83 77 71 103 86 114 166 78 135 60
Polygon -7500403 true true 30 136 151 77 226 81 280 119 292 146 292 160 287 170 270 195 195 210 151 212 30 166
Circle -16777216 true false 215 106 30

flag
false
0
Rectangle -7500403 true true 60 15 75 300
Polygon -7500403 true true 90 150 270 90 90 30
Line -7500403 true 75 135 90 135
Line -7500403 true 75 45 90 45

flower
false
0
Polygon -10899396 true false 135 120 165 165 180 210 180 240 150 300 165 300 195 240 195 195 165 135
Circle -7500403 true true 85 132 38
Circle -7500403 true true 130 147 38
Circle -7500403 true true 192 85 38
Circle -7500403 true true 85 40 38
Circle -7500403 true true 177 40 38
Circle -7500403 true true 177 132 38
Circle -7500403 true true 70 85 38
Circle -7500403 true true 130 25 38
Circle -7500403 true true 96 51 108
Circle -16777216 true false 113 68 74
Polygon -10899396 true false 189 233 219 188 249 173 279 188 234 218
Polygon -10899396 true false 180 255 150 210 105 210 75 240 135 240

house
false
0
Rectangle -7500403 true true 45 120 255 285
Rectangle -16777216 true false 120 210 180 285
Polygon -7500403 true true 15 120 150 15 285 120
Line -16777216 false 30 120 270 120

leaf
false
0
Polygon -7500403 true true 150 210 135 195 120 210 60 210 30 195 60 180 60 165 15 135 30 120 15 105 40 104 45 90 60 90 90 105 105 120 120 120 105 60 120 60 135 30 150 15 165 30 180 60 195 60 180 120 195 120 210 105 240 90 255 90 263 104 285 105 270 120 285 135 240 165 240 180 270 195 240 210 180 210 165 195
Polygon -7500403 true true 135 195 135 240 120 255 105 255 105 285 135 285 165 240 165 195

line
true
0
Line -7500403 true 150 0 150 300

line half
true
0
Line -7500403 true 150 0 150 150

page
false
0
Rectangle -7500403 true true 75 90 90 90
Rectangle -16777216 true false 90 90 165 90
Rectangle -7500403 true true 30 15 255 270
Line -16777216 false 60 75 105 75
Line -16777216 false 135 75 210 75
Line -16777216 false 60 90 150 90
Line -16777216 false 165 90 240 90
Line -16777216 false 60 105 90 105
Line -16777216 false 120 105 210 105
Line -16777216 false 60 120 90 120
Line -16777216 false 120 120 225 120
Line -16777216 false 60 150 105 150
Line -16777216 false 60 45 105 45
Line -16777216 false 75 165 120 165
Line -16777216 false 135 165 195 165
Line -16777216 false 60 195 105 195
Line -16777216 false 135 195 195 195

pentagon
false
0
Polygon -7500403 true true 150 15 15 120 60 285 240 285 285 120

person
false
0
Circle -7500403 true true 110 5 80
Polygon -7500403 true true 105 90 120 195 90 285 105 300 135 300 150 225 165 300 195 300 210 285 180 195 195 90
Rectangle -7500403 true true 127 79 172 94
Polygon -7500403 true true 195 90 240 150 225 180 165 105
Polygon -7500403 true true 105 90 60 150 75 180 135 105

plant
false
0
Rectangle -7500403 true true 135 90 165 300
Polygon -7500403 true true 135 255 90 210 45 195 75 255 135 285
Polygon -7500403 true true 165 255 210 210 255 195 225 255 165 285
Polygon -7500403 true true 135 180 90 135 45 120 75 180 135 210
Polygon -7500403 true true 165 180 165 210 225 180 255 120 210 135
Polygon -7500403 true true 135 105 90 60 45 45 75 105 135 135
Polygon -7500403 true true 165 105 165 135 225 105 255 45 210 60
Polygon -7500403 true true 135 90 120 45 150 15 180 45 165 90

sheep
false
0
Rectangle -7500403 true true 151 225 180 285
Rectangle -7500403 true true 47 225 75 285
Rectangle -7500403 true true 15 75 210 225
Circle -7500403 true true 135 75 150
Circle -16777216 true false 165 76 116

square
false
0
Rectangle -7500403 true true 30 30 270 270

square 2
false
0
Rectangle -7500403 true true 30 30 270 270
Rectangle -16777216 true false 60 60 240 240

star
false
0
Polygon -7500403 true true 151 1 185 108 298 108 207 175 242 282 151 216 59 282 94 175 3 108 116 108

target
false
0
Circle -7500403 true true 0 0 300
Circle -16777216 true false 30 30 240
Circle -7500403 true true 60 60 180
Circle -16777216 true false 90 90 120
Circle -7500403 true true 120 120 60

tree
false
0
Circle -7500403 true true 118 3 94
Rectangle -6459832 true false 120 195 180 300
Circle -7500403 true true 65 21 108
Circle -7500403 true true 116 41 127
Circle -7500403 true true 45 90 120
Circle -7500403 true true 104 74 152

triangle
false
0
Polygon -7500403 true true 150 30 15 255 285 255

triangle 2
false
0
Polygon -7500403 true true 150 30 15 255 285 255
Polygon -16777216 true false 151 99 225 223 75 224

truck
false
0
Rectangle -7500403 true true 4 45 195 187
Polygon -7500403 true true 296 193 296 150 259 134 244 104 208 104 207 194
Rectangle -1 true false 195 60 195 105
Polygon -16777216 true false 238 112 252 141 219 141 218 112
Circle -16777216 true false 234 174 42
Rectangle -7500403 true true 181 185 214 194
Circle -16777216 true false 144 174 42
Circle -16777216 true false 24 174 42
Circle -7500403 false true 24 174 42
Circle -7500403 false true 144 174 42
Circle -7500403 false true 234 174 42

turtle
true
0
Polygon -10899396 true false 215 204 240 233 246 254 228 266 215 252 193 210
Polygon -10899396 true false 195 90 225 75 245 75 260 89 269 108 261 124 240 105 225 105 210 105
Polygon -10899396 true false 105 90 75 75 55 75 40 89 31 108 39 124 60 105 75 105 90 105
Polygon -10899396 true false 132 85 134 64 107 51 108 17 150 2 192 18 192 52 169 65 172 87
Polygon -10899396 true false 85 204 60 233 54 254 72 266 85 252 107 210
Polygon -7500403 true true 119 75 179 75 209 101 224 135 220 225 175 261 128 261 81 224 74 135 88 99

wheel
false
0
Circle -7500403 true true 3 3 294
Circle -16777216 true false 30 30 240
Line -7500403 true 150 285 150 15
Line -7500403 true 15 150 285 150
Circle -7500403 true true 120 120 60
Line -7500403 true 216 40 79 269
Line -7500403 true 40 84 269 221
Line -7500403 true 40 216 269 79
Line -7500403 true 84 40 221 269

x
false
0
Polygon -7500403 true true 270 75 225 30 30 225 75 270
Polygon -7500403 true true 30 75 75 30 270 225 225 270

@#$#@#$#@
NetLogo 5.0
@#$#@#$#@
@#$#@#$#@
@#$#@#$#@
@#$#@#$#@
@#$#@#$#@
default
0.0
-0.2 0 1.0 0.0
0.0 1 1.0 0.0
0.2 0 1.0 0.0
link direction
true
0
Line -7500403 true 150 150 90 180
Line -7500403 true 150 150 210 180

@#$#@#$#@
0
@#$#@#$#@
