; Coded in 2022 by Lin Xiang; Last revised in 2022 by Lin Xiang (lxiang75@gmail.com; lin.xiang@uky.edu)
;;
;; If you mention this model in a publication, we ask that you include the citations below.
;;
;; Xiang, L. (2022). Mutually Beneficial Interaction. Department of STEM Education, University of Kentucky, Lexington, KY.
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;


breed [legends legend]
breed [plant1s plant1]
breed [pesticides pesticide]
breed [buildings building]
breed [bees bee]

plant1s-own [visit-1 num-seed nectar]
bees-own [life erg food ]
patches-own [seeding bldg]
Globals [days num-seeds

  running-avg-list-bee running-avg-list-plant1
  mean-total-bee mean-total-plant1

  oil
  honey

]

to-report empty-patches
  report patches with [pcolor >= 62 and seeding = 0 and bldg = 0 and not any? plant1s-here]
end

to-report fresh-flowers
  report plant1s with [nectar > 0 and visit-1 < 2 and shape = "sunflower-1"]
end

to-report building-land
  report patches with [pxcor > min-pxcor and pxcor < max-pxcor and pcolor = 62 and bldg = 0]
end


to setup
  clear-all
  setup-patches
  setup-legends
  setup-plant1s
  setup-bees


  set running-avg-list-bee []
  set running-avg-list-plant1 []

  set oil 0
  set honey 0

  do-plot
  reset-ticks
end

to setup-patches
  ask patches [set pcolor 62]
  ask patches with [pycor < 2 or pycor = max-pycor or pxcor = 0 or pxcor = max-pxcor] [set pcolor white]
  ask patches with [pcolor = 62] [set seeding 0 set bldg 0]
end

to setup-bees

  set-default-shape bees "bee"

    create-bees number-of-bees
    [set color yellow
     set size 0.6
     set erg 10
     set life 0
     setxy 1 + random (world-width - 2)  2 + random (world-height - 3)
    ]


end

to setup-plant1s
  ask n-of number-of-sunflowers empty-patches
    [sprout-plant1s 1
    [set color 26
    set size 1
    set shape "sunflower-1"
    set visit-1 0
    set nectar 1
  ]]
end




;;;;;;;;;;;;;;;;;;;;;
;;   GO PROCEDURE  ;;
;;;;;;;;;;;;;;;;;;;;;


to go
; every 0.01[

 if ticks >= years: * 60 [stop]

  search
  reproduce-bees
  make-nectar
  flower-color
  plant-reproduction
  pesticides-killing
  find-running-avg-1
  ifelse days <= 9 [set days days + 1] [set days 0]
  do-plot
  tick
;]
  if mean-total-plant1 = 0 and mean-total-bee <= 0 [stop]
end

;;;;;;;;;;;;;;;;;;;;;;;;;;

to search
ask bees
  [ifelse any? fresh-flowers in-radius 2
     [let my-goal one-of fresh-flowers in-radius 2
      face my-goal
      move-to my-goal
      set erg erg + 3
      ask my-goal [set nectar 0 set visit-1 visit-1 + 1]]
     [right random 180 left random 180 if [pcolor] of patch-at dx dy = 62 [fd 1 set erg erg - 0.5 if erg <= 0 [die]]]

     ifelse life < 60 [set life life + 1][die]  ;set life-span to allow trapped bees to die out
  ]
end

to harvest-honey
  ifelse count bees > 35
  [set honey 0.1 * (sum [erg] of bees * (20 / 100))
    ask bees [set erg erg * (80 / 100)]]
  [set honey 0]
end

to reproduce-bees
  ask bees
    [if erg >= 20
      [hatch 1 [set erg 10 set life 0]
       set erg erg - 10]]
end

to plant-reproduction
  if days = 9
    [ifelse count plant1s with [visit-1 = 2] > count patches with [pcolor = 62] / 2
      [set oil (count plant1s with [visit-1 = 2] - count patches with [pcolor = 62] / 2) / 2 set num-seeds count patches with [pcolor = 62] / 2]  ;harvest sunflower oil
      [set num-seeds count plant1s with [visit-1 = 2]]

      ask up-to-n-of (2 * num-seeds) patches with [pcolor = 62 and seeding = 0]
        [set seeding 1]

        ask plant1s [die]

    ask patches with [seeding = 1]
      [if bldg = 0
          [if random 100 < 85
            [sprout-plant1s 1
             [set color 26
              set size 1
              set shape "sunflower-1"
              set visit-1 0
                set nectar 1]]]
        set seeding 0]



    harvest-honey
  ]

end

to make-nectar
  ask plant1s with [nectar = 0 and visit-1 < 2]
  [if random 100 < 15    ;produce food at a chance
    [set nectar 1]]
end

to  flower-color
  ask plant1s with [visit-1 >= 2 and shape = "sunflower-1"]
  [set color 35 set shape "sunflower"]
end


to find-running-avg-1   ;find the running average
   (ifelse
    ticks < 30
     [set running-avg-list-bee lput (count bees) running-avg-list-bee set mean-total-bee mean running-avg-list-bee
      set running-avg-list-plant1 lput (count plant1s) running-avg-list-plant1 set mean-total-plant1 mean running-avg-list-plant1
    ]

     [set running-avg-list-bee lput count bees running-avg-list-bee set running-avg-list-bee remove-item 0 running-avg-list-bee set mean-total-bee mean running-avg-list-bee
      set running-avg-list-plant1 lput count plant1s running-avg-list-plant1 set running-avg-list-plant1 remove-item 0 running-avg-list-plant1 set mean-total-plant1 mean running-avg-list-plant1
  ])

end


to deconstruction-1
if any? buildings
  [ask one-of buildings with [pycor = max [pycor] of buildings]
    [ask neighbors with [bldg = 1] [set bldg 0 set pcolor 62] set bldg 0 set pcolor 62 die]]
end


to deconstruction
if any? buildings
  [let demolishing buildings with [pycor = max [pycor] of buildings]
    ask one-of demolishing with [pxcor = max [pxcor] of demolishing]
    [ask neighbors with [bldg = 1] [set bldg 0 set pcolor 62] set bldg 0 set pcolor 62 die]]
end


to building-a-house
    if any? plant1s-here [ask plant1s-here [die]]

    sprout-buildings 1
      [set shape "house-1"
       set size 2
       set color 48
       setxy pxcor - 0.5 pycor
     ]

    set bldg 1 set pcolor 62.5

    ask neighbors with [pcolor = 62]
      [if any? plant1s-here [ask plant1s-here [die]]
          set bldg 1 set pcolor 62.5]
end

to pesticides-killing

   ifelse Bees-killed-by-insecticides > 0
    [if any? plant1s [ask n-of (1 + ((Bees-killed-by-insecticides * count plant1s / 1000))) plant1s [set shape "sunflower-11"]]]
    [if any? plant1s [ask plant1s [ifelse visit-1 < 2 [set color 26 set shape "sunflower-1"][set color 35 set shape "sunflower"]]]]

  ask bees
  [if count bees >= 100 - Bees-killed-by-insecticides
    [if random 2 = 0 [die]]]
end

to building-houses-1

ifelse not any? buildings
  [ask patches with [pxcor = 2 and pycor = 3] [building-a-house ]]
  [ifelse any? building-land with [pycor = 3]
    [ask patches with [pxcor = max [pxcor] of patches with [bldg = 1] + 2 and pycor = 3] [building-a-house]]
    [ifelse not any? buildings with [pycor = 6]
       [ask patches with [pxcor = 2 and pycor = 6] [building-a-house ]]
       [ifelse any? building-land with [pycor = 6]
          [ask patches with [pxcor = max [pxcor] of patches with [bldg = 1 and pycor = 6] + 2 and pycor = 6] [building-a-house]]
          [ifelse not any? buildings with [pycor = 9]
             [ask patches with [pxcor = 2 and pycor = 9] [building-a-house ]]
             [ifelse any? building-land with [pycor = 9]
                [ask patches with [pxcor = max [pxcor] of patches with [bldg = 1 and pycor = 9] + 2 and pycor = 9] [building-a-house]]
                 [ifelse not any? buildings with [pycor = 12]
                    [ask patches with [pxcor = 2 and pycor = 12] [building-a-house ]]
                    [ifelse any? building-land with [pycor = 12]
                      [ask patches with [pxcor = max [pxcor] of patches with [bldg = 1 and pycor = 12] + 2 and pycor = 12] [building-a-house]]
                      [ifelse not any? buildings with [pycor = 15]
                         [ask patches with [pxcor = 2 and pycor = 15] [building-a-house ]]
                         [if any? building-land with [pycor = 15]
                             [ask patches with [pxcor = max [pxcor] of patches with [bldg = 1 and pycor = 15] + 2 and pycor = 15] [building-a-house]]


  ]]]]]]]]]

end


to do-plot  ;; this creates creates the bar graph
    set-current-plot "Oil and Honey Yields"
    clear-plot
    plot-pen-down
    set-current-plot-pen "Sunflower Oil"
    plotxy 0 oil
    set-current-plot-pen "Honey"
    plotxy 1 honey
end

to setup-legends

  create-legends 10

  ask legend 0
  [set shape "sunflower-1"
    set size 1
    set color 26
    setxy 1.5 0.75]

  ask legend 1
  [set shape "bee"
    set color yellow
    set size 0.75
    setxy 3.75 0.75]


  ask legend 2
  [set shape "house-1"
    set color gray
    set size 1.25
    setxy 10.55 0.75]

  ask legend 3
  [set shape "sunflower-11"
    set color 26
    set size 1
    setxy 8 0.75]

  ask legend 4
  [set shape "blank"
    set color 136
    set size 1.5
    set label "Sunflower"
    set label-color 0
    set heading 90
    setxy 1.5 0.5]

  ask legend 5
  [set shape "blank"
    set color 136
    set size 1.5
    set label "Sprayed flower"
    set label-color 0
    set heading 75
    setxy 8.4 0.5]

  ask legend 6
  [set shape "blank"
    set color 136
    set size 1.5
    set label "Bee"
    set label-color 0
    set heading 75
    setxy 3.35 0.5]

  ask legend 7
  [set shape "blank"
    set color 136
    set size 1
    set label "Building lot"
    set label-color 0
    set heading 75
    setxy 11 0.25]

  ask legend 8
  [set shape "sunflower"
    set color 35
    set size 1
    set label ""
    set label-color 0
    set heading 75
    setxy 5.75 0.75]

  ask legend 9
  [set shape "blank"
    set color 136
    set size 1
    set label "Seeds"
    set label-color 0
    set heading 75
    setxy 5.75 0.25]
end
@#$#@#$#@
GRAPHICS-WINDOW
14
10
412
559
-1
-1
30.0
1
10
1
1
1
0
1
1
1
0
12
0
17
0
0
1
ticks
15.0

BUTTON
416
47
510
114
Start/Reset
setup
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

BUTTON
597
47
695
80
Run/Pause
go
T
1
T
OBSERVER
NIL
NIL
NIL
NIL
0

BUTTON
597
82
695
115
Run a day
go
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL
0

PLOT
415
195
740
386
Populations of Plants and Bees
Time
Running average
0.0
10.0
0.0
10.0
true
true
"" ""
PENS
"Bees" 1.0 0 -955883 true "" "(ifelse ticks > 0 [plotxy ticks  mean-total-bee] ticks = 0 [plotxy ticks count bees])"
"Sunflowers" 1.0 0 -12087248 true "" "(ifelse ticks > 0 [plotxy ticks mean-total-plant1] ticks = 0 [plotxy ticks count plant1s])"

MONITOR
415
534
490
579
Sunflowers
count plant1s
0
1
11

MONITOR
699
60
762
105
Year
ticks / 60
1
1
11

MONITOR
491
534
550
579
Bees
count bees
0
1
11

MONITOR
551
534
633
579
Building lots
count buildings
17
1
11

BUTTON
551
119
678
152
Rewild
deconstruction
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL
0

INPUTBOX
514
47
594
115
Years:
50.0
1
0
Number

PLOT
415
388
741
531
Oil and Honey Yields
NIL
Yields
0.0
2.0
0.0
30.0
true
true
"" ""
PENS
"Sunflower Oil" 0.5 1 -817084 true "" "plotxy 0 oil"
"Honey" 0.5 1 -6459832 true "" "plotxy 1 honey"

MONITOR
634
534
684
579
NIL
oil
1
1
11

MONITOR
685
534
742
579
NIL
honey
1
1
11

SLIDER
415
156
678
189
Bees-killed-by-insecticides
Bees-killed-by-insecticides
0
100
0.0
1
1
%
HORIZONTAL

BUTTON
416
118
538
151
Urbanize
building-houses-1
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL
0

SLIDER
415
10
573
43
Number-of-bees
Number-of-bees
0
50
20.0
1
1
NIL
HORIZONTAL

SLIDER
577
10
762
43
Number-of-sunflowers
Number-of-sunflowers
0
50
20.0
1
1
NIL
HORIZONTAL

@#$#@#$#@
## WHAT IS IT?

This model simulates the interaction of mutually beneficial between bees and sunflowers.

## HOW IT WORKS

### Agents:

There are two types of agents: bees and sunflowers.

### Model Rules:

1. There are 165 patches in the model. The nutrients in each patch may support and only support one sunflower plant. 

2. Bees lose energy when they move around to search for flowers and die when running out of energy.

3. Bees gain energy when they find flowers and will produce offspring when they accumulate enough energy. 

4. Bees pollinate the sunflowers, and only the pollinated flowers produce seeds.
 
5. Spraying Insecticide kills bees.

6. Urbanization reduces the area of sunflower patches.

## HOW TO USE IT

1.	Use sliders **number-of-plants** and other similar sliders to set up the number of organisms. Click **Start/Reset** to confirm the settings.

2.	Put a number in **years** to define when the model ends.

3.	Click **Run/Pause** to run or pause the model. Good for gaining an overview and a long-term result.

4.	Click **Run a year** to run the model for a hypothetical year. Good for systematically collecting data. 

5.	Use **Urbanization** and **Rewild** to change the area of sunflower patches

6.	Use **Bees-killed-by-insecticides** to define how many bees are killed by insecticides. 


## THINGS TO TRY

* What population patterns emerge when neither urbanization nor insecticides are present in the model?

* What population patterns emerge when urbanization is present in the model? 

* What population patterns emerge when insecticides are sprayed in the model? 

* How do urbanization and/or insecticide utilization affect the yields of oil and honey in the model?


## RELATED MODELS

Find more community interaction models at http://3dsciencemodeling.com


## CREDITS AND REFERENCES

Dr. Lin Xiang (lin.xiang@uky.edu) created this module at the University of Kentucky in 2022. If you mention this model in a publication, we ask that you include the citations below.

Xiang, L. (2022). Mutually Beneficial Interaction. Department of STEM Education, University of Kentucky, Lexington, KY.
@#$#@#$#@
default
true
0
Polygon -7500403 true true 150 5 40 250 150 205 260 250

airplane
true
0
Polygon -7500403 true true 150 0 135 15 120 60 120 105 15 165 15 195 120 180 135 240 105 270 120 285 150 270 180 285 210 270 165 240 180 180 285 195 285 165 180 105 180 60 165 15

arrow
true
0
Polygon -7500403 true true 150 0 0 150 105 150 105 293 195 293 195 150 300 150

arrow-1
true
0
Polygon -7500403 true true 150 0 120 90 135 75 145 303 156 301 165 75 180 90

bee
true
0
Polygon -1184463 true false 195 150 105 150 90 165 90 225 105 270 135 300 165 300 195 270 210 225 210 165 195 150
Rectangle -16777216 true false 90 165 212 185
Polygon -16777216 true false 90 207 90 226 210 226 210 207
Polygon -16777216 true false 103 266 198 266 203 246 96 246
Polygon -6459832 true false 120 150 105 135 105 75 120 60 180 60 195 75 195 135 180 150
Polygon -6459832 true false 150 15 120 30 120 60 180 60 180 30
Circle -16777216 true false 105 30 30
Circle -16777216 true false 165 30 30
Polygon -7500403 true true 120 90 75 105 15 90 30 75 120 75
Polygon -7500403 true true 180 75 180 90 225 105 285 90 270 75
Polygon -7500403 true true 180 75 180 90 195 105 240 195 270 210 285 210 285 150 255 105
Polygon -7500403 true true 120 75 45 105 15 150 15 210 30 210 60 195 105 105 120 90
Polygon -16777216 true false 135 300 165 300 180 285 120 285

beehive
false
0
Circle -7500403 true true 195 223 62
Circle -7500403 true true 43 223 62
Circle -7500403 true true 208 192 62
Circle -7500403 true true 31 189 62
Circle -7500403 true true 205 150 62
Circle -7500403 true true 33 150 62
Circle -7500403 true true 69 77 62
Circle -7500403 true true 171 78 62
Circle -7500403 true true 196 112 62
Circle -7500403 true true 44 110 62
Circle -7500403 true true 142 55 62
Circle -7500403 true true 96 55 62
Circle -7500403 true true 120 49 62
Rectangle -7500403 true true 84 99 222 282
Circle -16777216 true false 97 170 110
Polygon -1 true false 81 151 151 135 229 154 151 139
Polygon -1 true false 106 110 149 99 201 110 151 102
Polygon -1 true false 130 72 149 67 174 71 149 69

blank
false
0

box
false
0
Polygon -7500403 true true 150 285 285 225 285 75 150 135
Polygon -7500403 true true 150 135 15 75 150 15 285 75
Polygon -7500403 true true 15 75 15 225 150 285 150 135
Line -16777216 false 150 285 150 135
Line -16777216 false 150 135 15 75
Line -16777216 false 150 135 285 75

bug
true
0
Circle -7500403 true true 96 182 108
Circle -7500403 true true 110 127 80
Circle -7500403 true true 110 75 80
Line -7500403 true 150 100 80 30
Line -7500403 true 150 100 220 30

building-1
false
0
Polygon -7500403 true true 0 255 15 285 300 285 285 255 0 255
Rectangle -7500403 true true 15 75 45 255
Rectangle -7500403 true true 210 45 255 270
Rectangle -7500403 true true 60 0 105 270
Polygon -13345367 true false 180 165 180 90 210 75 210 270 180 270 180 120
Polygon -13345367 true false 105 105 105 30 135 15 135 270 105 270 105 60
Polygon -13345367 true false 30 165 30 120 60 105 60 270 30 270 30 120
Polygon -13791810 true false 60 105 120 105 120 270 60 270
Polygon -13791810 true false 135 15 195 15 195 270 135 270
Polygon -13791810 true false 210 75 270 75 270 270 210 270
Rectangle -11221820 true false 75 150 105 165
Rectangle -11221820 true false 75 180 105 195
Rectangle -11221820 true false 75 210 105 225
Rectangle -11221820 true false 75 240 105 255
Rectangle -11221820 true false 75 120 105 135
Rectangle -11221820 true false 150 210 180 270
Rectangle -11221820 true false 223 90 238 270
Circle -11221820 true false 150 195 30
Rectangle -11221820 true false 150 120 180 180
Rectangle -11221820 true false 150 45 180 105
Rectangle -11221820 true false 245 91 260 271

building-2
false
0
Rectangle -7500403 true true 195 75 225 225
Rectangle -7500403 true true 225 135 255 225
Rectangle -7500403 true true 255 120 285 225
Polygon -7500403 true true 0 210 0 240 300 240 300 210 0 210
Rectangle -7500403 true true 15 75 45 225
Rectangle -7500403 true true 60 30 105 225
Polygon -13345367 true false 135 150 135 75 165 60 165 225 135 225 135 105
Polygon -13345367 true false 75 135 75 75 105 45 105 225 75 225 75 105
Polygon -13345367 true false 45 165 45 150 60 120 60 225 30 225 45 225
Polygon -13791810 true false 60 120 90 120 90 225 60 225
Polygon -13791810 true false 105 45 150 45 150 225 105 225
Polygon -13791810 true false 165 60 210 60 210 225 165 225
Rectangle -11221820 true false 60 135 75 150
Rectangle -11221820 true false 60 195 75 210
Rectangle -11221820 true false 178 75 195 225
Rectangle -11221820 true false 120 135 135 225
Rectangle -11221820 true false 120 60 135 120
Rectangle -11221820 true false 75 165 90 180
Polygon -13345367 true false 210 165 210 165 225 150 225 225 195 225 210 225
Polygon -13791810 true false 225 150 270 150 270 225 225 225
Rectangle -11221820 true false 225 165 270 180
Rectangle -11221820 true false 225 195 270 210

building-3
false
8
Polygon -10899396 true false 0 255 15 285 300 285 285 255 0 255
Rectangle -7500403 true false 15 75 45 255
Rectangle -7500403 true false 210 45 255 270
Rectangle -7500403 true false 60 0 105 270
Polygon -11221820 true true 180 165 180 90 210 75 210 270 180 270 180 120
Polygon -11221820 true true 105 105 105 30 135 15 135 270 105 270 105 60
Polygon -11221820 true true 30 165 30 120 60 105 60 270 30 270 30 120
Polygon -11221820 true true 60 105 120 105 120 270 60 270
Polygon -11221820 true true 135 15 195 15 195 270 135 270
Polygon -11221820 true true 210 75 270 75 270 270 210 270
Rectangle -1 false false 225 90 255 120
Rectangle -1 false false 225 135 255 165
Rectangle -1 false false 225 180 255 210
Rectangle -1 false false 225 225 255 270
Circle -1 false false 150 30 30
Rectangle -1 false false 150 75 180 120
Rectangle -1 false false 150 135 180 180
Rectangle -1 false false 150 195 180 270
Rectangle -1 false false 60 120 105 135
Rectangle -1 false false 60 150 105 165
Rectangle -1 false false 60 180 105 195
Rectangle -1 false false 60 210 105 225
Rectangle -1 false false 60 240 105 255

butterfly
true
0
Polygon -7500403 true true 150 165 209 199 225 225 225 255 195 270 165 255 150 240
Polygon -7500403 true true 150 165 89 198 75 225 75 255 105 270 135 255 150 240
Polygon -7500403 true true 139 148 100 105 55 90 25 90 10 105 10 135 25 180 40 195 85 194 139 163
Polygon -7500403 true true 162 150 200 105 245 90 275 90 290 105 290 135 275 180 260 195 215 195 162 165
Polygon -16777216 true false 150 255 135 225 120 150 135 120 150 105 165 120 180 150 165 225
Circle -16777216 true false 135 90 30
Line -16777216 false 150 105 195 60
Line -16777216 false 150 105 105 60

car
false
0
Polygon -7500403 true true 300 180 279 164 261 144 240 135 226 132 213 106 203 84 185 63 159 50 135 50 75 60 0 150 0 165 0 225 300 225 300 180
Circle -16777216 true false 180 180 90
Circle -16777216 true false 30 180 90
Polygon -16777216 true false 162 80 132 78 134 135 209 135 194 105 189 96 180 89
Circle -7500403 true true 47 195 58
Circle -7500403 true true 195 195 58

circle
false
0
Circle -7500403 true true 0 0 300

circle 2
false
0
Circle -7500403 true true 0 0 300
Circle -16777216 true false 30 30 240

cow
false
0
Polygon -7500403 true true 200 193 197 249 179 249 177 196 166 187 140 189 93 191 78 179 72 211 49 209 48 181 37 149 25 120 25 89 45 72 103 84 179 75 198 76 252 64 272 81 293 103 285 121 255 121 242 118 224 167
Polygon -7500403 true true 73 210 86 251 62 249 48 208
Polygon -7500403 true true 25 114 16 195 9 204 23 213 25 200 39 123

cylinder
false
0
Circle -7500403 true true 0 0 300

dot
false
0
Circle -7500403 true true 90 90 120

face happy
false
0
Circle -7500403 true true 8 8 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Polygon -16777216 true false 150 255 90 239 62 213 47 191 67 179 90 203 109 218 150 225 192 218 210 203 227 181 251 194 236 217 212 240

face neutral
false
0
Circle -7500403 true true 8 7 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Rectangle -16777216 true false 60 195 240 225

face sad
false
0
Circle -7500403 true true 8 8 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Polygon -16777216 true false 150 168 90 184 62 210 47 232 67 244 90 220 109 205 150 198 192 205 210 220 227 242 251 229 236 206 212 183

fish
false
0
Polygon -1 true false 44 131 21 87 15 86 0 120 15 150 0 180 13 214 20 212 45 166
Polygon -1 true false 135 195 119 235 95 218 76 210 46 204 60 165
Polygon -1 true false 75 45 83 77 71 103 86 114 166 78 135 60
Polygon -7500403 true true 30 136 151 77 226 81 280 119 292 146 292 160 287 170 270 195 195 210 151 212 30 166
Circle -16777216 true false 215 106 30

flag
false
0
Rectangle -7500403 true true 60 15 75 300
Polygon -7500403 true true 90 150 270 90 90 30
Line -7500403 true 75 135 90 135
Line -7500403 true 75 45 90 45

flower
false
0
Polygon -10899396 true false 135 120 165 165 180 210 180 240 150 300 165 300 195 240 195 195 165 135
Circle -7500403 true true 85 132 38
Circle -7500403 true true 130 147 38
Circle -7500403 true true 192 85 38
Circle -7500403 true true 85 40 38
Circle -7500403 true true 177 40 38
Circle -7500403 true true 177 132 38
Circle -7500403 true true 70 85 38
Circle -7500403 true true 130 25 38
Circle -7500403 true true 96 51 108
Circle -16777216 true false 113 68 74
Polygon -10899396 true false 189 233 219 188 249 173 279 188 234 218
Polygon -10899396 true false 180 255 150 210 105 210 75 240 135 240

hex
false
0
Polygon -7500403 true true 0 150 75 30 225 30 300 150 225 270 75 270

honey
false
0
Circle -7500403 true true 210 30 30
Circle -7500403 true true 60 30 30
Rectangle -7500403 true true 75 30 225 60
Rectangle -7500403 true true 90 60 210 90
Circle -7500403 true true 135 195 0
Circle -7500403 true true 30 75 240
Circle -955883 true false 45 90 210
Rectangle -7500403 true true 90 285 210 300
Rectangle -7500403 true true 90 90 210 105
Polygon -7500403 true true 150 135 105 165 105 225 150 255 195 225 195 165
Line -16777216 false 165 165 165 225
Line -16777216 false 135 165 135 225
Line -16777216 false 135 195 165 195

house
false
0
Rectangle -7500403 true true 45 120 255 285
Rectangle -16777216 true false 120 210 180 285
Polygon -7500403 true true 15 120 150 15 285 120
Line -16777216 false 30 120 270 120

house-1
false
0
Rectangle -10899396 true false 0 150 300 300
Polygon -14835848 true false 20 141 2 122 2 101 4 82 9 70 28 63 41 61 59 60 78 71 95 94 95 112 79 138 61 144 40 142
Circle -2674135 true false 64 105 14
Polygon -7500403 true true 180 150 285 60 285 210 180 300
Polygon -11221820 true false 180 0 75 60 180 150 285 60
Polygon -13345367 true false 180 150 75 60 75 210 180 300
Polygon -11221820 true false 105 120 120 135 120 165 105 150
Polygon -11221820 true false 90 105 105 120 105 150 90 135
Polygon -11221820 true false 135 150 150 165 150 195 135 180
Polygon -11221820 true false 225 135 195 165 195 195 225 165
Polygon -11221820 true false 270 90 240 120 240 150 270 120
Polygon -11221820 true false 135 195 150 210 150 255 135 240
Polygon -11221820 true false 105 165 120 180 120 225 105 210
Polygon -11221820 true false 90 150 105 165 105 210 90 195
Polygon -6459832 true false 225 195 195 225 195 285 225 255
Polygon -11221820 true false 270 150 240 180 240 210 270 180
Polygon -6459832 true false 40 118 37 145 35 166 50 166 57 162 54 141 54 130 54 116
Polygon -6459832 true false 259 222 259 241 254 259 261 262 270 260 269 250 267 244 267 235 269 222 263 243
Polygon -14835848 true false 275 227 258 239 244 238 234 224 234 207 245 196 267 194 284 197 287 212 283 223
Circle -2674135 true false 5 95 14
Circle -2674135 true false 14 75 14
Circle -2674135 true false 37 66 14
Circle -2674135 true false 27 97 14
Circle -2674135 true false 16 117 14
Circle -2674135 true false 52 84 14

leaf
false
0
Polygon -7500403 true true 150 210 135 195 120 210 60 210 30 195 60 180 60 165 15 135 30 120 15 105 40 104 45 90 60 90 90 105 105 120 120 120 105 60 120 60 135 30 150 15 165 30 180 60 195 60 180 120 195 120 210 105 240 90 255 90 263 104 285 105 270 120 285 135 240 165 240 180 270 195 240 210 180 210 165 195
Polygon -7500403 true true 135 195 135 240 120 255 105 255 105 285 135 285 165 240 165 195

line
true
0
Line -7500403 true 150 0 150 300

line half
true
0
Line -7500403 true 150 0 150 150

oil
false
0
Polygon -7500403 true true 45 0 45 30 60 45 60 60 60 60 30 90 30 270 60 300 240 300 270 270 270 75 240 45 240 15 225 0 135 0 105 30 105 15 105 0 105 0
Rectangle -10899396 true false 45 0 105 15
Rectangle -10899396 true false 51 90 248 271
Circle -10899396 true false 226 82 23
Circle -10899396 true false 51 82 23
Circle -10899396 true false 51 255 23
Circle -10899396 true false 226 255 23
Rectangle -10899396 true false 62 269 237 277
Rectangle -10899396 true false 63 81 238 89
Polygon -1184463 true false 147 117 132 129 125 140 117 156 111 172 109 192 109 205 110 222 118 242 134 255 159 258 177 250 187 238 193 215 191 199 181 181 166 165 157 150 153 138 153 131 155 121 171 104
Polygon -1 true false 175 192 184 204 185 219 181 233 171 242 179 226 181 209
Polygon -1 true false 133 21 148 6 208 6 223 21 223 36 133 36

pentagon
false
0
Polygon -7500403 true true 150 15 15 120 60 285 240 285 285 120

person
false
0
Circle -7500403 true true 110 5 80
Polygon -7500403 true true 105 90 120 195 90 285 105 300 135 300 150 225 165 300 195 300 210 285 180 195 195 90
Rectangle -7500403 true true 127 79 172 94
Polygon -7500403 true true 195 90 240 150 225 180 165 105
Polygon -7500403 true true 105 90 60 150 75 180 135 105

pesticide
false
0
Circle -7500403 false true 23 23 255
Circle -6459832 true false 120 120 30
Polygon -6459832 true false 135 135 135 165 165 195 195 195 195 165 165 135
Polygon -6459832 true false 131 126 135 101 135 124
Polygon -6459832 true false 128 134 102 132 128 139
Polygon -6459832 true false 146 163 121 171 109 162 123 167 147 160
Polygon -6459832 true false 163 146 171 121 162 109 167 123 160 147
Polygon -6459832 true false 148 172 137 183 138 197 141 183 152 171
Polygon -6459832 true false 172 148 183 137 197 138 183 141 171 152
Polygon -6459832 true false 160 184 153 198 162 223 158 200 162 181
Polygon -6459832 true false 184 160 198 153 223 162 200 158 181 162
Line -7500403 true 240 60 60 240

plant
false
0
Rectangle -7500403 true true 135 90 165 300
Polygon -7500403 true true 135 255 90 210 45 195 75 255 135 285
Polygon -7500403 true true 165 255 210 210 255 195 225 255 165 285
Polygon -7500403 true true 135 180 90 135 45 120 75 180 135 210
Polygon -7500403 true true 165 180 165 210 225 180 255 120 210 135
Polygon -7500403 true true 135 105 90 60 45 45 75 105 135 135
Polygon -7500403 true true 165 105 165 135 225 105 255 45 210 60
Polygon -7500403 true true 135 90 120 45 150 15 180 45 165 90

seed
true
0
Polygon -7500403 true true 150 15 105 105 75 225 105 285 150 300 195 285 225 225 195 105

sheep
false
15
Circle -1 true true 203 65 88
Circle -1 true true 70 65 162
Circle -1 true true 150 105 120
Polygon -7500403 true false 218 120 240 165 255 165 278 120
Circle -7500403 true false 214 72 67
Rectangle -1 true true 164 223 179 298
Polygon -1 true true 45 285 30 285 30 240 15 195 45 210
Circle -1 true true 3 83 150
Rectangle -1 true true 65 221 80 296
Polygon -1 true true 195 285 210 285 210 240 240 210 195 210
Polygon -7500403 true false 276 85 285 105 302 99 294 83
Polygon -7500403 true false 219 85 210 105 193 99 201 83

square
false
0
Rectangle -7500403 true true 30 30 270 270

square 2
false
0
Rectangle -7500403 true true 30 30 270 270
Rectangle -16777216 true false 60 60 240 240

star
false
0
Polygon -7500403 true true 151 1 185 108 298 108 207 175 242 282 151 216 59 282 94 175 3 108 116 108

sunflower
false
0
Polygon -7500403 true true 116 183 116 193 115 207 108 216 79 237 80 220 71 226 70 214 60 217 64 185 75 173 88 166 97 168
Polygon -7500403 true true 156 110 151 97 152 86 162 76 161 61 170 54 180 45 198 67 207 81 212 90 211 102 206 114 191 117 174 117
Polygon -16777216 true false 166 100 166 90 167 76 174 67 188 63 197 61 208 53 212 68 217 78 218 98 207 110 194 117 185 115
Polygon -7500403 true true 178 195 178 205 179 219 186 228 215 249 214 232 223 238 224 226 234 229 230 197 219 185 206 178 197 180
Polygon -7500403 true true 80 146 70 146 56 147 47 154 43 168 41 177 33 188 48 192 58 197 78 198 90 187 97 174 95 165
Polygon -7500403 true true 144 190 149 203 148 214 138 224 129 230 118 239 110 251 102 233 93 219 88 210 89 198 94 186 109 183 126 183
Polygon -7500403 true true 209 142 219 142 233 143 242 150 246 164 248 173 256 184 241 188 231 193 211 194 199 183 192 170 194 161
Polygon -7500403 true true 211 162 221 162 235 161 244 151 261 142 250 132 258 120 243 116 233 111 213 110 201 121 194 134 196 143
Polygon -7500403 true true 91 142 81 142 67 143 55 143 46 149 40 156 32 164 59 188 69 193 89 194 101 183 108 170 106 161
Polygon -7500403 true true 133 101 133 91 132 77 125 68 111 64 102 62 86 59 87 71 82 79 81 99 92 111 105 118 114 116
Polygon -7500403 true true 144 110 149 97 148 86 138 76 139 61 130 54 120 45 102 67 93 81 88 90 89 102 94 114 109 117 126 117
Polygon -7500403 true true 156 190 151 203 152 214 162 224 153 243 161 249 170 258 198 233 207 219 212 210 211 198 206 186 191 183 174 183
Polygon -7500403 true true 80 154 70 154 56 153 47 146 43 132 41 123 33 112 48 108 58 103 78 102 90 113 97 126 95 135
Circle -14835848 true false 90 90 120
Polygon -16777216 true false 203 168 213 168 227 169 236 176 240 190 242 199 250 210 235 214 225 219 205 220 193 209 186 196 188 187
Polygon -7500403 true true 200 168 210 168 224 169 233 176 237 190 239 199 247 210 232 214 222 219 202 220 190 209 183 196 185 187
Polygon -16777216 true false 142 93 142 83 141 69 134 60 120 56 111 54 100 46 96 61 91 71 90 91 101 103 114 110 123 108
Polygon -7500403 true true 144 93 144 83 143 69 136 60 122 56 113 54 102 46 98 61 93 71 92 91 103 103 116 110 125 108
Polygon -16777216 true false 125 97 120 84 121 73 131 63 140 57 151 48 159 36 167 54 176 68 181 77 180 89 175 101 160 104 143 104
Polygon -7500403 true true 126 97 121 84 122 73 132 63 141 57 152 48 160 36 168 54 177 68 182 77 181 89 176 101 161 104 144 104
Polygon -16777216 true false 97 129 87 129 73 128 64 121 60 107 58 98 50 87 65 83 75 78 95 77 107 88 114 101 112 110
Polygon -7500403 true true 96 130 86 130 72 129 63 122 59 108 57 99 49 88 64 84 74 79 94 78 106 89 113 102 111 111
Polygon -16777216 true false 203 125 216 120 227 121 237 131 251 135 242 153 264 159 246 167 232 176 223 181 211 180 199 175 196 160 196 143
Polygon -7500403 true true 201 125 214 120 225 121 241 124 250 137 240 154 262 159 244 167 230 176 221 181 209 180 197 175 194 160 194 143
Polygon -16777216 true false 159 207 159 217 160 231 167 240 181 244 190 246 201 254 205 239 210 229 211 209 200 197 187 190 178 192
Polygon -7500403 true true 157 208 157 218 158 232 165 241 179 245 188 247 199 255 203 240 208 230 209 210 198 198 185 191 176 193
Polygon -16777216 true false 175 203 180 216 179 227 169 237 160 243 149 252 141 264 133 246 124 232 119 223 120 211 125 199 140 196 157 196
Polygon -7500403 true true 173 203 178 216 177 227 167 237 158 243 147 252 139 264 131 246 122 232 117 223 118 211 123 199 138 196 155 196
Polygon -16777216 true false 133 199 133 209 132 223 125 232 111 236 102 238 91 246 87 231 82 221 81 201 92 189 105 182 114 184
Polygon -7500403 true true 132 198 132 208 131 222 124 231 110 235 101 237 90 245 86 230 81 220 80 200 91 188 104 181 113 183
Polygon -16777216 true false 96 162 86 162 72 163 63 170 59 184 57 193 49 204 64 208 74 213 94 214 106 203 113 190 111 181
Polygon -7500403 true true 95 161 85 161 71 162 62 169 58 183 56 192 48 203 63 207 73 212 93 213 105 202 112 189 110 180
Polygon -16777216 true false 97 175 84 180 73 179 63 169 57 160 48 149 36 141 54 133 68 124 77 119 89 120 101 125 104 140 104 157
Polygon -7500403 true true 94 175 81 180 70 179 60 169 54 160 45 149 33 141 51 133 65 124 74 119 86 120 98 125 101 140 101 157
Polygon -16777216 true false 103 120 84 104 101 114
Polygon -16777216 true false 197 180 216 196 199 186
Polygon -16777216 true false 120 197 104 216 114 199
Polygon -16777216 true false 61 146 81 144 94 155 80 148
Polygon -16777216 true false 156 67 148 80 145 94 151 81
Polygon -16777216 true false 144 233 152 220 155 206 149 219
Polygon -16777216 true false 233 156 220 148 206 145 219 151
Polygon -16777216 true false 100 176 90 190 71 194 87 188
Polygon -16777216 true false 112 76 124 103 118 83
Polygon -16777216 true false 188 224 176 197 182 217
Circle -5825686 true false 110 110 80
Circle -16777216 true false 136 136 28
Circle -16777216 true false 162 159 8
Circle -16777216 true false 160 132 8
Circle -16777216 true false 135 128 8
Circle -16777216 true false 127 152 8
Circle -16777216 true false 149 166 8
Circle -16777216 true false 166 146 8
Circle -16777216 true false 148 126 8
Circle -16777216 true false 127 139 8
Circle -16777216 true false 118 146 8
Circle -16777216 true false 160 170 8
Circle -16777216 true false 171 136 8
Circle -16777216 true false 140 117 8
Circle -16777216 true false 123 128 8
Circle -16777216 true false 135 163 8
Circle -16777216 true false 173 156 8
Circle -16777216 true false 159 121 8
Circle -16777216 true false 152 111 8
Circle -16777216 true false 113 135 8
Circle -16777216 true false 141 173 8
Circle -16777216 true false 180 145 8
Circle -16777216 true false 171 124 8
Circle -16777216 true false 127 116 8
Circle -16777216 true false 124 164 8
Circle -16777216 true false 165 180 8
Circle -16777216 true false 171 168 8
Circle -16777216 true false 165 109 8
Circle -16777216 true false 113 120 8
Circle -16777216 true false 128 174 8
Circle -16777216 true false 152 178 8
Circle -16777216 true false 183 130 8
Circle -16777216 true false 137 106 8
Circle -16777216 true false 114 157 8
Circle -16777216 true false 183 160 8
Circle -16777216 true false 139 184 8
Circle -16777216 true false 115 170 8
Circle -16777216 true false 106 146 8
Polygon -7500403 true true 167 101 167 91 168 77 175 68 189 64 198 62 209 54 213 69 214 77 225 75 208 111 195 118 186 116
Polygon -16777216 true false 178 107 194 88 184 105
Polygon -16777216 true false 204 138 214 138 228 137 237 130 241 116 243 107 251 96 236 92 226 87 206 86 194 97 187 110 189 119
Polygon -7500403 true true 203 139 213 139 227 138 236 131 240 117 242 108 250 97 235 93 235 83 205 87 193 98 186 111 188 120
Polygon -16777216 true false 191 128 201 114 220 110 204 116

sunflower-0
false
0
Polygon -7500403 true true 116 183 116 193 115 207 108 216 79 237 80 220 71 226 70 214 60 217 64 185 75 173 88 166 97 168
Polygon -7500403 true true 156 110 151 97 152 86 162 76 161 61 170 54 180 45 198 67 207 81 212 90 211 102 206 114 191 117 174 117
Polygon -16777216 true false 166 100 166 90 167 76 174 67 188 63 197 61 208 53 212 68 217 78 218 98 207 110 194 117 185 115
Polygon -7500403 true true 178 195 178 205 179 219 186 228 215 249 214 232 223 238 224 226 234 229 230 197 219 185 206 178 197 180
Polygon -7500403 true true 80 146 70 146 56 147 47 154 43 168 41 177 33 188 48 192 58 197 78 198 90 187 97 174 95 165
Polygon -7500403 true true 144 190 149 203 148 214 138 224 129 230 118 239 110 251 102 233 93 219 88 210 89 198 94 186 109 183 126 183
Polygon -7500403 true true 209 142 219 142 233 143 242 150 246 164 248 173 256 184 241 188 231 193 211 194 199 183 192 170 194 161
Polygon -7500403 true true 211 162 221 162 235 161 244 151 261 142 250 132 258 120 243 116 233 111 213 110 201 121 194 134 196 143
Polygon -7500403 true true 91 142 81 142 67 143 55 143 46 149 40 156 32 164 59 188 69 193 89 194 101 183 108 170 106 161
Polygon -7500403 true true 133 101 133 91 132 77 125 68 111 64 102 62 86 59 87 71 82 79 81 99 92 111 105 118 114 116
Polygon -7500403 true true 144 110 149 97 148 86 138 76 139 61 130 54 120 45 102 67 93 81 88 90 89 102 94 114 109 117 126 117
Polygon -7500403 true true 156 190 151 203 152 214 162 224 153 243 161 249 170 258 198 233 207 219 212 210 211 198 206 186 191 183 174 183
Polygon -7500403 true true 80 154 70 154 56 153 47 146 43 132 41 123 33 112 48 108 58 103 78 102 90 113 97 126 95 135
Circle -14835848 true false 90 90 120
Polygon -16777216 true false 203 168 213 168 227 169 236 176 240 190 242 199 250 210 235 214 225 219 205 220 193 209 186 196 188 187
Polygon -7500403 true true 200 168 210 168 224 169 233 176 237 190 239 199 247 210 232 214 222 219 202 220 190 209 183 196 185 187
Polygon -16777216 true false 142 93 142 83 141 69 134 60 120 56 111 54 100 46 96 61 91 71 90 91 101 103 114 110 123 108
Polygon -7500403 true true 144 93 144 83 143 69 136 60 122 56 113 54 102 46 98 61 93 71 92 91 103 103 116 110 125 108
Polygon -16777216 true false 125 97 120 84 121 73 131 63 140 57 151 48 159 36 167 54 176 68 181 77 180 89 175 101 160 104 143 104
Polygon -7500403 true true 126 97 121 84 122 73 132 63 141 57 152 48 160 36 168 54 177 68 182 77 181 89 176 101 161 104 144 104
Polygon -16777216 true false 97 129 87 129 73 128 64 121 60 107 58 98 50 87 65 83 75 78 95 77 107 88 114 101 112 110
Polygon -7500403 true true 96 130 86 130 72 129 63 122 59 108 57 99 49 88 64 84 74 79 94 78 106 89 113 102 111 111
Polygon -16777216 true false 203 125 216 120 227 121 237 131 251 135 242 153 264 159 246 167 232 176 223 181 211 180 199 175 196 160 196 143
Polygon -7500403 true true 201 125 214 120 225 121 241 124 250 137 240 154 262 159 244 167 230 176 221 181 209 180 197 175 194 160 194 143
Polygon -16777216 true false 159 207 159 217 160 231 167 240 181 244 190 246 201 254 205 239 210 229 211 209 200 197 187 190 178 192
Polygon -7500403 true true 157 208 157 218 158 232 165 241 179 245 188 247 199 255 203 240 208 230 209 210 198 198 185 191 176 193
Polygon -16777216 true false 175 203 180 216 179 227 169 237 160 243 149 252 141 264 133 246 124 232 119 223 120 211 125 199 140 196 157 196
Polygon -7500403 true true 173 203 178 216 177 227 167 237 158 243 147 252 139 264 131 246 122 232 117 223 118 211 123 199 138 196 155 196
Polygon -16777216 true false 133 199 133 209 132 223 125 232 111 236 102 238 91 246 87 231 82 221 81 201 92 189 105 182 114 184
Polygon -7500403 true true 132 198 132 208 131 222 124 231 110 235 101 237 90 245 86 230 81 220 80 200 91 188 104 181 113 183
Polygon -16777216 true false 96 162 86 162 72 163 63 170 59 184 57 193 49 204 64 208 74 213 94 214 106 203 113 190 111 181
Polygon -7500403 true true 95 161 85 161 71 162 62 169 58 183 56 192 48 203 63 207 73 212 93 213 105 202 112 189 110 180
Polygon -16777216 true false 97 175 84 180 73 179 63 169 57 160 48 149 36 141 54 133 68 124 77 119 89 120 101 125 104 140 104 157
Polygon -7500403 true true 94 175 81 180 70 179 60 169 54 160 45 149 33 141 51 133 65 124 74 119 86 120 98 125 101 140 101 157
Polygon -16777216 true false 103 120 84 104 101 114
Polygon -16777216 true false 197 180 216 196 199 186
Polygon -16777216 true false 120 197 104 216 114 199
Polygon -16777216 true false 61 146 81 144 94 155 80 148
Polygon -16777216 true false 156 67 148 80 145 94 151 81
Polygon -16777216 true false 144 233 152 220 155 206 149 219
Polygon -16777216 true false 233 156 220 148 206 145 219 151
Polygon -16777216 true false 100 176 90 190 71 194 87 188
Polygon -16777216 true false 112 76 124 103 118 83
Polygon -16777216 true false 188 224 176 197 182 217
Circle -1184463 true false 110 110 80
Circle -10899396 true false 120 120 60
Polygon -7500403 true true 167 101 167 91 168 77 175 68 189 64 198 62 209 54 213 69 214 77 225 75 208 111 195 118 186 116
Polygon -16777216 true false 178 107 194 88 184 105
Polygon -16777216 true false 204 138 214 138 228 137 237 130 241 116 243 107 251 96 236 92 226 87 206 86 194 97 187 110 189 119
Polygon -7500403 true true 203 139 213 139 227 138 236 131 240 117 242 108 250 97 235 93 235 83 205 87 193 98 186 111 188 120
Polygon -16777216 true false 191 128 201 114 220 110 204 116

sunflower-1
true
0
Circle -14835848 true false 75 75 150
Polygon -16777216 true false -1 148 23 165 49 170 70 165 105 150 72 133 50 126 21 132
Polygon -16777216 true false 152 -1 135 23 130 49 135 70 150 105 167 72 174 50 168 21
Polygon -16777216 true false 152 301 135 277 130 251 135 230 150 195 167 228 174 250 168 279
Polygon -16777216 true false 301 148 277 165 251 170 230 165 196 150 228 133 250 126 279 132
Polygon -16777216 true false 14 210 39 212 62 210 87 193 107 165 75 163 44 169 23 188
Polygon -16777216 true false 90 14 88 39 91 60 110 87 136 106 137 75 131 44 112 23
Polygon -16777216 true false 210 14 212 39 209 60 190 89 166 106 163 75 169 44 188 23
Polygon -16777216 true false 210 286 212 261 209 240 189 214 165 195 163 225 169 256 188 277
Polygon -16777216 true false 91 283 89 258 92 237 112 211 136 195 138 222 132 253 113 274
Polygon -16777216 true false 286 210 261 212 240 209 214 189 196 166 225 163 256 169 277 188
Polygon -16777216 true false 284 89 259 87 238 90 212 110 195 135 223 136 254 130 275 111
Polygon -16777216 true false 14 90 39 88 60 91 87 108 106 135 75 137 44 131 23 112
Polygon -16777216 true false 45 255 48 229 59 209 80 187 123 180 110 217 92 241 70 254
Polygon -16777216 true false 45 45 48 71 59 91 80 113 122 122 110 83 92 59 70 46
Polygon -16777216 true false 255 45 252 71 241 91 220 113 182 120 190 83 208 59 230 46
Polygon -16777216 true false 255 255 252 229 241 209 220 187 180 180 190 217 208 241 230 254
Circle -1184463 true false 113 113 74
Circle -10899396 true false 120 120 60
Polygon -7500403 true true 152 -1 135 23 130 49 135 70 150 102 167 72 174 50 168 21
Polygon -7500403 true true 205 13 212 39 209 60 190 89 166 104 163 75 169 44 188 23
Polygon -7500403 true true 255 45 252 71 241 91 220 113 183 118 190 83 208 59 230 46
Polygon -7500403 true true 284 89 259 87 238 90 212 110 199 133 223 136 254 130 275 111
Polygon -7500403 true true 300 150 277 165 251 170 230 165 199 151 228 133 250 126 279 132
Polygon -7500403 true true 286 210 261 212 240 209 214 189 199 167 225 163 256 169 277 188
Polygon -7500403 true true 255 255 252 229 241 209 220 187 182 179 190 217 208 241 230 254
Polygon -7500403 true true 210 283 212 261 209 240 189 214 166 196 163 225 169 256 188 277
Polygon -7500403 true true 152 301 135 277 130 251 135 230 150 199 167 228 174 250 168 279
Polygon -7500403 true true 91 283 89 258 92 237 112 211 136 198 138 222 132 253 113 274
Polygon -7500403 true true 48 261 48 229 59 209 80 187 121 182 110 217 92 241 70 254
Polygon -7500403 true true 16 209 39 212 62 210 87 193 104 166 75 163 44 169 23 188
Polygon -7500403 true true -1 148 23 165 49 170 70 165 103 151 72 133 50 126 21 132
Polygon -7500403 true true 14 90 39 88 60 91 87 108 104 136 75 137 44 131 23 112
Polygon -7500403 true true 45 46 48 71 59 91 80 113 120 121 110 83 92 59 70 46
Polygon -7500403 true true 90 15 88 39 91 60 110 87 135 104 137 75 131 44 112 23
Polygon -16777216 true false 107 193 78 219 61 240
Polygon -16777216 true false 107 107 81 78 60 61
Polygon -16777216 true false 193 107 222 81 239 60
Polygon -16777216 true false 193 193 219 222 240 239
Polygon -16777216 true false 220 177 236 181 267 199
Polygon -16777216 true false 72 182 52 195 33 199
Polygon -16777216 true false 123 80 105 50 101 33
Polygon -16777216 true false 220 123 245 114 267 101
Polygon -16777216 true false 177 220 188 233 199 267
Polygon -16777216 true false 123 220 112 233 101 267
Polygon -16777216 true false 80 123 67 112 33 101
Polygon -16777216 true false 177 80 188 67 199 33
Polygon -16777216 true false 151 84 155 36 152 17
Polygon -16777216 true false 84 149 74 152 17 148
Polygon -16777216 true false 216 149 229 147 283 148
Polygon -16777216 true false 151 216 155 264 152 283

sunflower-11
false
0
Circle -14835848 true false 75 75 150
Polygon -16777216 true false -1 148 23 165 49 170 70 165 105 150 72 133 50 126 21 132
Polygon -16777216 true false 152 -1 135 23 130 49 135 70 150 105 167 72 174 50 168 21
Polygon -16777216 true false 152 301 135 277 130 251 135 230 150 195 167 228 174 250 168 279
Polygon -16777216 true false 301 148 277 165 251 170 230 165 196 150 228 133 250 126 279 132
Polygon -16777216 true false 14 210 39 212 62 210 87 193 107 165 75 163 44 169 23 188
Polygon -16777216 true false 90 14 88 39 91 60 110 87 136 106 137 75 131 44 112 23
Polygon -16777216 true false 210 14 212 39 209 60 190 89 166 106 163 75 169 44 188 23
Polygon -16777216 true false 210 286 212 261 209 240 189 214 165 195 163 225 169 256 188 277
Polygon -16777216 true false 91 283 89 258 92 237 112 211 136 195 138 222 132 253 113 274
Polygon -16777216 true false 286 210 261 212 240 209 214 189 196 166 225 163 256 169 277 188
Polygon -16777216 true false 284 89 259 87 238 90 212 110 195 135 223 136 254 130 275 111
Polygon -16777216 true false 14 90 39 88 60 91 87 108 106 135 75 137 44 131 23 112
Polygon -16777216 true false 45 255 48 229 59 209 80 187 123 180 110 217 92 241 70 254
Polygon -16777216 true false 45 45 48 71 59 91 80 113 122 122 110 83 92 59 70 46
Polygon -16777216 true false 255 45 252 71 241 91 220 113 182 120 190 83 208 59 230 46
Polygon -16777216 true false 255 255 252 229 241 209 220 187 180 180 190 217 208 241 230 254
Circle -1184463 true false 113 113 74
Circle -10899396 true false 120 120 60
Polygon -7500403 true true 152 -1 135 23 130 49 135 70 150 102 167 72 174 50 168 21
Polygon -7500403 true true 205 13 212 39 209 60 190 89 166 104 163 75 169 44 188 23
Polygon -7500403 true true 255 45 252 71 241 91 220 113 183 118 190 83 208 59 230 46
Polygon -7500403 true true 284 89 259 87 238 90 212 110 199 133 223 136 254 130 275 111
Polygon -7500403 true true 300 150 277 165 251 170 230 165 199 151 228 133 250 126 279 132
Polygon -7500403 true true 286 210 261 212 240 209 214 189 199 167 225 163 256 169 277 188
Polygon -7500403 true true 255 255 252 229 241 209 220 187 182 179 190 217 208 241 230 254
Polygon -7500403 true true 210 283 212 261 209 240 189 214 166 196 163 225 169 256 188 277
Polygon -7500403 true true 152 301 135 277 130 251 135 230 150 199 167 228 174 250 168 279
Polygon -7500403 true true 91 283 89 258 92 237 112 211 136 198 138 222 132 253 113 274
Polygon -7500403 true true 48 261 48 229 59 209 80 187 121 182 110 217 92 241 70 254
Polygon -7500403 true true 16 209 39 212 62 210 87 193 104 166 75 163 44 169 23 188
Polygon -7500403 true true -1 148 23 165 49 170 70 165 103 151 72 133 50 126 21 132
Polygon -7500403 true true 14 90 39 88 60 91 87 108 104 136 75 137 44 131 23 112
Polygon -7500403 true true 45 46 48 71 59 91 80 113 120 121 110 83 92 59 70 46
Polygon -7500403 true true 90 15 88 39 91 60 110 87 135 104 137 75 131 44 112 23
Polygon -16777216 true false 107 193 78 219 61 240
Polygon -16777216 true false 107 107 81 78 60 61
Polygon -16777216 true false 193 107 222 81 239 60
Polygon -16777216 true false 193 193 219 222 240 239
Polygon -16777216 true false 220 177 236 181 267 199
Polygon -16777216 true false 72 182 52 195 33 199
Polygon -16777216 true false 123 80 105 50 101 33
Polygon -16777216 true false 220 123 245 114 267 101
Polygon -16777216 true false 177 220 188 233 199 267
Polygon -16777216 true false 123 220 112 233 101 267
Polygon -16777216 true false 80 123 67 112 33 101
Polygon -16777216 true false 177 80 188 67 199 33
Polygon -16777216 true false 151 84 155 36 152 17
Polygon -16777216 true false 84 149 74 152 17 148
Polygon -16777216 true false 216 149 229 147 283 148
Polygon -16777216 true false 151 216 155 264 152 283
Circle -1 false false 63 63 175
Line -1 false 210 90 90 210

sunflower-2
true
0
Circle -14835848 true false 75 75 150
Polygon -16777216 true false -1 148 23 165 49 170 70 165 105 150 72 133 50 126 21 132
Polygon -16777216 true false 152 -1 135 23 130 49 135 70 150 105 167 72 174 50 168 21
Polygon -16777216 true false 152 301 135 277 130 251 135 230 150 195 167 228 174 250 168 279
Polygon -16777216 true false 301 148 277 165 251 170 230 165 196 150 228 133 250 126 279 132
Polygon -16777216 true false 14 210 39 212 62 210 87 193 107 165 75 163 44 169 23 188
Polygon -16777216 true false 90 14 88 39 91 60 110 87 136 106 137 75 131 44 112 23
Polygon -16777216 true false 210 14 212 39 209 60 190 89 166 106 163 75 169 44 188 23
Polygon -16777216 true false 210 286 212 261 209 240 189 214 165 195 163 225 169 256 188 277
Polygon -16777216 true false 91 283 89 258 92 237 112 211 136 195 138 222 132 253 113 274
Polygon -16777216 true false 286 210 261 212 240 209 214 189 196 166 225 163 256 169 277 188
Polygon -16777216 true false 284 89 259 87 238 90 212 110 195 135 223 136 254 130 275 111
Polygon -16777216 true false 14 90 39 88 60 91 87 108 106 135 75 137 44 131 23 112
Polygon -16777216 true false 45 255 48 229 59 209 80 187 123 180 110 217 92 241 70 254
Polygon -16777216 true false 45 45 48 71 59 91 80 113 122 122 110 83 92 59 70 46
Polygon -16777216 true false 255 45 252 71 241 91 220 113 182 120 190 83 208 59 230 46
Polygon -16777216 true false 255 255 252 229 241 209 220 187 180 180 190 217 208 241 230 254
Circle -5825686 true false 94 94 112
Circle -16777216 true false 141 140 18
Polygon -7500403 true true 152 -1 135 23 130 49 135 70 150 102 167 72 174 50 168 21
Polygon -7500403 true true 205 13 212 39 209 60 190 89 166 104 163 75 169 44 188 23
Polygon -7500403 true true 255 45 252 71 241 91 220 113 183 118 190 83 208 59 230 46
Polygon -7500403 true true 284 89 259 87 238 90 212 110 199 133 223 136 254 130 275 111
Polygon -7500403 true true 300 150 277 165 251 170 230 165 199 151 228 133 250 126 279 132
Polygon -7500403 true true 286 210 261 212 240 209 214 189 199 167 225 163 256 169 277 188
Polygon -7500403 true true 255 255 252 229 241 209 220 187 182 179 190 217 208 241 230 254
Polygon -7500403 true true 210 283 212 261 209 240 189 214 166 196 163 225 169 256 188 277
Polygon -7500403 true true 152 301 135 277 130 251 135 230 150 199 167 228 174 250 168 279
Polygon -7500403 true true 91 283 89 258 92 237 112 211 136 198 138 222 132 253 113 274
Polygon -7500403 true true 48 261 48 229 59 209 80 187 121 182 110 217 92 241 70 254
Polygon -7500403 true true 16 209 39 212 62 210 87 193 104 166 75 163 44 169 23 188
Polygon -7500403 true true -1 148 23 165 49 170 70 165 103 151 72 133 50 126 21 132
Polygon -7500403 true true 14 90 39 88 60 91 87 108 104 136 75 137 44 131 23 112
Polygon -7500403 true true 45 46 48 71 59 91 80 113 120 121 110 83 92 59 70 46
Polygon -7500403 true true 90 15 88 39 91 60 110 87 135 104 137 75 131 44 112 23
Polygon -16777216 true false 107 193 78 219 61 240
Polygon -16777216 true false 107 107 81 78 60 61
Polygon -16777216 true false 193 107 222 81 239 60
Polygon -16777216 true false 193 193 219 222 240 239
Polygon -16777216 true false 220 177 236 181 267 199
Polygon -16777216 true false 72 182 52 195 33 199
Polygon -16777216 true false 123 80 105 50 101 33
Polygon -16777216 true false 220 123 245 114 267 101
Polygon -16777216 true false 177 220 188 233 199 267
Polygon -16777216 true false 123 220 112 233 101 267
Polygon -16777216 true false 80 123 67 112 33 101
Polygon -16777216 true false 177 80 188 67 199 33
Polygon -16777216 true false 151 84 155 36 152 17
Polygon -16777216 true false 84 149 74 152 17 148
Polygon -16777216 true false 216 149 229 147 283 148
Polygon -16777216 true false 151 216 155 264 152 283
Circle -16777216 true false 129 139 10
Circle -16777216 true false 161 139 10
Circle -16777216 true false 151 161 10
Circle -16777216 true false 129 151 10
Circle -16777216 true false 139 129 10
Circle -16777216 true false 151 129 10
Circle -16777216 true false 161 151 10
Circle -16777216 true false 139 161 10
Circle -16777216 true false 173 145 10
Circle -16777216 true false 145 117 10
Circle -16777216 true false 126 126 10
Circle -16777216 true false 145 173 10
Circle -16777216 true false 117 145 10
Circle -16777216 true false 164 126 10
Circle -16777216 true false 164 164 10
Circle -16777216 true false 126 164 10
Circle -16777216 true false 158 113 10
Circle -16777216 true false 132 113 10
Circle -16777216 true false 177 132 10
Circle -16777216 true false 158 177 10
Circle -16777216 true false 113 158 10
Circle -16777216 true false 177 158 10
Circle -16777216 true false 132 177 10
Circle -16777216 true false 113 132 10
Circle -16777216 true false 174 117 10
Circle -16777216 true false 174 117 10
Circle -16777216 true false 173 174 10
Circle -16777216 true false 116 173 10
Circle -16777216 true false 117 116 10
Circle -16777216 true false 104 146 10
Circle -16777216 true false 144 104 10
Circle -16777216 true false 186 144 10
Circle -16777216 true false 146 186 10
Circle -16777216 true false 192 128 10
Circle -16777216 true false 98 128 10
Circle -16777216 true false 162 98 10
Circle -16777216 true false 192 162 10
Circle -16777216 true false 128 192 10
Circle -16777216 true false 162 192 10
Circle -16777216 true false 98 162 10
Circle -16777216 true false 128 98 10
Circle -16777216 true false 176 104 10
Circle -16777216 true false 114 186 10
Circle -16777216 true false 104 114 10
Circle -16777216 true false 91 145 10
Circle -16777216 true false 186 176 10
Circle -16777216 true false 104 176 10
Circle -16777216 true false 114 104 10
Circle -16777216 true false 186 114 10
Circle -16777216 true false 176 186 10
Circle -16777216 true false 145 91 10
Circle -16777216 true false 199 145 10
Circle -16777216 true false 145 199 10

sunflower-3
true
0
Circle -14835848 true false 90 90 120
Polygon -16777216 true false 203 168 213 168 227 169 236 176 240 190 242 199 250 210 235 214 225 219 205 220 193 209 186 196 188 187
Polygon -7500403 true true 200 168 210 168 224 169 233 176 237 190 239 199 247 210 232 214 222 219 202 220 190 209 183 196 188 179
Polygon -16777216 true false 142 93 142 83 141 69 134 60 120 56 111 54 100 46 96 61 91 71 90 91 101 103 114 110 123 108
Polygon -7500403 true true 144 93 144 83 143 69 136 60 122 56 113 54 102 46 98 61 93 71 92 91 103 103 116 110 127 110
Polygon -16777216 true false 125 97 120 84 121 73 131 63 140 57 151 48 159 36 167 54 176 68 181 77 180 89 175 101 160 104 143 104
Polygon -7500403 true true 126 97 121 84 122 73 132 63 141 57 152 48 160 36 168 54 177 68 182 77 181 89 176 101 159 107 144 104
Polygon -16777216 true false 97 129 87 129 73 128 64 121 60 107 58 98 50 87 65 83 75 78 95 77 107 88 114 101 112 110
Polygon -7500403 true true 107 123 86 130 72 129 63 122 59 108 57 99 49 88 64 84 74 79 94 78 106 89 113 102 111 111
Polygon -16777216 true false 166 100 166 90 167 76 174 67 188 63 197 61 208 53 212 68 217 78 218 98 207 110 194 117 185 115
Polygon -7500403 true true 168 106 167 91 168 77 175 68 189 64 198 62 209 54 213 69 218 79 219 99 208 111 195 118 186 116
Polygon -16777216 true false 204 138 214 138 228 137 237 130 241 116 243 107 251 96 236 92 226 87 206 86 194 97 187 110 189 119
Polygon -7500403 true true 204 140 214 140 228 139 237 132 241 118 243 109 251 98 236 94 226 89 206 88 194 99 187 112 189 128
Polygon -16777216 true false 203 125 216 120 227 121 237 131 243 140 252 151 264 159 246 167 232 176 223 181 211 180 199 175 196 160 196 143
Polygon -7500403 true true 201 124 214 119 225 120 235 130 241 139 250 150 262 158 244 166 230 175 221 180 209 179 197 174 194 159 194 142
Polygon -16777216 true false 159 207 159 217 160 231 167 240 181 244 190 246 201 254 205 239 210 229 211 209 200 197 187 190 178 192
Polygon -7500403 true true 157 208 157 218 158 232 165 241 179 245 188 247 199 255 203 240 208 230 209 210 198 198 185 191 171 193
Polygon -16777216 true false 175 203 180 216 179 227 169 237 160 243 149 252 141 264 133 246 124 232 119 223 120 211 125 199 140 196 157 196
Polygon -7500403 true true 173 202 178 215 177 226 167 236 158 242 147 251 139 263 131 245 122 231 117 222 118 210 123 198 138 195 155 195
Polygon -16777216 true false 133 199 133 209 132 223 125 232 111 236 102 238 91 246 87 231 82 221 81 201 92 189 105 182 114 184
Polygon -7500403 true true 128 190 132 208 131 222 124 231 110 235 101 237 90 245 86 230 81 220 80 200 91 188 104 181 113 183
Polygon -16777216 true false 96 162 86 162 72 163 63 170 59 184 57 193 49 204 64 208 74 213 94 214 106 203 113 190 111 181
Polygon -7500403 true true 95 161 85 161 71 162 62 169 58 183 56 192 48 203 63 207 73 212 93 213 105 202 112 189 110 172
Polygon -16777216 true false 97 175 84 180 73 179 63 169 57 160 48 149 36 141 54 133 68 124 77 119 89 120 101 125 104 140 104 157
Polygon -7500403 true true 94 175 81 180 70 179 60 169 54 160 45 149 33 141 51 133 65 124 74 119 86 120 98 125 101 140 101 157
Polygon -16777216 true false 180 103 196 84 186 101
Polygon -16777216 true false 103 120 84 104 101 114
Polygon -16777216 true false 197 180 216 196 199 186
Polygon -16777216 true false 120 197 104 216 114 199
Polygon -16777216 true false 61 146 81 144 94 155 80 148
Polygon -16777216 true false 156 67 148 80 145 94 151 81
Polygon -16777216 true false 144 233 152 220 155 206 149 219
Polygon -16777216 true false 233 156 220 148 206 145 219 151
Polygon -16777216 true false 100 176 90 190 71 194 87 188
Polygon -16777216 true false 200 124 210 110 229 106 213 112
Polygon -16777216 true false 112 76 124 103 118 83
Polygon -16777216 true false 188 224 176 197 182 217
Circle -1184463 true false 112 113 76
Circle -10899396 true false 121 122 58

sunflower-4
true
0
Circle -14835848 true false 90 90 120
Polygon -16777216 true false 203 168 213 168 227 169 236 176 240 190 242 199 250 210 235 214 225 219 205 220 193 209 186 196 188 187
Polygon -7500403 true true 200 168 210 168 224 169 233 176 237 190 239 199 247 210 232 214 222 219 202 220 190 209 183 196 185 187
Polygon -16777216 true false 142 93 142 83 141 69 134 60 120 56 111 54 100 46 96 61 91 71 90 91 101 103 114 110 123 108
Polygon -7500403 true true 144 93 144 83 143 69 136 60 122 56 113 54 102 46 98 61 93 71 92 91 103 103 116 110 125 108
Polygon -16777216 true false 125 97 120 84 121 73 131 63 140 57 151 48 159 36 167 54 176 68 181 77 180 89 175 101 160 104 143 104
Polygon -7500403 true true 126 97 121 84 122 73 132 63 141 57 152 48 160 36 168 54 177 68 182 77 181 89 176 101 161 104 144 104
Polygon -16777216 true false 97 129 87 129 73 128 64 121 60 107 58 98 50 87 65 83 75 78 95 77 107 88 114 101 112 110
Polygon -7500403 true true 96 130 86 130 72 129 63 122 59 108 57 99 49 88 64 84 74 79 94 78 106 89 113 102 111 111
Polygon -16777216 true false 166 100 166 90 167 76 174 67 188 63 197 61 208 53 212 68 217 78 218 98 207 110 194 117 185 115
Polygon -7500403 true true 167 101 167 91 168 77 175 68 189 64 198 62 209 54 213 69 218 79 219 99 208 111 195 118 186 116
Polygon -16777216 true false 204 138 214 138 228 137 237 130 241 116 243 107 251 96 236 92 226 87 206 86 194 97 187 110 189 119
Polygon -7500403 true true 204 140 214 140 228 139 237 132 241 118 243 109 251 98 236 94 226 89 206 88 194 99 187 112 189 121
Polygon -16777216 true false 203 125 216 120 227 121 237 131 243 140 252 151 264 159 246 167 232 176 223 181 211 180 199 175 196 160 196 143
Polygon -7500403 true true 201 124 214 119 225 120 235 130 241 139 250 150 262 158 244 166 230 175 221 180 209 179 197 174 194 159 194 142
Polygon -16777216 true false 159 207 159 217 160 231 167 240 181 244 190 246 201 254 205 239 210 229 211 209 200 197 187 190 178 192
Polygon -7500403 true true 157 208 157 218 158 232 165 241 179 245 188 247 199 255 203 240 208 230 209 210 198 198 185 191 176 193
Polygon -16777216 true false 175 203 180 216 179 227 169 237 160 243 149 252 141 264 133 246 124 232 119 223 120 211 125 199 140 196 157 196
Polygon -7500403 true true 173 203 178 216 177 227 167 237 158 243 147 252 139 264 131 246 122 232 117 223 118 211 123 199 138 196 155 196
Polygon -16777216 true false 133 199 133 209 132 223 125 232 111 236 102 238 91 246 87 231 82 221 81 201 92 189 105 182 114 184
Polygon -7500403 true true 132 198 132 208 131 222 124 231 110 235 101 237 90 245 86 230 81 220 80 200 91 188 104 181 113 183
Polygon -16777216 true false 96 162 86 162 72 163 63 170 59 184 57 193 49 204 64 208 74 213 94 214 106 203 113 190 111 181
Polygon -7500403 true true 95 161 85 161 71 162 62 169 58 183 56 192 48 203 63 207 73 212 93 213 105 202 112 189 110 180
Polygon -16777216 true false 97 175 84 180 73 179 63 169 57 160 48 149 36 141 54 133 68 124 77 119 89 120 101 125 104 140 104 157
Polygon -7500403 true true 94 175 81 180 70 179 60 169 54 160 45 149 33 141 51 133 65 124 74 119 86 120 98 125 101 140 101 157
Polygon -16777216 true false 180 103 196 84 186 101
Polygon -16777216 true false 103 120 84 104 101 114
Polygon -16777216 true false 197 180 216 196 199 186
Polygon -16777216 true false 120 197 104 216 114 199
Polygon -16777216 true false 61 146 81 144 94 155 80 148
Polygon -16777216 true false 156 67 148 80 145 94 151 81
Polygon -16777216 true false 144 233 152 220 155 206 149 219
Polygon -16777216 true false 233 156 220 148 206 145 219 151
Polygon -16777216 true false 100 176 90 190 71 194 87 188
Polygon -16777216 true false 200 124 210 110 229 106 213 112
Polygon -16777216 true false 112 76 124 103 118 83
Polygon -16777216 true false 188 224 176 197 182 217
Circle -5825686 true false 110 110 80
Circle -16777216 true false 136 136 28
Circle -16777216 true false 162 159 8
Circle -16777216 true false 160 132 8
Circle -16777216 true false 135 128 8
Circle -16777216 true false 127 152 8
Circle -16777216 true false 149 166 8
Circle -16777216 true false 166 146 8
Circle -16777216 true false 148 126 8
Circle -16777216 true false 127 139 8
Circle -16777216 true false 118 146 8
Circle -16777216 true false 160 170 8
Circle -16777216 true false 171 136 8
Circle -16777216 true false 140 117 8
Circle -16777216 true false 123 128 8
Circle -16777216 true false 135 163 8
Circle -16777216 true false 173 156 8
Circle -16777216 true false 159 121 8
Circle -16777216 true false 152 111 8
Circle -16777216 true false 113 135 8
Circle -16777216 true false 141 173 8
Circle -16777216 true false 180 145 8
Circle -16777216 true false 171 124 8
Circle -16777216 true false 127 116 8
Circle -16777216 true false 124 164 8
Circle -16777216 true false 165 180 8
Circle -16777216 true false 171 168 8
Circle -16777216 true false 165 109 8
Circle -16777216 true false 113 120 8
Circle -16777216 true false 128 174 8
Circle -16777216 true false 152 178 8
Circle -16777216 true false 183 130 8
Circle -16777216 true false 137 106 8
Circle -16777216 true false 114 157 8
Circle -16777216 true false 183 160 8
Circle -16777216 true false 139 184 8
Circle -16777216 true false 115 170 8
Circle -16777216 true false 106 146 8

sunflower-5
true
0
Circle -14835848 true false 90 90 120
Polygon -7500403 true true 104 217 102 227 109 224 107 233 111 227 112 235 117 231 120 239 124 234 127 239 134 231 139 222 144 206 133 195 121 191 110 200 99 211 99 218
Circle -5825686 true false 110 110 80
Circle -16777216 true false 136 136 28
Circle -16777216 true false 162 159 8
Circle -16777216 true false 160 132 8
Circle -16777216 true false 135 128 8
Circle -16777216 true false 127 152 8
Circle -16777216 true false 149 166 8
Circle -16777216 true false 166 146 8
Circle -16777216 true false 148 126 8
Circle -16777216 true false 127 139 8
Circle -16777216 true false 118 146 8
Circle -16777216 true false 160 170 8
Circle -16777216 true false 171 136 8
Circle -16777216 true false 140 117 8
Circle -16777216 true false 123 128 8
Circle -16777216 true false 135 163 8
Circle -16777216 true false 173 156 8
Circle -16777216 true false 159 121 8
Circle -16777216 true false 152 111 8
Circle -16777216 true false 113 135 8
Circle -16777216 true false 141 173 8
Circle -16777216 true false 180 145 8
Circle -16777216 true false 171 124 8
Circle -16777216 true false 127 116 8
Circle -16777216 true false 124 164 8
Circle -16777216 true false 165 180 8
Circle -16777216 true false 171 168 8
Circle -16777216 true false 165 109 8
Circle -16777216 true false 113 120 8
Circle -16777216 true false 128 174 8
Circle -16777216 true false 152 178 8
Circle -16777216 true false 183 130 8
Circle -16777216 true false 137 106 8
Circle -16777216 true false 114 157 8
Circle -16777216 true false 183 160 8
Circle -16777216 true false 139 184 8
Circle -16777216 true false 115 170 8
Circle -16777216 true false 106 146 8
Polygon -7500403 true true 137 235 140 242 144 237 147 242 151 237 156 242 158 237 162 241 166 237 169 240 173 234 172 226 172 216 168 202 157 196 144 194 132 207 132 222 131 239
Polygon -7500403 true true 132 61 135 54 139 59 142 54 146 59 151 54 153 59 157 55 161 59 164 56 168 62 167 70 167 80 163 94 152 100 139 102 127 89 127 74 126 57
Polygon -7500403 true true 61 162 54 159 59 155 54 152 59 148 54 143 59 141 55 137 59 133 56 130 62 126 70 127 80 127 94 131 100 142 102 155 89 167 74 167 57 168
Polygon -7500403 true true 237 161 244 158 239 154 244 151 239 147 244 142 239 140 243 136 239 132 242 129 236 125 228 126 218 126 204 130 196 139 196 154 209 166 224 166 241 167
Polygon -7500403 true true 76 105 66 103 69 110 60 108 66 112 58 113 62 118 54 121 59 125 54 128 62 135 71 140 97 145 102 133 105 122 93 111 82 100 75 100
Polygon -7500403 true true 100 80 98 70 105 73 103 64 107 70 108 62 113 66 116 58 120 63 123 58 130 66 135 75 140 97 131 104 120 111 108 103 95 86 95 79
Polygon -7500403 true true 219 102 229 100 226 107 235 105 229 109 237 110 233 115 241 118 236 122 241 125 233 132 224 137 208 142 197 131 193 119 202 108 213 97 220 97
Polygon -7500403 true true 198 217 200 227 193 224 195 233 191 227 190 235 185 231 182 239 178 234 175 239 168 231 163 222 158 206 169 195 181 191 192 200 203 211 203 218
Polygon -7500403 true true 78 192 68 194 71 187 62 189 68 185 60 184 64 179 56 176 61 172 56 169 64 162 73 157 89 152 100 163 104 175 95 186 84 197 77 197
Polygon -7500403 true true 199 79 201 69 194 72 196 63 192 69 191 61 186 65 183 57 179 62 176 57 169 65 164 74 159 90 170 101 182 105 193 96 204 85 204 78
Polygon -7500403 true true 217 192 227 194 224 187 233 189 227 185 235 184 231 179 239 176 234 172 239 169 231 162 222 157 206 152 195 163 191 175 200 186 211 197 218 197
Polygon -7500403 true true 87 211 80 213 82 206 76 206 74 202 86 185 99 181 109 182 116 186 121 195 115 210 105 221 94 223 95 214 88 218
Polygon -7500403 true true 85 88 83 81 90 83 90 77 94 75 111 87 115 100 114 110 110 117 101 122 86 116 75 106 73 95 82 96 78 89
Polygon -7500403 true true 218 88 225 86 223 93 229 93 231 97 219 114 206 118 196 117 189 113 184 104 190 89 200 78 211 76 210 85 217 81
Polygon -7500403 true true 215 210 217 217 210 215 210 221 206 223 189 211 185 198 186 188 190 181 199 176 214 182 225 192 227 203 218 202 222 209

target
false
0
Circle -7500403 true true 0 0 300
Circle -16777216 true false 30 30 240
Circle -7500403 true true 60 60 180
Circle -16777216 true false 90 90 120
Circle -7500403 true true 120 120 60

tile brick
false
0
Rectangle -1 true false 0 0 300 300
Rectangle -7500403 true true 15 225 150 285
Rectangle -7500403 true true 165 225 300 285
Rectangle -7500403 true true 75 150 210 210
Rectangle -7500403 true true 0 150 60 210
Rectangle -7500403 true true 225 150 300 210
Rectangle -7500403 true true 165 75 300 135
Rectangle -7500403 true true 15 75 150 135
Rectangle -7500403 true true 0 0 60 60
Rectangle -7500403 true true 225 0 300 60
Rectangle -7500403 true true 75 0 210 60

tree
false
0
Circle -7500403 true true 118 3 94
Rectangle -6459832 true false 120 195 180 300
Circle -7500403 true true 65 21 108
Circle -7500403 true true 116 41 127
Circle -7500403 true true 45 90 120
Circle -7500403 true true 104 74 152

triangle
false
0
Polygon -7500403 true true 150 30 15 255 285 255

triangle 2
false
0
Polygon -7500403 true true 150 30 15 255 285 255
Polygon -16777216 true false 151 99 225 223 75 224

truck
false
0
Rectangle -7500403 true true 4 45 195 187
Polygon -7500403 true true 296 193 296 150 259 134 244 104 208 104 207 194
Rectangle -1 true false 195 60 195 105
Polygon -16777216 true false 238 112 252 141 219 141 218 112
Circle -16777216 true false 234 174 42
Rectangle -7500403 true true 181 185 214 194
Circle -16777216 true false 144 174 42
Circle -16777216 true false 24 174 42
Circle -7500403 false true 24 174 42
Circle -7500403 false true 144 174 42
Circle -7500403 false true 234 174 42

turtle
true
0
Polygon -10899396 true false 215 204 240 233 246 254 228 266 215 252 193 210
Polygon -10899396 true false 195 90 225 75 245 75 260 89 269 108 261 124 240 105 225 105 210 105
Polygon -10899396 true false 105 90 75 75 55 75 40 89 31 108 39 124 60 105 75 105 90 105
Polygon -10899396 true false 132 85 134 64 107 51 108 17 150 2 192 18 192 52 169 65 172 87
Polygon -10899396 true false 85 204 60 233 54 254 72 266 85 252 107 210
Polygon -7500403 true true 119 75 179 75 209 101 224 135 220 225 175 261 128 261 81 224 74 135 88 99

wasp
true
0
Polygon -1184463 true false 149 93 120 135 105 180 105 210 120 240 150 270 150 270 180 240 195 210 195 180 180 135
Rectangle -16777216 true false 120 150 180 165
Polygon -16777216 true false 120 180 120 195 180 195 180 180
Polygon -16777216 true false 120 225 180 225 180 210 120 210
Polygon -6459832 true false 150 135 131 112 105 75 120 60 180 60 195 75 166 113 150 135
Polygon -6459832 true false 150 15 120 30 120 60 180 60 180 30
Circle -16777216 true false 105 30 30
Circle -16777216 true false 165 30 30
Polygon -7500403 true true 120 90 75 105 15 90 30 75 120 75
Polygon -7500403 true true 180 75 180 90 225 105 285 90 270 75
Polygon -7500403 true true 120 90 120 105 105 135 60 210 30 225 15 225 15 165 45 120
Polygon -16777216 true false 150 300 150 300 165 240 135 240
Polygon -7500403 true true 180 90 180 105 195 135 240 210 270 225 285 225 285 165 255 120

weed
false
0
Polygon -7500403 true true 235 289 63 289 51 249 39 240 19 236 41 229 52 227 82 248 57 209 42 192 28 179 12 170 43 175 68 189 85 200 105 242 74 174 112 218 76 143 29 110 93 131 135 202 111 110 75 40 128 101 155 172 158 207 151 81 166 173 167 203 173 158 188 128 216 104 254 91 215 133 198 163 191 194 219 157 282 142 243 161 219 194 203 226 253 178 213 241 253 208 288 205 257 225 247 241 239 263

wheel
false
0
Circle -7500403 true true 3 3 294
Circle -16777216 true false 30 30 240
Line -7500403 true 150 285 150 15
Line -7500403 true 15 150 285 150
Circle -7500403 true true 120 120 60
Line -7500403 true 216 40 79 269
Line -7500403 true 40 84 269 221
Line -7500403 true 40 216 269 79
Line -7500403 true 84 40 221 269

wolf
false
0
Polygon -16777216 true false 253 133 245 131 245 133
Polygon -7500403 true true 2 194 13 197 30 191 38 193 38 205 20 226 20 257 27 265 38 266 40 260 31 253 31 230 60 206 68 198 75 209 66 228 65 243 82 261 84 268 100 267 103 261 77 239 79 231 100 207 98 196 119 201 143 202 160 195 166 210 172 213 173 238 167 251 160 248 154 265 169 264 178 247 186 240 198 260 200 271 217 271 219 262 207 258 195 230 192 198 210 184 227 164 242 144 259 145 284 151 277 141 293 140 299 134 297 127 273 119 270 105
Polygon -7500403 true true -1 195 14 180 36 166 40 153 53 140 82 131 134 133 159 126 188 115 227 108 236 102 238 98 268 86 269 92 281 87 269 103 269 113

x
false
0
Polygon -7500403 true true 270 75 225 30 30 225 75 270
Polygon -7500403 true true 30 75 75 30 270 225 225 270
@#$#@#$#@
NetLogo 6.2.2
@#$#@#$#@
@#$#@#$#@
@#$#@#$#@
@#$#@#$#@
@#$#@#$#@
default
0.0
-0.2 0 0.0 1.0
0.0 1 1.0 0.0
0.2 0 0.0 1.0
link direction
true
0
Line -7500403 true 150 150 90 180
Line -7500403 true 150 150 210 180
@#$#@#$#@
0
@#$#@#$#@
