extensions [bitmap qtj]
breed [vectors vector]
breed [balls ball]
vectors-own [vector-size head-turtle]
balls-own [speed energy last-collision last-vector]
patches-own [cluster previous-color]
globals [ circle-patches line-patches wall-patches circle-clusters line-clusters max-tick-delta background-color]

to reset-image
  clear-all
  set background-color 9.9
  ask patches [set cluster nobody set pcolor background-color]
  set-default-shape balls "circle 2"
  set-default-shape vectors "circle 2"
  reset-ticks
end

to reset-background
  ask patches [set pcolor background-color]
end

to import-image
  let myimage "images/random-balls.png"
  if image-file = "random-balls" [set myimage "images/random-balls.png"]
  if image-file = "force-field" [set myimage "images/force-field.png"]
  if image-file = "current" [set myimage "images/current.png"]
  import-pcolors myimage
end 

to normalize-colors
 set circle-patches patches with [(pcolor > 11 and pcolor < 18) or (pcolor > 121 and pcolor < 128) or (pcolor > 131 and pcolor < 138)]
 set line-patches patches with [shade-of? blue pcolor = true]
 set wall-patches patches with [pcolor >= 0 and pcolor <= 1]
 reset-background
 ask circle-patches [set pcolor 15]
 ask line-patches [set pcolor 105]
 ask wall-patches [set pcolor 0]
end


to detect-clusters  
  let drawing-patches (patch-set circle-patches line-patches)
  if any? drawing-patches with [cluster = nobody] [
    let counter 1
    set circle-clusters []
    set line-clusters []
    loop [
      let seed one-of drawing-patches with [cluster = nobody]
      if seed = nobody [ stop ] 
      ask seed
      [ set cluster counter
        grow-cluster 
        ifelse pcolor = red [set circle-clusters lput counter circle-clusters] 
           [set line-clusters lput counter line-clusters]
        ]
    set counter counter + 1
    ]
  ]
end

to grow-cluster  ;; patch procedure
  ;ask neighbors with [(cluster = nobody) and
  ask patches in-radius 2 with [(cluster = nobody) and
    ;ask neighbors4 with [(cluster = nobody) and
    (pcolor = [pcolor] of myself)]
  [ set cluster [cluster] of myself
    grow-cluster ]
end

to convert-to-turtles
  reset-background
  ask wall-patches [set pcolor 0]
  foreach circle-clusters [
    if count (patches with [cluster = ?]) > 5 [generate-circles patches with [cluster = ?]]
  ]
  
  foreach line-clusters [
    if count (patches with [cluster = ?]) > 5 [generate-lines patches with [cluster = ?] ?]
  ]
end

to generate-circles [shape-patch-set]
  let max-x-point max [pxcor] of shape-patch-set
  let min-x-point min [pxcor] of shape-patch-set
  let max-y-point max [pycor] of shape-patch-set
  let min-y-point min [pycor] of shape-patch-set

  let radius (max-x-point - min-x-point + max-y-point - min-y-point) / 4 ; find approximate radius for the circle
  let center-x ((max-x-point + min-x-point) / 2)
  let center-y ((max-y-point + min-y-point) / 2)
  
  let center-patch patch center-x center-y ;center of circle
  
  let std-to-center (standard-deviation ([distance center-patch] of shape-patch-set) / (mean [distance center-patch] of shape-patch-set))
  
  if std-to-center < std-to-center-threshold [
    create-balls 1 [
      setxy center-x center-y 
      set size (radius * 2)
      set color red
      set speed 0
      set heading 0
      set last-vector -1 * vector-refresh
      ]
  ] 
end

to generate-lines [shape-patch-set cluster_]
  let max-x-point max [pxcor] of shape-patch-set
  let min-x-point min [pxcor] of shape-patch-set
  let max-y-point max [pycor] of shape-patch-set
  let min-y-point min [pycor] of shape-patch-set
  
  let center-patch patch ((max-x-point + min-x-point) / 2) ((max-y-point + min-y-point) / 2)

  let end-patch1 (max-one-of shape-patch-set [distance center-patch]) ;end-patches are the tip and end patches
  
  let end-patch2 (max-one-of shape-patch-set [distance end-patch1])
  
  let head-patch max-one-of (patch-set end-patch1 end-patch2) [count shape-patch-set in-radius 3] ;with the arrow shape there are more patches

  let bottom-patch min-one-of (patch-set end-patch1 end-patch2) [count shape-patch-set in-radius 3] ;the tip-patch has the arrow head

  let new-vector nobody
  
    create-vectors 1 [
      setxy [pxcor] of bottom-patch [pycor]  of bottom-patch
      set size 2
      set color blue
      set vector-size sqrt ((max-x-point - min-x-point) ^ 2 + (max-y-point - min-y-point) ^ 2)
      set new-vector self
    ]
      ask head-patch [sprout 1 [
        set shape "default"
        set size 5
        set color blue
        set heading (180 + towards new-vector)
        create-link-from new-vector [set shape "vector" set color blue]
        ask new-vector [set head-turtle myself set heading [heading] of myself]
    ]
      ]
end 

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;Below is the physics simulator. The code above is used for recognizing shapes and converting them into turtles
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;


to setup
 ; set max-tick-delta 2;0.1073
  ask balls [set speed 0 set heading 0]
  ;set tick-delta 1
  reset-ticks
end

to go
  ask balls [move]
  tick-advance tick-delta
end

to move 
    let radius size / 2
    ifelse pen-down? = true [pendown][penup]
    let vector-range (radius) + 5
    
    let is-vector? (any? vectors in-radius vector-range and (ticks - last-vector > vector-refresh))
    let is-friction? (friction > 0)
    
    if is-vector? or gravity > 0 [
      
      let x-speed speed * cos heading
      let y-speed speed * sin heading
      
      if is-vector? [
        ask vectors in-radius vector-range [
  
          set x-speed (x-speed + (vector-size * (cos heading) * tick-delta) / [size] of myself)
          set y-speed (y-speed + (vector-size * (sin heading) * tick-delta) / [size] of myself)
  
          if remove-vectors-on-hit? = true [ask head-turtle [die] die]
          
          
        ]
         set last-vector ticks     
      ] 
      
      if gravity > 0 [ set x-speed (x-speed - 0.0001 * gravity) ]
      set speed sqrt (x-speed ^ 2 + y-speed ^ 2)
      if not (x-speed = 0 and y-speed = 0) [set heading atan  y-speed x-speed]
      
    ]
      if friction > 0 [set speed speed * (1 - friction)]
      
   

;;;BOUNCE
  if (not horizontal-wrap? and abs xcor + radius >= max-pxcor) or ([pcolor] of patch (xcor + radius) ycor = 0) or ([pcolor] of patch (xcor - radius) ycor = 0) [set heading (-1 * heading) ]
  
  if (not vertical-wrap? and abs ycor + radius >= max-pycor) or ([pcolor] of patch xcor (ycor + radius) = 0) or ([pcolor] of patch xcor (ycor - radius) = 0) [set heading (180 - heading) ]
  
  
  fd speed * tick-delta
  
end

  
@#$#@#$#@
GRAPHICS-WINDOW
402
10
955
404
90
60
3.0
1
10
1
1
1
0
1
1
1
-90
90
-60
60
0
0
1
ticks
30.0

BUTTON
963
49
1045
82
draw-balls
if mouse-inside? and mouse-down?[\\n ask patch mouse-xcor mouse-ycor [ask neighbors4 [set pcolor 15]]]
T
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

BUTTON
11
253
263
287
convert-to-turtles
convert-to-turtles\\n
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

BUTTON
13
10
328
43
NIL
reset-image
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

BUTTON
197
54
325
97
import image file
import-image\\nask patches [set previous-color pcolor]
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

BUTTON
13
175
264
208
NIL
normalize-colors
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

BUTTON
12
214
264
247
NIL
detect-clusters
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

BUTTON
962
87
1046
120
draw-vectors
if mouse-inside? and mouse-down?[\\n ask patch mouse-xcor mouse-ycor [ask neighbors4 [set pcolor 105]]]
T
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

BUTTON
13
54
94
87
start webcam
qtj:camera-start world-width world-width
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

BUTTON
101
54
179
87
stop webcam
qtj:camera-stop
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

BUTTON
13
92
180
125
get image from webcam
bitmap:copy-to-pcolors qtj:camera-image false\\ntick\\nif (ticks mod 10) = 0 [display]
T
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

BUTTON
13
130
181
163
convert to pcolor
ask patches [if pcolor != 0 and pcolor != 9.9 [set pcolor (approximate-rgb (item 0 pcolor) (item 1 pcolor ) (item 2 pcolor))]]\\nask patches [set previous-color pcolor]
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

BUTTON
81
399
286
432
compare with original image
ask patches [set pcolor previous-color]
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

SLIDER
25
578
344
611
std-to-center-threshold
std-to-center-threshold
0
1
0.4
0.05
1
NIL
HORIZONTAL

BUTTON
80
437
285
470
clean background
ask patches [set pcolor background-color]\\nclear-drawing
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

BUTTON
9
337
386
370
NIL
go
T
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

BUTTON
10
295
264
328
setup
setup
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

BUTTON
333
10
388
332
DO ALL
reset-image\\nimport-image\\nask patches [set previous-color pcolor]\\nnormalize-colors\\ndetect-clusters\\nconvert-to-turtles\\nsetup
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

SWITCH
406
416
588
449
remove-vectors-on-hit?
remove-vectors-on-hit?
0
1
-1000

SWITCH
406
456
588
489
pen-down?
pen-down?
1
1
-1000

CHOOSER
197
117
324
162
image-file
image-file
"random-balls" "force-field" "current"
0

BUTTON
81
476
285
509
delete turtles
ask turtles [die]
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

SLIDER
787
416
911
449
friction
friction
0
0.0001
0
0.00001
1
NIL
HORIZONTAL

BUTTON
80
517
288
550
store image
ask patches [set previous-color pcolor ]
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

BUTTON
271
175
326
329
DO ALL
normalize-colors\\ndetect-clusters\\nconvert-to-turtles\\nsetup
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

SLIDER
597
498
778
531
tick-delta
tick-delta
0
0.1
0.05
0.005
1
NIL
HORIZONTAL

SLIDER
786
498
912
531
vector-refresh
vector-refresh
0
1000
0
50
1
NIL
HORIZONTAL

SWITCH
595
416
778
449
horizontal-wrap?
horizontal-wrap?
1
1
-1000

SWITCH
596
456
778
489
vertical-wrap?
vertical-wrap?
1
1
-1000

BUTTON
963
126
1047
159
draw-walls
if mouse-inside? and mouse-down?[\\n ask patch mouse-xcor mouse-ycor [ask (patch-set neighbors self) [set pcolor 0]]]
T
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

BUTTON
965
166
1048
199
eraser
if mouse-inside? and mouse-down?[\\n ask patch mouse-xcor mouse-ycor [ask patches in-radius 5 [set pcolor 9.9]]]
T
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

BUTTON
962
10
1044
43
NIL
reset-image
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

BUTTON
965
206
1049
239
DO ALL
normalize-colors\\ndetect-clusters\\nconvert-to-turtles\\nsetup
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

BUTTON
964
246
1048
279
NIL
go
T
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

SLIDER
787
456
911
489
gravity
gravity
0
100
1
1
1
NIL
HORIZONTAL

@#$#@#$#@
## WHAT IS IT?

(a general understanding of what the model is trying to show or explain)

## HOW IT WORKS

(what rules the agents use to create the overall behavior of the model)

## HOW TO USE IT

(how to use the model, including a description of each of the items in the Interface tab)

## THINGS TO NOTICE

(suggested things for the user to notice while running the model)

## THINGS TO TRY

(suggested things for the user to try to do (move sliders, switches, etc.) with the model)

## EXTENDING THE MODEL

(suggested things to add or change in the Code tab to make the model more complicated, detailed, accurate, etc.)

## NETLOGO FEATURES

(interesting or unusual features of NetLogo that the model uses, particularly in the Code tab; or where workarounds were needed for missing features)

## RELATED MODELS

(models in the NetLogo Models Library and elsewhere which are of related interest)

## CREDITS AND REFERENCES

(a reference to the model's URL on the web if it has one, as well as any other necessary credits, citations, and links)
@#$#@#$#@
default
true
0
Polygon -7500403 true true 150 5 40 250 150 205 260 250

airplane
true
0
Polygon -7500403 true true 150 0 135 15 120 60 120 105 15 165 15 195 120 180 135 240 105 270 120 285 150 270 180 285 210 270 165 240 180 180 285 195 285 165 180 105 180 60 165 15

arrow
false
0
Polygon -7500403 true true 0 300 150 0 300 300 150 180

box
false
0
Polygon -7500403 true true 150 285 285 225 285 75 150 135
Polygon -7500403 true true 150 135 15 75 150 15 285 75
Polygon -7500403 true true 15 75 15 225 150 285 150 135
Line -16777216 false 150 285 150 135
Line -16777216 false 150 135 15 75
Line -16777216 false 150 135 285 75

bug
true
0
Circle -7500403 true true 96 182 108
Circle -7500403 true true 110 127 80
Circle -7500403 true true 110 75 80
Line -7500403 true 150 100 80 30
Line -7500403 true 150 100 220 30

butterfly
true
0
Polygon -7500403 true true 150 165 209 199 225 225 225 255 195 270 165 255 150 240
Polygon -7500403 true true 150 165 89 198 75 225 75 255 105 270 135 255 150 240
Polygon -7500403 true true 139 148 100 105 55 90 25 90 10 105 10 135 25 180 40 195 85 194 139 163
Polygon -7500403 true true 162 150 200 105 245 90 275 90 290 105 290 135 275 180 260 195 215 195 162 165
Polygon -16777216 true false 150 255 135 225 120 150 135 120 150 105 165 120 180 150 165 225
Circle -16777216 true false 135 90 30
Line -16777216 false 150 105 195 60
Line -16777216 false 150 105 105 60

car
false
0
Polygon -7500403 true true 300 180 279 164 261 144 240 135 226 132 213 106 203 84 185 63 159 50 135 50 75 60 0 150 0 165 0 225 300 225 300 180
Circle -16777216 true false 180 180 90
Circle -16777216 true false 30 180 90
Polygon -16777216 true false 162 80 132 78 134 135 209 135 194 105 189 96 180 89
Circle -7500403 true true 47 195 58
Circle -7500403 true true 195 195 58

circle
false
0
Circle -7500403 true true 0 0 300

circle 2
false
0
Circle -7500403 true true 0 0 300
Circle -1 true false 15 15 270

circle 3
false
0
Circle -7500403 false true 0 0 300

cow
false
0
Polygon -7500403 true true 200 193 197 249 179 249 177 196 166 187 140 189 93 191 78 179 72 211 49 209 48 181 37 149 25 120 25 89 45 72 103 84 179 75 198 76 252 64 272 81 293 103 285 121 255 121 242 118 224 167
Polygon -7500403 true true 73 210 86 251 62 249 48 208
Polygon -7500403 true true 25 114 16 195 9 204 23 213 25 200 39 123

cylinder
false
0
Circle -7500403 true true 0 0 300

dot
false
0
Circle -7500403 true true 90 90 120

face happy
false
0
Circle -7500403 true true 8 8 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Polygon -16777216 true false 150 255 90 239 62 213 47 191 67 179 90 203 109 218 150 225 192 218 210 203 227 181 251 194 236 217 212 240

face neutral
false
0
Circle -7500403 true true 8 7 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Rectangle -16777216 true false 60 195 240 225

face sad
false
0
Circle -7500403 true true 8 8 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Polygon -16777216 true false 150 168 90 184 62 210 47 232 67 244 90 220 109 205 150 198 192 205 210 220 227 242 251 229 236 206 212 183

fish
false
0
Polygon -1 true false 44 131 21 87 15 86 0 120 15 150 0 180 13 214 20 212 45 166
Polygon -1 true false 135 195 119 235 95 218 76 210 46 204 60 165
Polygon -1 true false 75 45 83 77 71 103 86 114 166 78 135 60
Polygon -7500403 true true 30 136 151 77 226 81 280 119 292 146 292 160 287 170 270 195 195 210 151 212 30 166
Circle -16777216 true false 215 106 30

flag
false
0
Rectangle -7500403 true true 60 15 75 300
Polygon -7500403 true true 90 150 270 90 90 30
Line -7500403 true 75 135 90 135
Line -7500403 true 75 45 90 45

flower
false
0
Polygon -10899396 true false 135 120 165 165 180 210 180 240 150 300 165 300 195 240 195 195 165 135
Circle -7500403 true true 85 132 38
Circle -7500403 true true 130 147 38
Circle -7500403 true true 192 85 38
Circle -7500403 true true 85 40 38
Circle -7500403 true true 177 40 38
Circle -7500403 true true 177 132 38
Circle -7500403 true true 70 85 38
Circle -7500403 true true 130 25 38
Circle -7500403 true true 96 51 108
Circle -16777216 true false 113 68 74
Polygon -10899396 true false 189 233 219 188 249 173 279 188 234 218
Polygon -10899396 true false 180 255 150 210 105 210 75 240 135 240

house
false
0
Rectangle -7500403 true true 45 120 255 285
Rectangle -16777216 true false 120 210 180 285
Polygon -7500403 true true 15 120 150 15 285 120
Line -16777216 false 30 120 270 120

leaf
false
0
Polygon -7500403 true true 150 210 135 195 120 210 60 210 30 195 60 180 60 165 15 135 30 120 15 105 40 104 45 90 60 90 90 105 105 120 120 120 105 60 120 60 135 30 150 15 165 30 180 60 195 60 180 120 195 120 210 105 240 90 255 90 263 104 285 105 270 120 285 135 240 165 240 180 270 195 240 210 180 210 165 195
Polygon -7500403 true true 135 195 135 240 120 255 105 255 105 285 135 285 165 240 165 195

line
true
0
Line -7500403 true 150 0 150 300

line half
true
0
Line -7500403 true 150 0 150 150

pentagon
false
0
Polygon -7500403 true true 150 15 15 120 60 285 240 285 285 120

person
false
0
Circle -7500403 true true 110 5 80
Polygon -7500403 true true 105 90 120 195 90 285 105 300 135 300 150 225 165 300 195 300 210 285 180 195 195 90
Rectangle -7500403 true true 127 79 172 94
Polygon -7500403 true true 195 90 240 150 225 180 165 105
Polygon -7500403 true true 105 90 60 150 75 180 135 105

plant
false
0
Rectangle -7500403 true true 135 90 165 300
Polygon -7500403 true true 135 255 90 210 45 195 75 255 135 285
Polygon -7500403 true true 165 255 210 210 255 195 225 255 165 285
Polygon -7500403 true true 135 180 90 135 45 120 75 180 135 210
Polygon -7500403 true true 165 180 165 210 225 180 255 120 210 135
Polygon -7500403 true true 135 105 90 60 45 45 75 105 135 135
Polygon -7500403 true true 165 105 165 135 225 105 255 45 210 60
Polygon -7500403 true true 135 90 120 45 150 15 180 45 165 90

sheep
false
15
Circle -1 true true 203 65 88
Circle -1 true true 70 65 162
Circle -1 true true 150 105 120
Polygon -7500403 true false 218 120 240 165 255 165 278 120
Circle -7500403 true false 214 72 67
Rectangle -1 true true 164 223 179 298
Polygon -1 true true 45 285 30 285 30 240 15 195 45 210
Circle -1 true true 3 83 150
Rectangle -1 true true 65 221 80 296
Polygon -1 true true 195 285 210 285 210 240 240 210 195 210
Polygon -7500403 true false 276 85 285 105 302 99 294 83
Polygon -7500403 true false 219 85 210 105 193 99 201 83

square
false
0
Rectangle -7500403 true true 30 30 270 270

square 2
false
0
Rectangle -7500403 true true 30 30 270 270
Rectangle -16777216 true false 60 60 240 240

star
false
0
Polygon -7500403 true true 151 1 185 108 298 108 207 175 242 282 151 216 59 282 94 175 3 108 116 108

target
false
0
Circle -7500403 true true 0 0 300
Circle -16777216 true false 30 30 240
Circle -7500403 true true 60 60 180
Circle -16777216 true false 90 90 120
Circle -7500403 true true 120 120 60

tree
false
0
Circle -7500403 true true 118 3 94
Rectangle -6459832 true false 120 195 180 300
Circle -7500403 true true 65 21 108
Circle -7500403 true true 116 41 127
Circle -7500403 true true 45 90 120
Circle -7500403 true true 104 74 152

triangle
false
0
Polygon -7500403 true true 150 30 15 255 285 255

triangle 2
false
0
Polygon -7500403 true true 150 30 15 255 285 255
Polygon -16777216 true false 151 99 225 223 75 224

truck
false
0
Rectangle -7500403 true true 4 45 195 187
Polygon -7500403 true true 296 193 296 150 259 134 244 104 208 104 207 194
Rectangle -1 true false 195 60 195 105
Polygon -16777216 true false 238 112 252 141 219 141 218 112
Circle -16777216 true false 234 174 42
Rectangle -7500403 true true 181 185 214 194
Circle -16777216 true false 144 174 42
Circle -16777216 true false 24 174 42
Circle -7500403 false true 24 174 42
Circle -7500403 false true 144 174 42
Circle -7500403 false true 234 174 42

turtle
true
0
Polygon -10899396 true false 215 204 240 233 246 254 228 266 215 252 193 210
Polygon -10899396 true false 195 90 225 75 245 75 260 89 269 108 261 124 240 105 225 105 210 105
Polygon -10899396 true false 105 90 75 75 55 75 40 89 31 108 39 124 60 105 75 105 90 105
Polygon -10899396 true false 132 85 134 64 107 51 108 17 150 2 192 18 192 52 169 65 172 87
Polygon -10899396 true false 85 204 60 233 54 254 72 266 85 252 107 210
Polygon -7500403 true true 119 75 179 75 209 101 224 135 220 225 175 261 128 261 81 224 74 135 88 99

vector
true
0
Line -7500403 true 150 45 150 270
Polygon -7500403 true true 120 45 150 0 180 45
Circle -7500403 false true 135 270 30

wheel
false
0
Circle -7500403 true true 3 3 294
Circle -16777216 true false 30 30 240
Line -7500403 true 150 285 150 15
Line -7500403 true 15 150 285 150
Circle -7500403 true true 120 120 60
Line -7500403 true 216 40 79 269
Line -7500403 true 40 84 269 221
Line -7500403 true 40 216 269 79
Line -7500403 true 84 40 221 269

wolf
false
0
Polygon -16777216 true false 253 133 245 131 245 133
Polygon -7500403 true true 2 194 13 197 30 191 38 193 38 205 20 226 20 257 27 265 38 266 40 260 31 253 31 230 60 206 68 198 75 209 66 228 65 243 82 261 84 268 100 267 103 261 77 239 79 231 100 207 98 196 119 201 143 202 160 195 166 210 172 213 173 238 167 251 160 248 154 265 169 264 178 247 186 240 198 260 200 271 217 271 219 262 207 258 195 230 192 198 210 184 227 164 242 144 259 145 284 151 277 141 293 140 299 134 297 127 273 119 270 105
Polygon -7500403 true true -1 195 14 180 36 166 40 153 53 140 82 131 134 133 159 126 188 115 227 108 236 102 238 98 268 86 269 92 281 87 269 103 269 113

x
false
0
Polygon -7500403 true true 270 75 225 30 30 225 75 270
Polygon -7500403 true true 30 75 75 30 270 225 225 270

@#$#@#$#@
NetLogo 5.0.2
@#$#@#$#@
@#$#@#$#@
@#$#@#$#@
@#$#@#$#@
@#$#@#$#@
default
0.0
-0.2 1 1.0 0.0
0.0 1 1.0 0.0
0.2 1 1.0 0.0
link direction
true
0
Line -7500403 true 150 150 90 180
Line -7500403 true 150 150 210 180

vector
0.0
-0.2 0 0.0 1.0
0.0 1 1.0 0.0
0.2 0 0.0 1.0
link direction
true
0

@#$#@#$#@
0
@#$#@#$#@
